/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.domainruntime.internal.DomainRuntimeServiceMBeanImpl;
import weblogic.management.mbeanservers.internal.ServiceImplBeanInfo;
import weblogic.management.runtime.RuntimeMBean;

public class DomainRuntimeServiceMBeanImplBeanInfo
extends ServiceImplBeanInfo {
    public static Class INTERFACE_CLASS = DomainRuntimeServiceMBean.class;

    public DomainRuntimeServiceMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public DomainRuntimeServiceMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = DomainRuntimeServiceMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "9.0.0.0");
        beanDescriptor.setValue("package", "weblogic.management.mbeanservers.domainruntime.internal");
        String string = new String("<p>Provides a common access point for navigating to all runtime and configuration MBeans in the domain as well as to MBeans that provide domain-wide services (such as controlling and monitoring the life cycles of servers and message-driven EJBs and coordinating the migration of migratable services).</p>  <p>This MBean is available only on the Administration Server.</p>  <p>The <code>javax.management.ObjectName</code> of this MBean is \"<code>com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean</code>\".</p>  <p>This is the only object name that a JMX client needs to navigate the hierarchy available from this MBean.</p> <dl> <dt>Note:</dt>  <dd> <p>If your JMX client uses the Domain Runtime MBean Server to access runtime or configuration MBeans by constructing object names (instead of by using this <code>DomainRuntimeServiceMBean</code> to navigate the MBean hierarchy), the client must add a <code>Location=<i>servername</i></code> key property to the MBean object name. The MBean server uses this key property to route the JMX request to the appropriate WebLogic Server instance. If your client uses the <code>DomainRuntimeServiceMBean</code> to navigate the MBean hierarchy, the object names that it obtains automatically contain the location key property.</p> </dd> </dl> <p>To start navigating, a JMX client invokes the <code>javax.management.MBeanServerConnection.getAttribute()</code> method and passes the following as parameters:</p>  <ul> <li> <p>The <code>ObjectName</code> of this service MBean</p> </li>  <li> <p>A <code>String</code> representation for the name of an attribute in this MBean that contains the root of an MBean hierarchy</p> </li> </ul>  <p>This method call returns the <code>ObjectName</code> for the root MBean. To access MBeans below the root, the JMX client passes the root MBean's <code>ObjectName</code> and the name of a root MBean attribute that contains a child MBean to the <code>MBeanServerConnection.getAttribute()</code> method. This method call returns the <code>ObjectName</code> of the child MBean.</p>  <p>For example:<br clear=\"none\" /> <code>ObjectName drs = new ObjectName(\"com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean\");</code> <br clear=\"none\" /> <code>// Get the ObjectName of the domain's DomainMBean by getting the value<br clear=\"none\" /> // of the DomainRuntimeServiceMBean DomainConfiguration attribute<br clear=\"none\" /> ObjectName domainconfig =<br clear=\"none\" /> (ObjectName) MBeanServerConnection.getAttribute(drs, \"DomainConfiguration\");<br clear=\"none\" /> // Get the ObjectNames for all ServerMBeans in the domain by getting<br clear=\"none\" /> // the value of the DomainMBean Servers attribute<br clear=\"none\" /> ObjectName[] servers =<br clear=\"none\" /> (ObjectName[]) MBeanServerConnection.getAttribute(domainconfig, \"Servers\");</code></p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("rolePermitAll", Boolean.TRUE);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("DomainConfiguration")) {
            string2 = "getDomainConfiguration";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DomainConfiguration", DomainRuntimeServiceMBean.class, string2, string);
            map.put("DomainConfiguration", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains the active <code>DomainMBean</code> for the current WebLogic Server domain.</p>  <p>Get this MBean to learn about the active configuration of all servers and resources in the domain. Any command line options that were used to start servers in this domain override the values in this <code>DomainMBean</code>. For example, if you used a command line option to override a server's listen port, the <code>ServerMBean</code> that you navigate to from this <code>DomainMBean</code> will show the value persisted in the <code>config.xml</code> file; it will not show the value that was passed in the command line option.</p>  <dl> <dt>Note:</dt>  <dd> <p>The <code>DomainMBean</code> that can be accessed from this (<code>DomainRuntimeServiceMBean</code>) MBean attribute represents the active configuration of the domain and cannot be edited. The <i>pending</i> <code>DomainMBean</code>, which can be edited, is returned by the {@link weblogic.management.mbeanservers.edit.ConfigurationManagerMBean#startEdit startEdit} operation in the <code>ConfigurationManagerMBean</code>.</p> </dd> </dl> ");
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#findDomainConfiguration"), BeanInfoHelper.encodeEntities((String)"#findServerConfiguration")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("DomainPending")) {
            string2 = "getDomainPending";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DomainPending", DomainRuntimeServiceMBean.class, string2, string);
            map.put("DomainPending", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains a read-only version of the pending <code>DomainMBean</code> for the current WebLogic Server domain. You cannot use this MBean to modify a domain's configuration. </p> <p>If you want to modify a domain's configuration, use the {@link ConfigurationManagerMBean#startEdit startEdit} operation in the <code>ConfigurationManagerMBean</code> to start an edit session. The <code>startEdit</code> operation returns an editable <code>DomainMBean</code>.</p>  <p>Get this read-only version of the MBean to learn about the pending configuration of all servers and resources in the domain.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("DomainRuntime")) {
            string2 = "getDomainRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DomainRuntime", DomainRuntimeServiceMBean.class, string2, string);
            map.put("DomainRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains the <code>DomainRuntimeMBean</code> for the current WebLogic Server domain.</p><p>This MBean provides access to the special service interfaces that exist only on the Administration Server and provide life cycle control over the domain.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Name", DomainRuntimeServiceMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>A unique key that WebLogic Server generates to identify the current instance of this MBean type.</p>  <p>For a singleton, such as <code>DomainRuntimeServiceMBean</code>, this key is often just the bean's short class name.</p> ");
        }
        if (!map.containsKey("ParentAttribute")) {
            string2 = "getParentAttribute";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentAttribute", DomainRuntimeServiceMBean.class, string2, string);
            map.put("ParentAttribute", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the attribute of the parent that refers to this bean</p> ");
        }
        if (!map.containsKey("ParentService")) {
            string2 = "getParentService";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentService", DomainRuntimeServiceMBean.class, string2, string);
            map.put("ParentService", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean that created the current MBean instance.</p>  <p>In the data model for WebLogic Server MBeans, an MBean that creates another MBean is called a <i>parent</i>. MBeans at the top of the hierarchy have no parents.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("Path")) {
            string2 = "getPath";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Path", DomainRuntimeServiceMBean.class, string2, string);
            map.put("Path", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the path to the bean relative to the reoot of the heirarchy of services</p> ");
        }
        if (!map.containsKey("ServerName")) {
            string2 = "getServerName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerName", DomainRuntimeServiceMBean.class, string2, string);
            map.put("ServerName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of this WebLogic Server instance as defined in the domain configuration.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("ServerRuntimes")) {
            string2 = "getServerRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerRuntimes", DomainRuntimeServiceMBean.class, string2, string);
            map.put("ServerRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains all <code>ServerRuntimeMBean</code> instances on all servers in the domain.</p> <p>Get these MBeans to learn about the current runtime statistics for all server instances in the domain.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("Type")) {
            string2 = "getType";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Type", DomainRuntimeServiceMBean.class, string2, string);
            map.put("Type", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean type for this instance. This is useful for MBean types that support multiple intances, such as <code>ActivationTaskMBean</code>.</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion)) {
            Method method = DomainRuntimeServiceMBean.class.getMethod("lookupServerRuntime", String.class);
            ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{DomainRuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            String string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                MethodDescriptor methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "9.0.0.0");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Returns the <code>ServerRuntimeMBean</code> for the specified server instance. The operation will return a null value if the named server is not currently running.</p> <p>The <code>ServerRuntimeMBean</code> is the root of runtime MBean hierarchy for a server instance. Each runtime MBean in the hierarchy provides access to the server's status and control as well as statistical information about any deployed or configured service on the server.</p> ");
                methodDescriptor.setValue("role", "finder");
                methodDescriptor.setValue("property", "ServerRuntimes");
                methodDescriptor.setValue("since", "9.0.0.0");
            }
        }
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = DomainRuntimeServiceMBean.class.getMethod("findDomainConfiguration", String.class);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Returns the active <code>DomainMBean</code> for the specified server. </p><p>Get this MBean to learn about the current configuration of the server, including any values that were overridden by the server's startup command. For example, if you used a command line option to override a server's listen port, the <code>ServerMBean</code> that you navigate to from this <code>DomainMBean</code> will show the value that was passed in the command line option.</p> <dl><dt>Note:</dt><dd><p>The <i>pending</i> <code>DomainMBean</code>, which can be edited, is available only from the Edit MBean Server and its <code>EditServiceMBean</code>. The <code>DomainMBean</code> that can be accessed from this (<code>DomainRuntimeServiceMBean</code>) MBean attribute represents the active configuration of the specified server and cannot be edited.</p></dd></dl> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = DomainRuntimeServiceMBean.class.getMethod("findServerConfiguration", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Returns the active <code>ServerMBean</code> for the specified server. </p><p>Get this MBean to learn about the current configuration of the server, including any values that were overridden by the server's startup command. For example, if you used a command line option to override a server's listen port, this <code>ServerMBean</code> will show the value that was passed in the command line option.</p> <dl><dt>Note:</dt><dd><p>The <i>pending</i> <code>ServerMBean</code>, which can be edited, is available only from the Edit MBean Server and its <code>EditServiceMBean</code>. The <code>ServerMBean</code> that can be accessed from this (<code>DomainRuntimeServiceMBean</code>) MBean attribute represents the active configuration of the specified server and cannot be edited.</p></dd></dl> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = DomainRuntimeServiceMBean.class.getMethod("findRuntimes", DescriptorBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{DomainRuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"configurationMBean", null)};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Enables a JMX client to retrieve monitoring statistics for all instances of a specific resource on all servers in a domain. To use this operation, a JMX client passes a single configuration MBean and the operation returns runtime MBeans for this resource from all servers in the domain.</p> <p>For example, a JMX client connects to the Domain Runtime MBean server and gets the <code>JMSServerMBean</code> for a JMS server named \"JS1.\" The JMX client then invokes this operation and the operation determines the active server instances on which the \"JS1\" JMS server has been targeted. It then returns all of the <code>JMSServerRuntimeMBean</code>s for \"JS1\" from all servers in the domain.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = DomainRuntimeServiceMBean.class.getMethod("findRuntime", DescriptorBean.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{DomainRuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"configurationMBean", null), DomainRuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"serverName", (String)"that owns that runtime mbean. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Enables a JMX client to retrieve monitoring statistics for a specific resource on a specific server. To use this operation, a JMX client passes a single configuration MBean and the name of a server instance. The operation returns the corresponding runtime MBean for the resource on the named server, assuming that the resource has been targeted or deployed to the server.</p> <p>For example, given the <code>JMSServerMBean</code> for a JMS server named \"JS1\" on a server instance named \"ManagedServer1,\" this operation returns the <code>JMSServerRuntimeMBean</code> for \"JS1\" on \"ManagedServer1.\"</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = DomainRuntimeServiceMBean.class.getMethod("findConfiguration", RuntimeMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{DomainRuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"runtimeMBean", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Enables a JMX client to retrieve configuration data for a specific instance of a resource. To use this operation, a JMX client passes a single runtime MBean and the operation returns the active configuration MBean for the resource.</p> <p>For example, given the <code>JMSServerRuntimeMBean</code> for a JMS server named \"JS1\" on the current server instance, this operation returns the active <code>JMSServerMBean</code> for \"JS1.\"</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = DomainRuntimeServiceMBean.class.getMethod("findService", String.class, String.class, String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Returns the Service on the specified Server or in the primary MBeanServer if the location is not specified. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = DomainRuntimeServiceMBean.class.getMethod("getServices", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{DomainRuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"serverName", (String)"String ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Returns all the services that do not have a parent i.e all the root services ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

