/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.mbeanservers.domainruntime.internal.MBeanServerConnectionManager;
import weblogic.management.mbeanservers.internal.LocalNotificationHandback;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.AbstractSubject;

public class FederatedMBeanServerDelegate
extends MBeanServerDelegate {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    MBeanServerConnectionManager connectionManager;
    MBeanServerDelegate wrappedDelegate;
    int registeredListeners;
    boolean managingListeners;
    private final Map<String, FederatedNotificationListener> listenersByServerMap = new ConcurrentHashMap<String, FederatedNotificationListener>();
    private WeakHashMap<NotificationListener, Object> localListeners = new WeakHashMap();
    static final ObjectName ALLMBEANS;
    static final ObjectName MBEANSERVERDELEGATE;

    public FederatedMBeanServerDelegate(MBeanServerDelegate mBeanServerDelegate, MBeanServerConnectionManager mBeanServerConnectionManager) {
        this.wrappedDelegate = mBeanServerDelegate;
        this.connectionManager = mBeanServerConnectionManager;
        mBeanServerConnectionManager.addCallback(this.createConnectionListener());
    }

    private MBeanServerConnectionManager.MBeanServerConnectionListener createConnectionListener() {
        return new MBeanServerConnectionManager.MBeanServerConnectionListener(){

            public void connect(final String string, final MBeanServerConnection mBeanServerConnection) {
                kernelId.doAs((AbstractSubject)kernelId, new PrivilegedAction(){

                    public Object run() {
                        this._connect(string, mBeanServerConnection);
                        return null;
                    }
                });
            }

            private void _connect(String string, MBeanServerConnection mBeanServerConnection) {
                block7: {
                    try {
                        if (debug.isDebugEnabled()) {
                            debug.debug("MBeanServerDelegate: Querying Managed Server");
                        }
                        if (!FederatedMBeanServerDelegate.this.isManagingListeners()) break block7;
                        if (debug.isDebugEnabled()) {
                            debug.debug("MBeanServerDelegate: There are registered listeners");
                        }
                        Set<ObjectName> set = mBeanServerConnection.queryNames(ALLMBEANS, null);
                        Iterator<ObjectName> iterator = set.iterator();
                        FederatedNotificationListener federatedNotificationListener = FederatedMBeanServerDelegate.this.createRegistrationListener(mBeanServerConnection);
                        FederatedMBeanServerDelegate.this.listenersByServerMap.put(string, federatedNotificationListener);
                        while (iterator.hasNext()) {
                            ObjectName objectName = iterator.next();
                            MBeanServerNotification mBeanServerNotification = new MBeanServerNotification("JMX.mbean.registered", (Object)MBEANSERVERDELEGATE, 0L, objectName);
                            FederatedMBeanServerDelegate.this.sendNotification(mBeanServerNotification);
                            federatedNotificationListener.addRegisteredObject(objectName);
                        }
                        try {
                            mBeanServerConnection.addNotificationListener(MBEANSERVERDELEGATE, federatedNotificationListener, null, null);
                        }
                        catch (InstanceNotFoundException instanceNotFoundException) {
                            throw new Error(instanceNotFoundException);
                        }
                    }
                    catch (IOException iOException) {
                        if (!debug.isDebugEnabled()) break block7;
                        debug.debug("Failed Connection to Managed MBean Server ", (Throwable)iOException);
                    }
                }
            }

            public void disconnect(String string) {
                FederatedNotificationListener federatedNotificationListener;
                if (FederatedMBeanServerDelegate.this.hasRegisteredListeners() && (federatedNotificationListener = (FederatedNotificationListener)FederatedMBeanServerDelegate.this.listenersByServerMap.remove(string)) != null) {
                    federatedNotificationListener.unregisterAll();
                }
            }
        };
    }

    private FederatedNotificationListener createRegistrationListener(final MBeanServerConnection mBeanServerConnection) {
        return new FederatedNotificationListener(){
            Set registeredObjectNames = Collections.synchronizedSet(new HashSet(1024));
            Set unmatchedObjectNames = Collections.synchronizedSet(new HashSet(1024));
            int numNotifications = 0;
            final MBeanServerConnection connection = mBeanServerConnection;
            static final int REFRESH_LEVEL = 10000;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleNotification(Notification notification, Object object) {
                Object object2;
                Object object3;
                if (debug.isDebugEnabled()) {
                    debug.debug("MBeanServerDelegate: handleNotification" + notification);
                }
                if (notification instanceof MBeanServerNotification) {
                    object3 = (MBeanServerNotification)notification;
                    object2 = ((Notification)object3).getType();
                    if (((String)object2).equals("JMX.mbean.registered")) {
                        if (this.unmatchedObjectNames.remove(((MBeanServerNotification)object3).getMBeanName())) {
                            if (debug.isDebugEnabled()) {
                                debug.debug("Skipping registration for previous unregistered notifications " + ((MBeanServerNotification)object3).getMBeanName());
                            }
                        } else {
                            ++this.numNotifications;
                            this.registeredObjectNames.add(((MBeanServerNotification)object3).getMBeanName());
                            if (debug.isDebugEnabled()) {
                                debug.debug("Registered " + ((MBeanServerNotification)object3).getMBeanName());
                            }
                        }
                    } else if (((String)object2).equals("JMX.mbean.unregistered")) {
                        if (this.registeredObjectNames.remove(((MBeanServerNotification)object3).getMBeanName())) {
                            --this.numNotifications;
                        } else {
                            this.unmatchedObjectNames.add(((MBeanServerNotification)object3).getMBeanName());
                        }
                        if (debug.isDebugEnabled()) {
                            debug.debug("Unregistered " + ((MBeanServerNotification)object3).getMBeanName());
                        }
                        try {
                            this.connection.removeNotificationListener(((MBeanServerNotification)object3).getMBeanName(), this);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                notification.setSequenceNumber(0L);
                FederatedMBeanServerDelegate.this.sendNotification(notification);
                if (this.numNotifications > 10000) {
                    object3 = this.registeredObjectNames;
                    synchronized (object3) {
                        block23: {
                            if (this.numNotifications > 10000) {
                                this.numNotifications = 0;
                                this.registeredObjectNames.clear();
                                this.unmatchedObjectNames.clear();
                                if (debug.isDebugEnabled()) {
                                    debug.debug("Clearing out registered object names and refreshing cache.");
                                }
                                try {
                                    object2 = this.connection.queryNames(ALLMBEANS, null);
                                    Iterator iterator = object2.iterator();
                                    while (iterator.hasNext()) {
                                        ObjectName objectName = (ObjectName)iterator.next();
                                        this.registeredObjectNames.add(objectName);
                                    }
                                }
                                catch (Exception exception) {
                                    if (!debug.isDebugEnabled()) break block23;
                                    debug.debug("Failed query to Managed MBean Server ", (Throwable)exception);
                                }
                            }
                        }
                    }
                }
            }

            public void addRegisteredObject(ObjectName objectName) {
                this.registeredObjectNames.add(objectName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unregisterAll() {
                Set set = this.registeredObjectNames;
                synchronized (set) {
                    for (ObjectName objectName : this.registeredObjectNames) {
                        MBeanServerNotification mBeanServerNotification = new MBeanServerNotification("JMX.mbean.unregistered", (Object)MBEANSERVERDELEGATE, 0L, objectName);
                        FederatedMBeanServerDelegate.this.sendNotification(mBeanServerNotification);
                    }
                }
            }
        };
    }

    public String getMBeanServerId() {
        return this.wrappedDelegate.getMBeanServerId();
    }

    public String getSpecificationName() {
        return this.wrappedDelegate.getSpecificationName();
    }

    public String getSpecificationVersion() {
        return this.wrappedDelegate.getSpecificationVersion();
    }

    public String getSpecificationVendor() {
        return this.wrappedDelegate.getSpecificationVendor();
    }

    public String getImplementationName() {
        return this.wrappedDelegate.getImplementationName();
    }

    public String getImplementationVersion() {
        return this.wrappedDelegate.getImplementationVersion();
    }

    public String getImplementationVendor() {
        return this.wrappedDelegate.getImplementationVendor();
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        super.removeNotificationListener(notificationListener, notificationFilter, object);
        this.decrementRegisteredListeners();
    }

    private synchronized boolean isManagingListeners() {
        return this.managingListeners;
    }

    private synchronized boolean hasRegisteredListeners() {
        return this.registeredListeners != 0;
    }

    private synchronized void incrementRegisteredListeners() {
        ++this.registeredListeners;
        if (this.registeredListeners == 1 && !this.isManagingListeners()) {
            kernelId.doAs((AbstractSubject)kernelId, new PrivilegedAction(){

                public Object run() {
                    FederatedMBeanServerDelegate.this.registerManagedListeners();
                    return null;
                }
            });
        }
        this.managingListeners = true;
    }

    private synchronized void decrementRegisteredListeners() {
        --this.registeredListeners;
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        super.addNotificationListener(notificationListener, notificationFilter, object);
        if (object instanceof LocalNotificationHandback) {
            this.localListeners.put(notificationListener, object);
            return;
        }
        this.incrementRegisteredListeners();
    }

    private void registerManagedListeners() {
        try {
            this.connectionManager.iterateConnections(new MBeanServerConnectionManager.ConnectionCallback(){

                public void connection(MBeanServerConnection mBeanServerConnection) throws IOException {
                    try {
                        FederatedNotificationListener federatedNotificationListener;
                        block5: {
                            federatedNotificationListener = FederatedMBeanServerDelegate.this.createRegistrationListener(mBeanServerConnection);
                            try {
                                Set<ObjectName> set = mBeanServerConnection.queryNames(ALLMBEANS, null);
                                for (ObjectName objectName : set) {
                                    federatedNotificationListener.addRegisteredObject(objectName);
                                }
                            }
                            catch (Exception exception) {
                                if (!debug.isDebugEnabled()) break block5;
                                debug.debug("Failed query to Managed MBean Server ", (Throwable)exception);
                            }
                        }
                        mBeanServerConnection.addNotificationListener(MBEANSERVERDELEGATE, federatedNotificationListener, null, null);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        throw new AssertionError((Object)instanceNotFoundException);
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        super.removeNotificationListener(notificationListener);
        if (this.localListeners.containsKey(notificationListener)) {
            this.localListeners.remove(notificationListener);
            return;
        }
        this.decrementRegisteredListeners();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.wrappedDelegate.getNotificationInfo();
    }

    static {
        try {
            ALLMBEANS = new ObjectName("*:*");
            MBEANSERVERDELEGATE = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }

    static interface FederatedNotificationListener
    extends NotificationListener {
        public void addRegisteredObject(ObjectName var1);

        public void unregisterAll();
    }
}

