/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.mbeanservers.domainruntime.internal.MBeanServerConnectionManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class FederatedMBeanServerInterceptor
extends WLSMBeanServerInterceptorBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    MBeanServerConnectionManager connectionManager;
    String domainName;

    public FederatedMBeanServerInterceptor(MBeanServerConnectionManager mBeanServerConnectionManager, String string) {
        this.connectionManager = mBeanServerConnectionManager;
        this.domainName = string;
    }

    private boolean isDelegate(ObjectName objectName) {
        if (objectName == null) {
            return false;
        }
        String string = objectName.getKeyProperty("Location");
        return string != null && string.length() != 0 && !string.equals(this.domainName);
    }

    MBeanServerConnection lookupMBeanServer(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        String string = objectName.getKeyProperty("Location");
        if (string == null || string.length() == 0 || string.equals(this.domainName)) {
            return this.mbeanServerConnection;
        }
        return this.connectionManager.lookupMBeanServerConnection(string);
    }

    private void initializeJMXContext(ObjectName objectName) {
        if (!this.isDelegate(objectName)) {
            return;
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (AuthenticatedSubject.ANON.equals((Object)authenticatedSubject) || KERNEL_ID.equals((Object)authenticatedSubject)) {
            return;
        }
        JMXContext jMXContext = JMXContextHelper.getJMXContext(true);
        jMXContext.setSubject(authenticatedSubject.getSubject());
        JMXContextHelper.putJMXContext(jMXContext);
    }

    private void cleanupJMXContext(ObjectName objectName) {
        if (!this.isDelegate(objectName)) {
            return;
        }
        JMXContext jMXContext = JMXContextHelper.getJMXContext(false);
        if (jMXContext != null) {
            jMXContext.setSubject(null);
            JMXContextHelper.putJMXContext(jMXContext);
        }
    }

    MBeanServerConnection lookupMBeanServerForCreate(ObjectName objectName) throws IOException {
        MBeanServerConnection mBeanServerConnection = this.lookupMBeanServer(objectName);
        if (mBeanServerConnection == null) {
            throw new IOException("Unable to contact MBeanServer for " + objectName);
        }
        return mBeanServerConnection;
    }

    MBeanServerConnection lookupMBeanServerRequired(ObjectName objectName) throws InstanceNotFoundException {
        MBeanServerConnection mBeanServerConnection = this.lookupMBeanServer(objectName);
        if (mBeanServerConnection == null) {
            throw new InstanceNotFoundException("Unable to contact MBeanServer for " + objectName);
        }
        return mBeanServerConnection;
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        String string = objectName.getKeyProperty("Location");
        if (string == null || string.length() == 0) {
            return super.getClassLoaderFor(objectName);
        }
        return DescriptorClassLoader.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        this.initializeJMXContext(objectName);
        try {
            ObjectInstance objectInstance = this.lookupMBeanServerForCreate(objectName).createMBean(string, objectName);
            return objectInstance;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        this.initializeJMXContext(objectName);
        try {
            ObjectInstance objectInstance = this.lookupMBeanServerForCreate(objectName).createMBean(string, objectName, objectName2);
            return objectInstance;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        this.initializeJMXContext(objectName);
        try {
            ObjectInstance objectInstance = this.lookupMBeanServerForCreate(objectName).createMBean(string, objectName, objectArray, stringArray);
            return objectInstance;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        this.initializeJMXContext(objectName);
        try {
            ObjectInstance objectInstance = this.lookupMBeanServerForCreate(objectName).createMBean(string, objectName, objectName2, objectArray, stringArray);
            return objectInstance;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.initializeJMXContext(objectName);
        try {
            this.lookupMBeanServerRequired(objectName).unregisterMBean(objectName);
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        return this.lookupMBeanServerRequired(objectName).getObjectInstance(objectName);
    }

    public Set queryMBeans(final ObjectName objectName, final QueryExp queryExp) throws IOException {
        String string = this.getLocationFromObjectName(objectName);
        if (string == null) {
            final Set<ObjectInstance> set = this.mbeanServerConnection.queryMBeans(objectName, queryExp);
            this.connectionManager.iterateConnections(new MBeanServerConnectionManager.ConnectionCallback(){

                public void connection(MBeanServerConnection mBeanServerConnection) throws IOException {
                    Set<ObjectInstance> set2 = mBeanServerConnection.queryMBeans(objectName, queryExp);
                    set.addAll(set2);
                }
            }, false);
            return set;
        }
        MBeanServerConnection mBeanServerConnection = this.connectionManager.lookupMBeanServerConnection(string);
        if (mBeanServerConnection == null) {
            return new HashSet(0);
        }
        return mBeanServerConnection.queryMBeans(objectName, queryExp);
    }

    public String getLocationFromObjectName(ObjectName objectName) {
        if (objectName != null) {
            return objectName.getKeyProperty("Location");
        }
        return null;
    }

    public Set queryNames(final ObjectName objectName, final QueryExp queryExp) throws IOException {
        String string = this.getLocationFromObjectName(objectName);
        if (string == null) {
            final Set<ObjectName> set = this.mbeanServerConnection.queryNames(objectName, queryExp);
            this.connectionManager.iterateConnections(new MBeanServerConnectionManager.ConnectionCallback(){

                public void connection(MBeanServerConnection mBeanServerConnection) throws IOException {
                    Set<ObjectName> set2 = mBeanServerConnection.queryNames(objectName, queryExp);
                    set.addAll(set2);
                }
            }, false);
            return set;
        }
        MBeanServerConnection mBeanServerConnection = this.connectionManager.lookupMBeanServerConnection(string);
        if (mBeanServerConnection == null) {
            return new HashSet(0);
        }
        return mBeanServerConnection.queryNames(objectName, queryExp);
    }

    public boolean isRegistered(ObjectName objectName) throws IOException {
        return this.lookupMBeanServerForCreate(objectName).isRegistered(objectName);
    }

    public Integer getMBeanCount() throws IOException {
        final int[] nArray = new int[]{this.mbeanServerConnection.getMBeanCount()};
        this.connectionManager.iterateConnections(new MBeanServerConnectionManager.ConnectionCallback(){

            public void connection(MBeanServerConnection mBeanServerConnection) throws IOException {
                nArray[0] = nArray[0] + mBeanServerConnection.getMBeanCount();
            }
        }, false);
        return new Integer(nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        this.initializeJMXContext(objectName);
        try {
            Object object = this.lookupMBeanServerRequired(objectName).getAttribute(objectName, string);
            return object;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
        this.initializeJMXContext(objectName);
        try {
            AttributeList attributeList = this.lookupMBeanServerRequired(objectName).getAttributes(objectName, stringArray);
            return attributeList;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.initializeJMXContext(objectName);
        try {
            this.lookupMBeanServerRequired(objectName).setAttribute(objectName, attribute);
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        this.initializeJMXContext(objectName);
        try {
            AttributeList attributeList2 = this.lookupMBeanServerRequired(objectName).setAttributes(objectName, attributeList);
            return attributeList2;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.initializeJMXContext(objectName);
        try {
            Object object = this.lookupMBeanServerRequired(objectName).invoke(objectName, string, objectArray, stringArray);
            return object;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    public String getDefaultDomain() throws IOException {
        return this.mbeanServerConnection.getDefaultDomain();
    }

    private void addToSet(Set set, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            set.add(object);
        }
    }

    public String[] getDomains() throws IOException {
        final HashSet hashSet = new HashSet();
        this.addToSet(hashSet, this.mbeanServerConnection.getDomains());
        this.connectionManager.iterateConnections(new MBeanServerConnectionManager.ConnectionCallback(){

            public void connection(MBeanServerConnection mBeanServerConnection) throws IOException {
                FederatedMBeanServerInterceptor.this.addToSet(hashSet, mBeanServerConnection.getDomains());
            }
        }, false);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("Add notification listener for " + objectName);
        }
        this.lookupMBeanServerRequired(objectName).addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        this.lookupMBeanServerRequired(objectName).addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.initializeJMXContext(objectName);
        try {
            this.lookupMBeanServerRequired(objectName).removeNotificationListener(objectName, objectName2);
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.initializeJMXContext(objectName);
        try {
            this.lookupMBeanServerRequired(objectName).removeNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.initializeJMXContext(objectName);
        try {
            this.lookupMBeanServerRequired(objectName).removeNotificationListener(objectName, notificationListener);
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.initializeJMXContext(objectName);
        try {
            this.lookupMBeanServerRequired(objectName).removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        this.initializeJMXContext(objectName);
        try {
            MBeanInfo mBeanInfo = this.lookupMBeanServerRequired(objectName).getMBeanInfo(objectName);
            return mBeanInfo;
        }
        finally {
            this.cleanupJMXContext(objectName);
        }
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
        return this.lookupMBeanServerRequired(objectName).isInstanceOf(objectName, string);
    }
}

