/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.commo.StandardInterface;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.internal.MBeanServerConnectionManager;
import weblogic.management.mbeanservers.internal.WLSObjectNameManager;

public class FederatedObjectNameManager
extends WLSObjectNameManager {
    MBeanServerConnectionManager connectionManager;
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");

    public boolean isFiltered(Object object) {
        if (object instanceof StandardInterface) {
            return true;
        }
        return super.isFiltered(object);
    }

    public FederatedObjectNameManager(MBeanServerConnectionManager mBeanServerConnectionManager, String string) {
        super(string);
        this.connectionManager = mBeanServerConnectionManager;
        this.setAddDomainToReadOnly(true);
        this.connectionManager.addCallback(new MBeanServerConnectionManager.MBeanServerConnectionListener(){

            public void connect(String string, MBeanServerConnection mBeanServerConnection) {
            }

            public void disconnect(String string) {
                Collection collection = FederatedObjectNameManager.this.getAllObjectNames();
                ObjectName[] objectNameArray = collection.toArray(new ObjectName[collection.size()]);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    ObjectName objectName = objectNameArray[i];
                    String string2 = objectName.getKeyProperty("Location");
                    if (string2 == null || !string2.equals(string)) continue;
                    FederatedObjectNameManager.this.unregisterObject(objectName);
                }
            }
        });
    }

    public ObjectName buildObjectName(Object object) {
        ObjectName objectName;
        if (Proxy.isProxyClass(object.getClass())) {
            MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(object);
            String string = this.connectionManager.lookupServerName(mBeanServerInvocationHandler._getConnection());
            if (string == null) {
                return null;
            }
            ObjectName objectName2 = mBeanServerInvocationHandler._getObjectName();
            objectName = this.addLocation(objectName2, string);
        } else {
            objectName = super.buildObjectName(object);
        }
        return objectName;
    }

    public ObjectName lookupObjectName(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(object);
            return mBeanServerInvocationHandler._getObjectName();
        }
        return super.lookupObjectName(object);
    }

    public ObjectName lookupRegisteredObjectName(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(object);
            return mBeanServerInvocationHandler._getObjectName();
        }
        return super.lookupRegisteredObjectName(object);
    }

    public Object lookupObject(ObjectName objectName) {
        Object object = super.lookupObject(objectName);
        if (object == null) {
            String string = objectName.getKeyProperty("Location");
            if (string != null && !string.equals(this.getDomainName())) {
                ObjectName objectName2;
                MBeanServerConnection mBeanServerConnection = this.connectionManager.lookupMBeanServerConnection(string);
                Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
                hashtable.remove("Location");
                try {
                    objectName2 = new ObjectName(objectName.getDomain(), hashtable);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    throw new Error(malformedObjectNameException);
                }
                try {
                    object = MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName2);
                }
                catch (Throwable throwable) {
                    throw new Error(throwable);
                }
                if (debug.isDebugEnabled()) {
                    debug.debug("Registering on lookupObject for " + objectName + " to " + objectName2 + " of " + object.getClass().getName());
                }
                this.registerObject(objectName, object);
            }
        } else if (debug.isDebugEnabled()) {
            debug.debug("lookupObject: returning a " + object.getClass() + " for " + objectName);
        }
        return object;
    }

    private ObjectName addLocation(ObjectName objectName, String string) {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        hashtable.put("Location", string);
        try {
            return new ObjectName(objectName.getDomain(), hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)malformedObjectNameException);
        }
    }
}

