/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.jmx.JMXLogger;
import weblogic.management.mbeanservers.domainruntime.MBeanServerConnectionManagerMBean;
import weblogic.management.mbeanservers.domainruntime.internal.JMXExecutor;
import weblogic.management.mbeanservers.domainruntime.internal.ManagedMBeanServerConnection;
import weblogic.management.mbeanservers.internal.DomainServiceImpl;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.protocol.ServerURL;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.rmi.extensions.ConnectMonitor;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class MBeanServerConnectionManager
extends DomainServiceImpl
implements MBeanServerConnectionManagerMBean {
    private static final String JNDI = "/jndi/";
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");
    private final Map locationToMBeanServerMap = new ConcurrentHashMap();
    private final Map connectionToServerNameMap = new ConcurrentHashMap();
    private final Map connectorsByConnectionMap = new ConcurrentHashMap();
    private final Map doubleConnectMap = new ConcurrentHashMap();
    private final ConcurrentHashMap connectingManagedServers = new ConcurrentHashMap();
    private final CopyOnWriteArrayList callbacks = new CopyOnWriteArrayList();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MBeanServerConnection lookupMBeanServerConnection(String string) {
        return (MBeanServerConnection)this.locationToMBeanServerMap.get(string);
    }

    MBeanServerConnectionManager() {
        super("MBeanServerConnectionManager", MBeanServerConnectionManagerMBean.class.getName(), null);
    }

    void initializeConnectivity() {
        this.registerLocalMBeanServer();
        this.pollAllManagedServers();
        this.startListening();
    }

    private void registerLocalMBeanServer() {
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        MBeanServer mBeanServer = ManagementService.getRuntimeMBeanServer(kernelId);
        ManagedMBeanServerConnection managedMBeanServerConnection = new ManagedMBeanServerConnection(mBeanServer, string, null);
        this.locationToMBeanServerMap.put(string, managedMBeanServerConnection);
        this.connectionToServerNameMap.put(managedMBeanServerConnection, string);
        this.invokeConnectCallbacks(string, managedMBeanServerConnection);
    }

    void shutdown() {
        Set set = this.connectorsByConnectionMap.keySet();
        for (JMXConnector jMXConnector : set) {
            try {
                jMXConnector.close();
            }
            catch (IOException iOException) {}
        }
        this.locationToMBeanServerMap.clear();
        this.connectionToServerNameMap.clear();
        this.connectorsByConnectionMap.clear();
    }

    void addCallback(MBeanServerConnectionListener mBeanServerConnectionListener) {
        this.callbacks.add(mBeanServerConnectionListener);
    }

    void removeCallback(MBeanServerConnectionListener mBeanServerConnectionListener) {
        this.callbacks.remove(mBeanServerConnectionListener);
    }

    private void startListening() {
        ConnectMonitor connectMonitor = ConnectMonitorFactory.getConnectMonitor();
        connectMonitor.addConnectDisconnectListener(this.createConnectListener(), this.createDisconnectListener());
    }

    private void pollAllManagedServers() {
        if (debug.isDebugEnabled()) {
            debug.debug("Polling managed servers ");
        }
        ServerMBean[] serverMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            CountDownLatch countDownLatch;
            String string = serverMBeanArray[i].getName();
            MBeanServerConnection mBeanServerConnection = this.lookupMBeanServerConnection(string);
            if (mBeanServerConnection == null && (countDownLatch = this.connectToManagedServer(string)) != null) {
                try {
                    if (debug.isDebugEnabled()) {
                        debug.debug("CountDownLatch is not null ");
                    }
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!debug.isDebugEnabled()) continue;
            debug.debug("pollAllManagedServers: connect to server \"" + string);
        }
    }

    private ConnectListener createConnectListener() {
        return new ConnectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnect(ConnectEvent connectEvent) {
                String string = connectEvent.getServerName();
                Object object = MBeanServerConnectionManager.this.doubleConnectMap;
                synchronized (object) {
                    if (MBeanServerConnectionManager.this.locationToMBeanServerMap.containsKey(string)) {
                        CountDownLatch countDownLatch = (CountDownLatch)MBeanServerConnectionManager.this.connectingManagedServers.get(string);
                        if (countDownLatch != null) {
                            if (debug.isDebugEnabled()) {
                                debug.debug("ConnectListener: skipping connect since connect already in progress to " + string);
                            }
                            return;
                        }
                        Integer n = (Integer)MBeanServerConnectionManager.this.doubleConnectMap.get(string);
                        n = MBeanServerConnectionManager.this.incrementInteger(n);
                        MBeanServerConnectionManager.this.doubleConnectMap.put(string, n);
                        JMXLogger.logDisconnectedJMXConnectionWithManagedServer((String)string);
                        MBeanServerConnectionManager.this.cleanupDisconnectedServer(string);
                    }
                }
                object = MBeanServerConnectionManager.this.connectToManagedServer(string);
                if (object != null && debug.isDebugEnabled()) {
                    debug.debug("ConnectListener: connect to server \"" + string);
                }
            }
        };
    }

    private Integer decrementInteger(Integer n) {
        if (n == null) {
            return new Integer(-1);
        }
        return new Integer(n + 1);
    }

    private Integer incrementInteger(Integer n) {
        if (n == null) {
            return new Integer(1);
        }
        return new Integer(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch connectToManagedServer(String string) {
        JMXConnector jMXConnector;
        JMXContext jMXContext;
        Object object;
        String string2;
        JMXServiceURL jMXServiceURL;
        CountDownLatch countDownLatch;
        block22: {
            countDownLatch = new CountDownLatch(1);
            CountDownLatch countDownLatch2 = this.connectingManagedServers.putIfAbsent(string, countDownLatch);
            if (countDownLatch2 != null) {
                if (debug.isDebugEnabled()) {
                    debug.debug("connectToManagedServer return oldLatch when connecting to " + string);
                }
                return countDownLatch2;
            }
            if (this.locationToMBeanServerMap.containsKey(string)) {
                CountDownLatch countDownLatch3 = null;
                return countDownLatch3;
            }
            jMXServiceURL = null;
            string2 = null;
            string2 = URLManager.findAdministrationURL(string);
            if (string2 != null) break block22;
            CountDownLatch countDownLatch4 = null;
            return countDownLatch4;
        }
        try {
            object = new ServerURL(string2);
            jMXServiceURL = new JMXServiceURL(object.getProtocol(), object.getHost(), object.getPort(), "/jndi/weblogic.management.mbeanservers.runtime");
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = jMXServiceURL != null ? jMXServiceURL.toString() : "<none>";
            JMXLogger.logManagedServerURLMalformed((String)string, (String)string3, (Throwable)malformedURLException);
            throw new AssertionError((Object)(" Malformed URL" + malformedURLException));
        }
        catch (UnknownHostException unknownHostException) {
            String string4 = jMXServiceURL != null ? jMXServiceURL.toString() : "<none>";
            JMXLogger.logManagedServerNotAvailable((String)string, (String)string4);
            CountDownLatch countDownLatch5 = null;
            countDownLatch.countDown();
            this.connectingManagedServers.remove(string);
            return countDownLatch5;
        }
        try {
            jMXContext = JMXContextHelper.getJMXContext(true);
            jMXContext.setSubject(SecurityServiceManager.sendASToWire((AuthenticatedSubject)kernelId).getSubject());
            JMXContextHelper.putJMXContext(jMXContext);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
            hashMap.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            JMXExecutor jMXExecutor = new JMXExecutor();
            hashMap.put("jmx.remote.x.fetch.notifications.executor", jMXExecutor);
            hashMap.put("jmx.remote.x.notification.buffer.size", 50000);
            int n = ManagementService.getRuntimeAccess(kernelId).getDomain().getJMX().getInvocationTimeoutSeconds();
            if (n > 0) {
                hashMap.put("jmx.remote.x.request.waiting.timeout", new Long(n * 1000));
            }
            if (string2 != null && string2.length() > 0) {
                hashMap.put("java.naming.provider.url", string2);
            }
            if (debug.isDebugEnabled()) {
                debug.debug("Connect to service URL " + jMXServiceURL);
            }
            jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
            MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            object = new ManagedMBeanServerConnection(mBeanServerConnection, string, jMXExecutor);
        }
        catch (Exception exception) {
            JMXLogger.logUnableToContactManagedServer((String)string, (String)jMXServiceURL.toString(), (Throwable)exception);
            CountDownLatch countDownLatch6 = null;
            countDownLatch.countDown();
            this.connectingManagedServers.remove(string);
            return countDownLatch6;
        }
        finally {
            JMXContextHelper.removeJMXContext();
        }
        JMXLogger.logEstablishedJMXConnectionWithManagedServer((String)string, (String)jMXServiceURL.toString());
        this.registerConnection(string, (ManagedMBeanServerConnection)object, jMXConnector);
        jMXContext = null;
        return jMXContext;
        finally {
            countDownLatch.countDown();
            this.connectingManagedServers.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConnection(String string, ManagedMBeanServerConnection managedMBeanServerConnection, JMXConnector jMXConnector) {
        MBeanServerConnectionManager mBeanServerConnectionManager = this;
        synchronized (mBeanServerConnectionManager) {
            this.locationToMBeanServerMap.put(string, managedMBeanServerConnection);
            this.connectionToServerNameMap.put(managedMBeanServerConnection, string);
            this.connectorsByConnectionMap.put(managedMBeanServerConnection, jMXConnector);
        }
        this.invokeConnectCallbacks(string, managedMBeanServerConnection);
    }

    private DisconnectListener createDisconnectListener() {
        return new DisconnectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDisconnect(DisconnectEvent disconnectEvent) {
                String string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
                Map map = MBeanServerConnectionManager.this.doubleConnectMap;
                synchronized (map) {
                    Integer n = (Integer)MBeanServerConnectionManager.this.doubleConnectMap.get(string);
                    if (n != null) {
                        if ((n = MBeanServerConnectionManager.this.decrementInteger(n)) < 1) {
                            MBeanServerConnectionManager.this.doubleConnectMap.remove(string);
                        } else {
                            MBeanServerConnectionManager.this.doubleConnectMap.put(string, n);
                        }
                        return;
                    }
                }
                JMXLogger.logDisconnectedJMXConnectionWithManagedServer((String)string);
                MBeanServerConnectionManager.this.cleanupDisconnectedServer(string);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDisconnectedServer(String string) {
        MBeanServerConnectionManager mBeanServerConnectionManager = this;
        synchronized (mBeanServerConnectionManager) {
            ManagedMBeanServerConnection managedMBeanServerConnection = (ManagedMBeanServerConnection)this.locationToMBeanServerMap.remove(string);
            if (managedMBeanServerConnection == null) {
                return;
            }
            managedMBeanServerConnection.disconnected();
            this.connectionToServerNameMap.remove(managedMBeanServerConnection);
            this.connectorsByConnectionMap.remove(managedMBeanServerConnection);
        }
        this.invokeDisconnectCallbacks(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDisconnectCallbacks(String string) {
        CopyOnWriteArrayList copyOnWriteArrayList = this.callbacks;
        synchronized (copyOnWriteArrayList) {
            for (MBeanServerConnectionListener mBeanServerConnectionListener : this.callbacks) {
                try {
                    mBeanServerConnectionListener.disconnect(string);
                }
                catch (Exception exception) {
                    JMXLogger.logExceptionDuringJMXConnectivity((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConnectCallbacks(String string, MBeanServerConnection mBeanServerConnection) {
        CopyOnWriteArrayList copyOnWriteArrayList = this.callbacks;
        synchronized (copyOnWriteArrayList) {
            for (MBeanServerConnectionListener mBeanServerConnectionListener : this.callbacks) {
                try {
                    mBeanServerConnectionListener.connect(string, mBeanServerConnection);
                }
                catch (Exception exception) {
                    JMXLogger.logExceptionDuringJMXConnectivity((Throwable)exception);
                }
            }
        }
    }

    public void iterateConnections(ConnectionCallback connectionCallback, boolean bl) throws IOException {
        for (MBeanServerConnection mBeanServerConnection : this.locationToMBeanServerMap.values()) {
            try {
                connectionCallback.connection(mBeanServerConnection);
            }
            catch (IOException iOException) {
                if (debug.isDebugEnabled()) {
                    debug.debug("Failed while iterating remote connections ", (Throwable)iOException);
                }
                if (!bl) continue;
                throw iOException;
            }
        }
    }

    public void notifyNewMBeanServer(String string) {
        CountDownLatch countDownLatch = this.connectToManagedServer(string);
        if (countDownLatch != null) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String lookupServerName(MBeanServerConnection mBeanServerConnection) {
        return (String)this.connectionToServerNameMap.get(mBeanServerConnection);
    }

    public synchronized void stop() {
        JMXConnector[] jMXConnectorArray = this.connectorsByConnectionMap.values().toArray(new JMXConnector[this.connectorsByConnectionMap.size()]);
        for (int i = 0; i < jMXConnectorArray.length; ++i) {
            try {
                jMXConnectorArray[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface ConnectionCallback {
        public void connection(MBeanServerConnection var1) throws IOException;
    }

    public static interface MBeanServerConnectionListener {
        public void connect(String var1, MBeanServerConnection var2);

        public void disconnect(String var1);
    }
}

