/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.mbeanservers.domainruntime.internal.JMXExecutor;
import weblogic.management.mbeanservers.domainruntime.internal.ManagedMBeanServerObjectNameManager;

public class ManagedMBeanServerConnection
implements MBeanServerConnection {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");
    ManagedMBeanServerObjectNameManager objectNameManager = null;
    MBeanServerConnection mbeanServerConnection;
    JMXExecutor executor;
    String location;
    Map listenerToRelayListenerMap = Collections.synchronizedMap(new HashMap());

    public ManagedMBeanServerConnection(MBeanServerConnection mBeanServerConnection, String string, JMXExecutor jMXExecutor) {
        this.mbeanServerConnection = mBeanServerConnection;
        this.objectNameManager = new ManagedMBeanServerObjectNameManager(string);
        this.executor = jMXExecutor;
        this.location = string;
    }

    public void disconnected() {
        if (this.executor != null) {
            this.executor.cancel();
        }
    }

    public MBeanServerConnection getWrappedConnection() {
        return this.mbeanServerConnection;
    }

    private ObjectName addLocationToObjectName(ObjectName objectName) {
        String string;
        if (objectName != null && (string = objectName.getKeyProperty("Location")) != null && !string.equalsIgnoreCase(this.location)) {
            return objectName;
        }
        return this.objectNameManager.lookupScopedObjectName(objectName);
    }

    private ObjectInstance addLocationToObjectInstance(ObjectInstance objectInstance) {
        return new ObjectInstance(this.addLocationToObjectName(objectInstance.getObjectName()), objectInstance.getClassName());
    }

    private Object addLocationToResult(Object object) {
        if (object instanceof ObjectName) {
            return this.addLocationToObjectName((ObjectName)object);
        }
        if (object instanceof ObjectName[]) {
            ObjectName[] objectNameArray = (ObjectName[])object;
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectNameArray[i] = this.addLocationToObjectName(objectNameArray[i]);
            }
            return objectNameArray;
        }
        return object;
    }

    private AttributeList addLocationToAttributeList(AttributeList attributeList) {
        ListIterator listIterator = attributeList.listIterator();
        AttributeList attributeList2 = new AttributeList();
        while (listIterator.hasNext()) {
            Attribute attribute = (Attribute)listIterator.next();
            Object object = this.addLocationToResult(attribute.getValue());
            Attribute attribute2 = new Attribute(attribute.getName(), object);
            attributeList2.add(attribute2);
        }
        return attributeList2;
    }

    private Set addLocationToObjectNameSet(Set set) {
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>(set.size());
        for (ObjectName objectName : set) {
            hashSet.add(this.addLocationToObjectName(objectName));
        }
        return hashSet;
    }

    private Set addLocationToObjectInstances(Set set) {
        if (set == null || set.size() == 0) {
            return set;
        }
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>(set.size());
        for (ObjectInstance objectInstance : set) {
            hashSet.add(this.addLocationToObjectInstance(objectInstance));
        }
        return hashSet;
    }

    private ObjectName removeLocationFromObjectName(ObjectName objectName) {
        if (objectName == null) {
            return objectName;
        }
        String string = objectName.getKeyProperty("Location");
        if (string == null || !string.equalsIgnoreCase(this.location)) {
            return objectName;
        }
        ObjectName objectName2 = this.objectNameManager.lookupObjectName(objectName);
        return objectName2;
    }

    private Attribute removeLocationFromAttribute(Attribute attribute) {
        return new Attribute(attribute.getName(), this.removeLocationFromParam(attribute.getValue()));
    }

    private AttributeList removeLocationFromAttributeList(AttributeList attributeList) {
        ListIterator listIterator = attributeList.listIterator();
        AttributeList attributeList2 = new AttributeList();
        while (listIterator.hasNext()) {
            Attribute attribute = (Attribute)listIterator.next();
            attributeList2.add(this.removeLocationFromAttribute(attribute));
        }
        return attributeList2;
    }

    private Object removeLocationFromParam(Object object) {
        if (object instanceof ObjectName) {
            return this.removeLocationFromObjectName((ObjectName)object);
        }
        if (object instanceof ObjectName[]) {
            ObjectName[] objectNameArray = (ObjectName[])object;
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectNameArray[i] = this.removeLocationFromObjectName(objectNameArray[i]);
            }
            return objectNameArray;
        }
        return object;
    }

    private Object[] removeLocationFromParams(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            objectArray[i] = this.removeLocationFromParam(object);
        }
        return objectArray;
    }

    private QueryExp processQueryExp(QueryExp queryExp) {
        return queryExp;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance objectInstance = this.mbeanServerConnection.createMBean(string, this.removeLocationFromObjectName(objectName));
        return new ObjectInstance(this.addLocationToObjectName(objectInstance.getObjectName()), objectInstance.getClassName());
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = this.mbeanServerConnection.createMBean(string, this.removeLocationFromObjectName(objectName), objectName2);
        return new ObjectInstance(this.addLocationToObjectName(objectInstance.getObjectName()), objectInstance.getClassName());
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance objectInstance = this.mbeanServerConnection.createMBean(string, this.removeLocationFromObjectName(objectName), objectArray, stringArray);
        return new ObjectInstance(this.addLocationToObjectName(objectInstance.getObjectName()), objectInstance.getClassName());
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = this.mbeanServerConnection.createMBean(string, this.removeLocationFromObjectName(objectName), objectName2, objectArray, stringArray);
        return this.addLocationToObjectInstance(objectInstance);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.mbeanServerConnection.unregisterMBean(this.removeLocationFromObjectName(objectName));
        this.objectNameManager.unregisterObjectInstance(objectName);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        return this.addLocationToObjectInstance(this.mbeanServerConnection.getObjectInstance(this.removeLocationFromObjectName(objectName)));
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
        Set<ObjectInstance> set = this.mbeanServerConnection.queryMBeans(this.removeLocationFromObjectName(objectName), this.processQueryExp(queryExp));
        return this.addLocationToObjectInstances(set);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
        Set<ObjectName> set = this.mbeanServerConnection.queryNames(this.removeLocationFromObjectName(objectName), this.processQueryExp(queryExp));
        return this.addLocationToObjectNameSet(set);
    }

    public boolean isRegistered(ObjectName objectName) throws IOException {
        return this.mbeanServerConnection.isRegistered(this.removeLocationFromObjectName(objectName));
    }

    public Integer getMBeanCount() throws IOException {
        return this.mbeanServerConnection.getMBeanCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.addLocationToResult(this.mbeanServerConnection.getAttribute(this.removeLocationFromObjectName(objectName), string));
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.addLocationToAttributeList(this.mbeanServerConnection.getAttributes(this.removeLocationFromObjectName(objectName), stringArray));
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.mbeanServerConnection.setAttribute(this.removeLocationFromObjectName(objectName), this.removeLocationFromAttribute(attribute));
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attributeList2 = this.mbeanServerConnection.setAttributes(this.removeLocationFromObjectName(objectName), this.removeLocationFromAttributeList(attributeList));
        return this.addLocationToAttributeList(attributeList2);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object object = this.mbeanServerConnection.invoke(this.removeLocationFromObjectName(objectName), string, this.removeLocationFromParams(objectArray), stringArray);
        return this.addLocationToResult(object);
    }

    public String getDefaultDomain() throws IOException {
        return this.mbeanServerConnection.getDefaultDomain();
    }

    public String[] getDomains() throws IOException {
        return this.mbeanServerConnection.getDomains();
    }

    private NotificationListener createRelayNotificationListener(NotificationListener notificationListener) {
        RelayNotificationListener relayNotificationListener = new RelayNotificationListener(notificationListener);
        this.listenerToRelayListenerMap.put(notificationListener, relayNotificationListener);
        return relayNotificationListener;
    }

    private NotificationListener removeRelayNotificationListener(NotificationListener notificationListener) {
        return (NotificationListener)this.listenerToRelayListenerMap.remove(notificationListener);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        this.mbeanServerConnection.addNotificationListener(this.removeLocationFromObjectName(objectName), this.createRelayNotificationListener(notificationListener), notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        this.mbeanServerConnection.addNotificationListener(this.removeLocationFromObjectName(objectName), this.removeLocationFromObjectName(objectName2), notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.mbeanServerConnection.removeNotificationListener(this.removeLocationFromObjectName(objectName), this.removeLocationFromObjectName(objectName2));
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.mbeanServerConnection.removeNotificationListener(this.removeLocationFromObjectName(objectName), this.removeLocationFromObjectName(objectName2), notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        NotificationListener notificationListener2 = this.removeRelayNotificationListener(notificationListener);
        this.mbeanServerConnection.removeNotificationListener(this.removeLocationFromObjectName(objectName), notificationListener2);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        NotificationListener notificationListener2 = this.removeRelayNotificationListener(notificationListener);
        this.mbeanServerConnection.removeNotificationListener(this.removeLocationFromObjectName(objectName), notificationListener2, notificationFilter, object);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.mbeanServerConnection.getMBeanInfo(this.removeLocationFromObjectName(objectName));
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
        return this.mbeanServerConnection.isInstanceOf(this.removeLocationFromObjectName(objectName), string);
    }

    private class RelayNotificationListener
    implements NotificationListener {
        private NotificationListener listener;

        RelayNotificationListener(NotificationListener notificationListener) {
            this.listener = notificationListener;
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof MBeanServerNotification) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = ManagedMBeanServerConnection.this.addLocationToObjectName(mBeanServerNotification.getMBeanName());
                notification = new MBeanServerNotification(notification.getType(), notification.getSource(), notification.getSequenceNumber(), objectName);
            } else {
                notification.setSource(ManagedMBeanServerConnection.this.addLocationToResult(notification.getSource()));
            }
            if (debug.isDebugEnabled()) {
                debug.debug("RelayNotificationListener handles Notification: \nType: " + notification.getType() + "\nSource: " + notification.getSource() + "\nMessage: " + notification.getMessage());
            }
            this.listener.handleNotification(notification, object);
        }
    }
}

