/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;

public class ManagedMBeanServerObjectNameManager {
    private String location;
    private Map objectNamesByScoped = new MyLinkedHashMap();
    private Map scopedByObjectName = new MyLinkedHashMap();
    private Map objectNameExceptions = new HashMap();
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");

    public synchronized void registerObject(ObjectName objectName, ObjectName objectName2) {
        ObjectName objectName3 = this.scopedByObjectName.put(objectName, objectName2);
        this.objectNamesByScoped.put(objectName2, objectName);
        if (objectName != null && objectName.getKeyProperty("Location") != null) {
            this.objectNameExceptions.put(objectName2, objectName);
        }
    }

    public synchronized ObjectName unregisterObjectInstance(ObjectName objectName) {
        this.objectNameExceptions.remove(objectName);
        ObjectName objectName2 = (ObjectName)this.objectNamesByScoped.get(objectName);
        if (objectName2 == null) {
            return null;
        }
        this.unregisterObject(objectName2);
        return objectName2;
    }

    public synchronized void unregisterObject(ObjectName objectName) {
        Object v = this.scopedByObjectName.remove(objectName.getCanonicalName());
        ObjectName objectName2 = (ObjectName)this.objectNamesByScoped.remove(v);
    }

    public ManagedMBeanServerObjectNameManager(String string) {
        this.location = string;
    }

    public synchronized ObjectName lookupObjectName(ObjectName objectName) {
        ObjectName objectName2 = (ObjectName)this.objectNamesByScoped.get(objectName);
        if (objectName2 == null) {
            objectName2 = (ObjectName)this.objectNameExceptions.get(objectName);
        }
        if (objectName2 == null) {
            objectName2 = this.removeLocation(objectName);
            this.registerObject(objectName2, objectName);
        }
        return objectName2;
    }

    private ObjectName removeLocation(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        if (objectName.getKeyProperty("Location") == null) {
            return objectName;
        }
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (objectName.isDomainPattern()) {
                stringBuffer.append("*:");
            } else {
                stringBuffer.append(objectName.getDomain() + ":");
            }
            Iterator<Map.Entry<String, String>> iterator = hashtable.entrySet().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().equals("Location")) continue;
                if (!bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(entry.getKey() + "=" + entry.getValue());
                bl = false;
            }
            if (objectName.isPropertyPattern()) {
                if (!bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("*");
            }
            return new ObjectName(stringBuffer.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)malformedObjectNameException);
        }
    }

    public synchronized ObjectName lookupScopedObjectName(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        ObjectName objectName2 = (ObjectName)this.scopedByObjectName.get(objectName);
        if (objectName2 == null) {
            if (objectName.getKeyProperty("Location") != null && this.objectNamesByScoped.get(objectName) != null) {
                if (debug.isDebugEnabled()) {
                    debug.debug("ManagedMBeanServerObjectNameManager: lookupScopedObjectName existing Location entry found for " + objectName);
                }
                return objectName;
            }
            objectName2 = this.addLocation(objectName);
            this.registerObject(objectName, objectName2);
        }
        return objectName2;
    }

    private ObjectName addLocation(ObjectName objectName) {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        hashtable.put("Location", this.location);
        try {
            return new ObjectName(objectName.getDomain(), hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)malformedObjectNameException);
        }
    }

    public static class MyLinkedHashMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private static final int MAX_ENTRIES = Integer.parseInt(System.getProperty("weblogic.management.domainruntime.ObjectNameCacheSize", "100"));

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > MAX_ENTRIES;
        }
    }
}

