/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.management.mbeanservers.edit.ActivationTaskMBean;
import weblogic.management.mbeanservers.edit.Change;
import weblogic.management.mbeanservers.edit.ServerStatus;
import weblogic.management.mbeanservers.edit.internal.ConfigurationManagerMBeanImpl;
import weblogic.management.mbeanservers.edit.internal.ServerStatusImpl;
import weblogic.management.mbeanservers.internal.ServiceImpl;
import weblogic.management.provider.ActivateTask;

public class ActivationTaskMBeanImpl
extends ServiceImpl
implements ActivationTaskMBean {
    private ActivateTask activateTask;
    private ConfigurationManagerMBeanImpl manager;
    private boolean completed;
    private int state;
    private ServerStatus[] serverStatus;
    private Exception taskError;
    private long beginTime;
    private long endTime;
    private String user;
    private Change[] changes;
    private String taskId;

    public ActivationTaskMBeanImpl(ConfigurationManagerMBeanImpl configurationManagerMBeanImpl, ActivateTask activateTask) {
        super(Long.toString(activateTask.getTaskId()), ActivationTaskMBean.class.getName(), configurationManagerMBeanImpl);
        this.activateTask = activateTask;
        this.manager = configurationManagerMBeanImpl;
    }

    public int getState() {
        if (this.completed) {
            return this.state;
        }
        return this.activateTask.getState();
    }

    public ServerStatus[] getStatusByServer() {
        if (this.completed) {
            return this.serverStatus;
        }
        Map map = this.activateTask.getStateOnServers();
        Map map2 = this.activateTask.getFailedServers();
        ServerStatus[] serverStatusArray = new ServerStatus[map.size()];
        Set set = map.entrySet();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Exception exception = (Exception)map2.get(entry.getKey());
            serverStatusArray[n] = new ServerStatusImpl((String)entry.getKey(), (Integer)entry.getValue(), exception);
            ++n;
        }
        return serverStatusArray;
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Activation Task started at " + this.getStartTime() + "\n");
        stringBuffer.append("User that initiated this task " + this.getUser() + "\n");
        stringBuffer.append("Changes that are being activated are: \n");
        Change[] changeArray = this.getChanges();
        for (int i = 0; i < changeArray.length; ++i) {
            stringBuffer.append("    " + changeArray[i].toString());
        }
        stringBuffer.append("Status of this activation per server: \n");
        ServerStatus[] serverStatusArray = this.getStatusByServer();
        for (int i = 0; i < serverStatusArray.length; ++i) {
            stringBuffer.append("  ServerName : " + serverStatusArray[i].getServerName() + "\n");
            stringBuffer.append("    Status : " + this.statusString(serverStatusArray[i].getServerState()) + "\n");
            if (serverStatusArray[i].getServerState() != 5) continue;
            stringBuffer.append("    Exception : " + serverStatusArray[i].getServerException() + "\n");
        }
        return stringBuffer.toString();
    }

    private String statusString(int n) {
        if (n == 0) {
            return "NEW";
        }
        if (n == 4) {
            return "COMMITTED";
        }
        if (n == 2) {
            return "DISTRIBUTED";
        }
        if (n == 1) {
            return "DISTRIBUTING";
        }
        if (n == 5) {
            return "FAILED";
        }
        if (n == 3) {
            return "PENDING";
        }
        if (n == 6) {
            return "CANCELING";
        }
        if (n == 7) {
            return "COMMIT_FAILING";
        }
        return "NEW";
    }

    public Exception getError() {
        if (this.completed) {
            return this.taskError;
        }
        return this.activateTask.getError();
    }

    public long getStartTime() {
        if (this.completed) {
            return this.beginTime;
        }
        return this.activateTask.getBeginTime();
    }

    public long getCompletionTime() {
        if (this.completed) {
            return this.endTime;
        }
        return this.activateTask.getEndTime();
    }

    public String getUser() {
        if (this.completed) {
            return this.user;
        }
        return this.activateTask.getUser();
    }

    public Change[] getChanges() {
        if (this.completed) {
            return this.changes;
        }
        return this.manager.convertBeanUpdatesToChanges(this.activateTask.getChanges());
    }

    public void waitForTaskCompletion() {
        if (this.completed) {
            return;
        }
        this.activateTask.waitForTaskCompletion();
    }

    public void waitForTaskCompletion(long l) {
        if (this.completed) {
            return;
        }
        this.activateTask.waitForTaskCompletion(l);
    }

    public ActivateTask getActivateTask() {
        return this.activateTask;
    }

    void movingToCompleted() {
        this.state = this.getState();
        this.serverStatus = this.getStatusByServer();
        this.taskError = this.getError();
        this.beginTime = this.getStartTime();
        this.endTime = this.getCompletionTime();
        this.user = this.getUser();
        this.changes = this.getChanges();
        this.taskId = this.getName();
        this.completed = true;
        this.activateTask = null;
    }
}

