/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.mbeanservers.edit.ActivationTaskMBean;
import weblogic.management.mbeanservers.edit.Change;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditTimedOutException;
import weblogic.management.mbeanservers.edit.NotEditorException;
import weblogic.management.mbeanservers.edit.ValidationException;
import weblogic.management.mbeanservers.edit.internal.ActivationTaskMBeanImpl;
import weblogic.management.mbeanservers.edit.internal.ChangeImpl;
import weblogic.management.mbeanservers.internal.ServiceImpl;
import weblogic.management.provider.ActivateTask;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditChangesValidationException;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.EditSaveChangesFailedException;
import weblogic.management.provider.EditWaitTimedOutException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public class ConfigurationManagerMBeanImpl
extends ServiceImpl
implements ConfigurationManagerMBean,
TimerListener {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXEdit");
    private EditAccess edit;
    private WLSModelMBeanContext context;
    private List completedTasks;
    private long completedActivationTasksCount = 10L;
    private List uncompletedTasks;
    private TimerManager timerManager;
    private Timer timer;
    public static final long STATUS_CHECK_INTERVAL = 60000L;

    ConfigurationManagerMBeanImpl(EditAccess editAccess, WLSModelMBeanContext wLSModelMBeanContext) {
        super("ConfigurationManager", ConfigurationManagerMBean.class.getName(), null);
        if (editAccess == null) {
            throw new AssertionError((Object)"EditAccess should not be null");
        }
        this.edit = editAccess;
        this.context = wLSModelMBeanContext;
        this.completedTasks = Collections.synchronizedList(new ArrayList());
        this.uncompletedTasks = Collections.synchronizedList(new ArrayList());
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
    }

    public DomainMBean startEdit(int n, int n2) throws EditTimedOutException {
        return this.startEdit(n, n2, false);
    }

    public DomainMBean startEdit(int n, int n2, boolean bl) throws EditTimedOutException {
        try {
            return this.edit.startEdit(n, n2, bl);
        }
        catch (EditWaitTimedOutException editWaitTimedOutException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Timed out starting edit ", (Throwable)((Object)editWaitTimedOutException));
            }
            throw new EditTimedOutException((Throwable)((Object)editWaitTimedOutException));
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception starting edit ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public void stopEdit() throws NotEditorException {
        try {
            this.edit.stopEdit();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Not editor for stop ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception stopping edit ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public void cancelEdit() {
        try {
            this.edit.cancelEdit();
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception canceling edit ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public String getCurrentEditor() {
        return this.edit.getEditor();
    }

    public boolean isEditor() {
        return this.edit.isEditor();
    }

    public long getCurrentEditorStartTime() {
        return this.edit.getEditorStartTime();
    }

    public long getCurrentEditorExpirationTime() {
        return this.edit.getEditorExpirationTime();
    }

    public boolean isCurrentEditorExclusive() {
        return this.edit.isEditorExclusive();
    }

    public boolean isCurrentEditorExpired() {
        long l = this.edit.getEditorExpirationTime();
        if (l <= 0L) {
            return false;
        }
        return l <= System.currentTimeMillis();
    }

    public Change[] getChanges() throws NotEditorException {
        try {
            Iterator iterator = this.edit.getUnsavedChanges();
            return this.convertBeanUpdatesToChanges(iterator);
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Getting changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception getting changes ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public void validate() throws NotEditorException, ValidationException {
        try {
            this.edit.validateChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Validating changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditChangesValidationException editChangesValidationException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception validating changes ", (Throwable)((Object)editChangesValidationException));
            }
            throw new ValidationException((Throwable)((Object)editChangesValidationException));
        }
    }

    public void reload() throws NotEditorException, ValidationException {
        try {
            this.edit.reload();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Reloading changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditChangesValidationException editChangesValidationException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception reloading changes ", (Throwable)((Object)editChangesValidationException));
            }
            throw new ValidationException((Throwable)((Object)editChangesValidationException));
        }
    }

    public void save() throws NotEditorException, ValidationException {
        try {
            this.edit.saveChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Saving changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditSaveChangesFailedException editSaveChangesFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Saving changes failed ", (Throwable)((Object)editSaveChangesFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editSaveChangesFailedException));
        }
        catch (EditChangesValidationException editChangesValidationException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception validating changes ", (Throwable)((Object)editChangesValidationException));
            }
            throw new ValidationException((Throwable)((Object)editChangesValidationException));
        }
    }

    public void undo() throws NotEditorException {
        try {
            this.removeReferences(this.edit.getUnsavedChanges());
            this.edit.undoUnsavedChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Undo changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception undoing changes ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public boolean haveUnactivatedChanges() {
        if (this.edit.isPendingChange()) {
            return true;
        }
        if (!this.edit.isModified()) {
            return false;
        }
        try {
            Iterator iterator = this.edit.getUnactivatedChanges();
            return iterator.hasNext();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Change[] getUnactivatedChanges() throws NotEditorException {
        try {
            Iterator iterator = this.edit.getUnactivatedChanges();
            return this.convertBeanUpdatesToChanges(iterator);
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Getting unactivated changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception getting unactivated changes ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public void undoUnactivatedChanges() throws NotEditorException {
        try {
            this.removeReferences(this.edit.getUnactivatedChanges());
            this.edit.undoUnactivatedChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Undo unactivated changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditFailedException editFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception undoing unactivated changes ", (Throwable)((Object)editFailedException));
            }
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivationTaskMBean activate(long l) throws NotEditorException {
        try {
            ActivateTask activateTask = null;
            if (l == 0L) {
                activateTask = this.edit.activateChanges(Long.MAX_VALUE);
            } else {
                if (l == -1L) {
                    l = Long.MAX_VALUE;
                }
                activateTask = this.edit.activateChangesAndWaitForCompletion(l);
            }
            ActivationTaskMBeanImpl activationTaskMBeanImpl = new ActivationTaskMBeanImpl(this, activateTask);
            this.uncompletedTasks.add(activationTaskMBeanImpl);
            ConfigurationManagerMBeanImpl configurationManagerMBeanImpl = this;
            synchronized (configurationManagerMBeanImpl) {
                if (this.timer == null) {
                    this.timer = this.timerManager.schedule((TimerListener)this, 60000L, 60000L);
                }
            }
            return activationTaskMBeanImpl;
        }
        catch (EditNotEditorException editNotEditorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Activate changes not editor ", (Throwable)((Object)editNotEditorException));
            }
            throw new NotEditorException((Throwable)((Object)editNotEditorException));
        }
        catch (EditFailedException editFailedException) {
            debugLogger.debug("Exception activating changes ", (Throwable)((Object)editFailedException));
            throw new RuntimeException((Throwable)((Object)editFailedException));
        }
    }

    public ActivationTaskMBean[] getCompletedActivationTasks() {
        this.moveCompletedTasksToCompletedList();
        ActivationTaskMBean[] activationTaskMBeanArray = new ActivationTaskMBean[this.completedTasks.size()];
        if (this.completedTasks.size() == 0) {
            return activationTaskMBeanArray;
        }
        this.completedTasks.toArray(activationTaskMBeanArray);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Get all completed tasks" + activationTaskMBeanArray);
        }
        return activationTaskMBeanArray;
    }

    public long getCompletedActivationTasksCount() {
        return this.completedActivationTasksCount;
    }

    public void setCompletedActivationTasksCount(long l) {
        this.completedActivationTasksCount = l;
    }

    public ActivationTaskMBean[] getActivationTasks() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.completedTasks);
        arrayList.addAll(this.uncompletedTasks);
        ActivationTaskMBean[] activationTaskMBeanArray = new ActivationTaskMBean[arrayList.size()];
        return arrayList.toArray(activationTaskMBeanArray);
    }

    public ActivationTaskMBean[] getActiveActivationTasks() {
        this.moveCompletedTasksToCompletedList();
        ActivationTaskMBean[] activationTaskMBeanArray = new ActivationTaskMBean[this.uncompletedTasks.size()];
        if (this.uncompletedTasks.size() == 0) {
            return activationTaskMBeanArray;
        }
        this.uncompletedTasks.toArray(activationTaskMBeanArray);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Get all active tasks" + activationTaskMBeanArray);
        }
        return activationTaskMBeanArray;
    }

    public void purgeCompletedActivationTasks() {
        this.moveCompletedTasksToCompletedList();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Purging all completed tasks");
        }
        this.completedTasks.clear();
    }

    public Change[] getChangesToDestroyBean(DescriptorBean descriptorBean) {
        if (descriptorBean == null) {
            return new Change[0];
        }
        try {
            List list = descriptorBean.getDescriptor().getResolvedReferences(descriptorBean);
            if (list == null) {
                return new Change[0];
            }
            Object[] objectArray = list.toArray();
            Change[] changeArray = new Change[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                ResolvedReference resolvedReference = (ResolvedReference)objectArray[i];
                DescriptorBean descriptorBean2 = resolvedReference.getBean();
                String string = resolvedReference.getPropertyName();
                if (string.indexOf(47) != -1) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                Object object = this.context.mapToJMX(this.getType(descriptorBean2), (Object)descriptorBean2, null);
                BeanInfo beanInfo = this.edit.getBeanInfo(descriptorBean2);
                PropertyDescriptor propertyDescriptor = this.edit.getPropertyDescriptor(beanInfo, string);
                Method method = propertyDescriptor.getReadMethod();
                Object object2 = method.invoke((Object)descriptorBean2, (Object[])null);
                object2 = this.mapValueToJMX(object2);
                Object var14_15 = null;
                boolean bl = this.edit.getRestartValue(propertyDescriptor);
                if (object2 != null && object2 instanceof Object[] && ((Object[])object2).length > 0) {
                    object2 = this.mapValueToJMX(descriptorBean);
                    changeArray[i] = new ChangeImpl(object, string, "remove", object2, var14_15, bl);
                    continue;
                }
                changeArray[i] = new ChangeImpl(object, string, "modify", object2, var14_15, bl);
            }
            return changeArray;
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception getting reference changes ", (Throwable)exception);
            }
            throw new RuntimeException(exception);
        }
    }

    public void removeReferencesToBean(DescriptorBean descriptorBean) throws NotEditorException {
        if (!this.isEditor()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("removeReferencesToBean - not editor ");
            }
            throw new NotEditorException("Not edit lock owner");
        }
        if (descriptorBean == null) {
            return;
        }
        try {
            List list = descriptorBean.getDescriptor().getResolvedReferences(descriptorBean);
            if (list == null) {
                return;
            }
            Object[] objectArray = list.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ResolvedReference resolvedReference = (ResolvedReference)objectArray[i];
                DescriptorBean descriptorBean2 = resolvedReference.getBean();
                String string = resolvedReference.getPropertyName();
                if (string.indexOf(47) != -1) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                BeanInfo beanInfo = this.edit.getBeanInfo(descriptorBean2);
                PropertyDescriptor propertyDescriptor = this.edit.getPropertyDescriptor(beanInfo, string);
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                Object object = method.invoke((Object)descriptorBean2, (Object[])null);
                if (object != null && object instanceof Object[] && ((Object[])object).length > 0) {
                    Object[] objectArray2 = this.removeBeanFromArray((Object[])object, descriptorBean);
                    method2.invoke((Object)descriptorBean2, new Object[]{objectArray2});
                    continue;
                }
                method2.invoke((Object)descriptorBean2, new Object[]{null});
                descriptorBean2.unSet(string);
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception removing references ", (Throwable)exception);
            }
            throw new RuntimeException(exception);
        }
    }

    private Object[] removeBeanFromArray(Object[] objectArray, DescriptorBean descriptorBean) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (descriptorBean.equals(objectArray[i])) continue;
            ++n;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (descriptorBean.equals(objectArray[i])) continue;
            objectArray2[n2++] = objectArray[i];
        }
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void moveCompletedTasksToCompletedList() {
        if (this.uncompletedTasks.size() == 0) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            return;
        }
        List list = this.uncompletedTasks;
        synchronized (list) {
            Iterator iterator = this.uncompletedTasks.iterator();
            while (iterator != null && iterator.hasNext()) {
                ActivationTaskMBeanImpl activationTaskMBeanImpl = (ActivationTaskMBeanImpl)iterator.next();
                if (activationTaskMBeanImpl.getState() != 4 && activationTaskMBeanImpl.getState() != 5) continue;
                iterator.remove();
                if (this.getCompletedActivationTasksCount() > 0L) {
                    activationTaskMBeanImpl.movingToCompleted();
                    this.completedTasks.add(activationTaskMBeanImpl);
                    while ((long)this.completedTasks.size() > this.getCompletedActivationTasksCount()) {
                        ActivationTaskMBean activationTaskMBean = (ActivationTaskMBean)this.completedTasks.remove(0);
                        this.context.unregister((Object)activationTaskMBean);
                    }
                    continue;
                }
                this.context.unregister((Object)activationTaskMBeanImpl);
            }
        }
    }

    public Change[] convertBeanUpdatesToChanges(Iterator iterator) {
        try {
            Change[] changeArray;
            Vector<Object> vector = new Vector<Object>();
            while (iterator.hasNext()) {
                changeArray = (Change[])iterator.next();
                DescriptorBean descriptorBean = changeArray.getSourceBean();
                DescriptorBean descriptorBean2 = changeArray.getProposedBean();
                BeanInfo beanInfo = this.edit.getBeanInfo(descriptorBean2);
                Object object = this.context.mapToJMX(this.getType(descriptorBean2), (Object)descriptorBean2, null);
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = changeArray.getUpdateList();
                for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    Object object2;
                    String string;
                    BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                    String string2 = propertyUpdate.getPropertyName();
                    AbstractDescriptorBean abstractDescriptorBean = null;
                    Object object3 = null;
                    Object object4 = null;
                    PropertyDescriptor propertyDescriptor = this.edit.getPropertyDescriptor(beanInfo, string2);
                    boolean bl = !propertyUpdate.isDynamic();
                    boolean bl2 = propertyUpdate.isUnsetUpdate();
                    if (propertyDescriptor == null) {
                        if (!debugLogger.isDebugEnabled()) continue;
                        debugLogger.debug("Skipping update for internal property name " + string2 + " update:" + propertyUpdate);
                        continue;
                    }
                    Method method = propertyDescriptor.getReadMethod();
                    String string3 = (String)propertyDescriptor.getValue("relationship");
                    boolean bl3 = true;
                    if (string3 != null && string3.equals("containment")) {
                        bl3 = false;
                    }
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Processing update for property name " + string2 + " update:" + propertyUpdate);
                    }
                    switch (propertyUpdate.getUpdateType()) {
                        case 1: {
                            string = bl2 ? "unset" : "modify";
                            object3 = method.invoke((Object)descriptorBean, (Object[])null);
                            object3 = this.mapValueToJMX(object3);
                            object4 = method.invoke((Object)descriptorBean2, (Object[])null);
                            object4 = this.mapValueToJMX(object4);
                            break;
                        }
                        case 2: {
                            string = bl3 ? "add" : "create";
                            object4 = propertyUpdate.getAddedObject();
                            object2 = method.invoke((Object)descriptorBean2, (Object[])null);
                            if (object4 instanceof AbstractDescriptorBean && object2 instanceof AbstractDescriptorBean) {
                                abstractDescriptorBean = (AbstractDescriptorBean)object2;
                            }
                            if (object4 instanceof AbstractDescriptorBean && object2 instanceof DescriptorBean[]) {
                                DescriptorBean[] descriptorBeanArray = (DescriptorBean[])object2;
                                AbstractDescriptorBean abstractDescriptorBean2 = (AbstractDescriptorBean)object4;
                                for (int j = 0; j < descriptorBeanArray.length; ++j) {
                                    AbstractDescriptorBean abstractDescriptorBean3 = (AbstractDescriptorBean)descriptorBeanArray[j];
                                    if (!abstractDescriptorBean2._getKey().equals(abstractDescriptorBean3._getKey())) continue;
                                    abstractDescriptorBean = abstractDescriptorBean3;
                                }
                            }
                            object4 = this.mapValueToJMX(object4);
                            break;
                        }
                        case 3: {
                            string = bl3 ? "remove" : "destroy";
                            object3 = propertyUpdate.getRemovedObject();
                            object3 = this.mapValueToJMX(object3);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected updateType:" + propertyUpdate.getUpdateType()));
                        }
                    }
                    object2 = new ChangeImpl(object, string2, string, object3, object4, bl);
                    vector.add(object2);
                    if (abstractDescriptorBean == null) continue;
                    this.addModifiesForNewBean(abstractDescriptorBean, vector, descriptorBean2, descriptorBean, bl);
                }
            }
            changeArray = new Change[vector.size()];
            vector.toArray(changeArray);
            return changeArray;
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception converting bean events ", (Throwable)exception);
            }
            throw new RuntimeException(exception);
        }
    }

    public void addModifiesForNewBean(AbstractDescriptorBean abstractDescriptorBean, Vector vector, DescriptorBean descriptorBean, DescriptorBean descriptorBean2, boolean bl) {
        try {
            BeanInfo beanInfo = this.edit.getBeanInfo((DescriptorBean)abstractDescriptorBean);
            Object object = this.context.mapToJMX(ObjectName.class, (Object)abstractDescriptorBean, null);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; propertyDescriptorArray != null && i < propertyDescriptorArray.length; ++i) {
                Object object2;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                Boolean bl2 = (Boolean)propertyDescriptor.getValue("key");
                if (bl2 != null && bl2.booleanValue() || propertyDescriptor.getWriteMethod() == null || !abstractDescriptorBean.isSet(propertyDescriptor.getName())) continue;
                Method method = propertyDescriptor.getReadMethod();
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Getter method is " + method);
                    debugLogger.debug("Source bean is " + descriptorBean2);
                }
                Object object3 = method.invoke((Object)abstractDescriptorBean, (Object[])null);
                Object object4 = propertyDescriptor.getValue("default");
                if (object4 == null && object3 == null || object4 != null && object4.equals(object3)) {
                    if (!debugLogger.isDebugEnabled()) continue;
                    debugLogger.debug("Skipping default value " + propertyDescriptor.getName());
                    continue;
                }
                if (object3 instanceof DescriptorBean[]) {
                    object2 = (DescriptorBean[])object3;
                    for (int j = 0; j < ((DescriptorBean[])object2).length; ++j) {
                        object3 = this.mapValueToJMX(object2[j]);
                        ChangeImpl changeImpl = new ChangeImpl(object, propertyDescriptor.getName(), "add", null, object3, bl);
                        vector.add(changeImpl);
                    }
                    continue;
                }
                object3 = this.mapValueToJMX(object3);
                object2 = new ChangeImpl(object, propertyDescriptor.getName(), "modify", null, object3, bl);
                vector.add(object2);
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception add modifies for new bean ", (Throwable)exception);
            }
            throw new RuntimeException(exception);
        }
    }

    private Object mapValueToJMX(Object object) {
        if (object instanceof AbstractDescriptorBean) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)object;
            return abstractDescriptorBean._getKey();
        }
        if (object instanceof DescriptorBean[]) {
            DescriptorBean[] descriptorBeanArray = (DescriptorBean[])object;
            String[] stringArray = new String[descriptorBeanArray.length];
            for (int i = 0; i < descriptorBeanArray.length; ++i) {
                if (descriptorBeanArray[i] == null) continue;
                stringArray[i] = ((AbstractDescriptorBean)descriptorBeanArray[i])._getKey().toString();
            }
            return stringArray;
        }
        return object;
    }

    private Class getType(Object object) {
        Class<?> clazz = object.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            String string;
            Class<?> clazz2 = classArray[i];
            if (clazz2 == DescriptorBean.class || !(string = clazz2.getName()).endsWith("Bean")) continue;
            return clazz2;
        }
        return object.getClass();
    }

    public void timerExpired(Timer timer) {
        this.moveCompletedTasksToCompletedList();
    }

    private void removeReferences(Iterator iterator) throws NotEditorException {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            BeanUpdateEvent beanUpdateEvent = (BeanUpdateEvent)iterator.next();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                Object object;
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                if (propertyUpdate.getUpdateType() != 2 || !((object = propertyUpdate.getAddedObject()) instanceof DescriptorBean)) continue;
                this.removeReferencesToBean((DescriptorBean)object);
            }
        }
    }
}

