/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.internal.ConfigurationManagerMBeanImpl;
import weblogic.management.mbeanservers.internal.ServiceImplBeanInfo;

public class ConfigurationManagerMBeanImplBeanInfo
extends ServiceImplBeanInfo {
    public static Class INTERFACE_CLASS = ConfigurationManagerMBean.class;

    public ConfigurationManagerMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public ConfigurationManagerMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = ConfigurationManagerMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "9.0.0.0");
        beanDescriptor.setValue("package", "weblogic.management.mbeanservers.edit.internal");
        String string = new String("<p>Manages changes to the configuration of the current WebLogic Server domain. The operations in this MBean start and stop edit sessions, save, undo, and activate configuration changes.</p>  <p>The general process for changing the configuration of a domain is as follows:</p>  <ol> <li> <p>Use this MBean's <code>startEdit()</code> operation to start an edit session.</p>  <p>When you start an edit session, WebLogic Server locks other users from editing the pending configuration MBean hierarchy. If two users start an edit session under the same user identity, changes from both users are collected into a single set of changes.</p>  <p>The operation returns the pending <code>DomainMBean</code>, which is the root of the configuration MBean hierarchy.</p> </li>  <li> <p>Navigate to an MBean and change the value of its attributes or add or remove a child MBean.</p> </li>  <li> <p>Save your changes.</p>  <p>Your saved changes are written to the domain's pending configuration files.</p> </li>  <li> <p>(Optional) Make additional changes or undo the changes.</p> </li>  <li> <p>Use this MBean's <code>activate()</code> operation to activate the saved changes.</p>  <p>When you activate, the changes are propagated to all the servers in the domain and applied to the running configuration.</p> </li> </ol> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
        beanDescriptor.setValue("rolesAllowed", stringArray);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.mbeanservers.edit.ConfigurationManagerMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("ActivationTasks")) {
            string2 = "getActivationTasks";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ActivationTasks", ConfigurationManagerMBean.class, string2, string);
            map.put("ActivationTasks", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the list of all <code>ActivationTaskMBean</code> instances that have been created. </p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("ActiveActivationTasks")) {
            string2 = "getActiveActivationTasks";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ActiveActivationTasks", ConfigurationManagerMBean.class, string2, string);
            map.put("ActiveActivationTasks", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains the <code>ActivationTaskMBeans</code> that provide information about activation tasks that are in progress.</p> ");
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ActivationTaskMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("Changes")) {
            string2 = "getChanges";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Changes", ConfigurationManagerMBean.class, string2, string);
            map.put("Changes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains <code>Change</code> objects for all of the unsaved changes in the current edit session. Each change to an MBean attribute is represented in its own <code>Change</code> object.</p> ");
        }
        if (!map.containsKey("CompletedActivationTasks")) {
            string2 = "getCompletedActivationTasks";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CompletedActivationTasks", ConfigurationManagerMBean.class, string2, string);
            map.put("CompletedActivationTasks", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains all <code>ActivationTaskMBeans</code> that are stored in memory and that describe activation tasks that have completed.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("CompletedActivationTasksCount")) {
            string2 = "getCompletedActivationTasksCount";
            string = null;
            if (!this.readOnly) {
                string = "setCompletedActivationTasksCount";
            }
            propertyDescriptor = new PropertyDescriptor("CompletedActivationTasksCount", ConfigurationManagerMBean.class, string2, string);
            map.put("CompletedActivationTasksCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of <code>ActivationTaskMBeans</code> that WebLogic Server keeps in memory.</p>  <p>Each <code>ActivationTaskMBean</code> contains one <code>Change</code> object for each change that was activated. The MBean and its <code>Change</code> objects describe which user activated the changes, when the changes were activated, and which MBean attributes were modified.</p>  <p>WebLogic Server does not save this data to disk, and therefore it is not available across sessions of the Administration Server.</p>  <p>Because a large collection of <code>ActivationTaskMBean</code>s could potentially use a significant amount of memory, the default number is 10.</p> ");
        }
        if (!map.containsKey("CurrentEditor")) {
            string2 = "getCurrentEditor";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentEditor", ConfigurationManagerMBean.class, string2, string);
            map.put("CurrentEditor", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the user who started the current edit session.</p> ");
        }
        if (!map.containsKey("CurrentEditorExpirationTime")) {
            string2 = "getCurrentEditorExpirationTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentEditorExpirationTime", ConfigurationManagerMBean.class, string2, string);
            map.put("CurrentEditorExpirationTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The time at which the current edit session expires as determined by the timeout parameter of the <code>startEdit</code> operation.</p> ");
        }
        if (!map.containsKey("CurrentEditorStartTime")) {
            string2 = "getCurrentEditorStartTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentEditorStartTime", ConfigurationManagerMBean.class, string2, string);
            map.put("CurrentEditorStartTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The time at which the current edit session started.</p> ");
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Name", ConfigurationManagerMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>A unique key that WebLogic Server generates to identify the current instance of this MBean type.</p>  <p>For a singleton, such as <code>DomainRuntimeServiceMBean</code>, this key is often just the bean's short class name.</p> ");
        }
        if (!map.containsKey("ParentAttribute")) {
            string2 = "getParentAttribute";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentAttribute", ConfigurationManagerMBean.class, string2, string);
            map.put("ParentAttribute", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the attribute of the parent that refers to this bean</p> ");
        }
        if (!map.containsKey("ParentService")) {
            string2 = "getParentService";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentService", ConfigurationManagerMBean.class, string2, string);
            map.put("ParentService", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean that created the current MBean instance.</p>  <p>In the data model for WebLogic Server MBeans, an MBean that creates another MBean is called a <i>parent</i>. MBeans at the top of the hierarchy have no parents.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("Path")) {
            string2 = "getPath";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Path", ConfigurationManagerMBean.class, string2, string);
            map.put("Path", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the path to the bean relative to the reoot of the heirarchy of services</p> ");
        }
        if (!map.containsKey("Type")) {
            string2 = "getType";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Type", ConfigurationManagerMBean.class, string2, string);
            map.put("Type", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean type for this instance. This is useful for MBean types that support multiple intances, such as <code>ActivationTaskMBean</code>.</p> ");
        }
        if (!map.containsKey("UnactivatedChanges")) {
            string2 = "getUnactivatedChanges";
            string = null;
            propertyDescriptor = new PropertyDescriptor("UnactivatedChanges", ConfigurationManagerMBean.class, string2, string);
            map.put("UnactivatedChanges", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains <code>Change</code> objects for all changes (saved or unsaved) that have been made since the <code>activate</code> operation completed successfully. This includes any changes that have been saved but not activated in the current and previous edit sessions. </p> <p>Each change to an MBean attribute is described in its own <code>Change</code> object.</p> ");
        }
        if (!map.containsKey("CurrentEditorExclusive")) {
            string2 = "isCurrentEditorExclusive";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentEditorExclusive", ConfigurationManagerMBean.class, string2, string);
            map.put("CurrentEditorExclusive", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether the edit session is exclusive as determined by the exclusive parameter of the <code>startEdit</code> operation.</p> ");
        }
        if (!map.containsKey("CurrentEditorExpired")) {
            string2 = "isCurrentEditorExpired";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentEditorExpired", ConfigurationManagerMBean.class, string2, string);
            map.put("CurrentEditorExpired", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether the edit session is expired as determined by the timeout parameter of the <code>startEdit</code> operation.</p> ");
        }
        if (!map.containsKey("Editor")) {
            string2 = "isEditor";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Editor", ConfigurationManagerMBean.class, string2, string);
            map.put("Editor", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns true if the caller started the current edit session.</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        MethodDescriptor methodDescriptor;
        Method method = ConfigurationManagerMBean.class.getMethod("startEdit", Integer.TYPE, Integer.TYPE);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"waitTimeInMillis", (String)"Prevents other uses from starting an edit session until waitTimeInMillis expires, edits are activated, or the edit session is stopped. If the value of waitTimeInMillis is 0 and an edit session is active, this operation returns immediately. To block indefinitely, specify a value of -1. "), ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"timeOutInMillis", (String)"Specifies the number of milliseconds after which the lock on the configuration is no longer guaranteed. This time out is enforced lazily. If no other user starts an edit session after the timeout expires, the unsaved changes are left intact and may be saved. If another user starts an edit session after the timeout expires, unsaved changes are automatically reverted and the lock is given to that new user. Specify a value of -1 to indicate that you do not want the edit to time out. In this case, if you do not stop your edit session, only an administrator can stop the edit session by invokeing the cancelEdit operation. ")};
        Object object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"EditTimedOutException thrown when the start edit request times out because the wait time has elasped and another user still has the edit session.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Starts an edit session on behalf of the currently authenticated user and prevents other users from editing the configuration for the duration of the session. A user must call this operation before modifying the configuration of the domain.</p>  <p>If two users or processes start an edit session under the same user identity, changes from both users are collected into a single set of changes.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConfigurationManagerMBean.class.getMethod("startEdit", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        parameterDescriptorArray = new ParameterDescriptor[]{ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"waitTimeInMillis", (String)"Prevents other uses from starting an edit session until waitTimeInMillis expires, edits are activated, or the edit session is stopped. If the value of waitTimeInMillis is 0 and an edit session is active, this operation returns immediately. To block indefinitely, specify a value of -1. "), ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"timeOutInMillis", (String)"Specifies the number of milliseconds after which the lock on the configuration is no longer guaranteed. This time out is enforced lazily. If no other user starts an edit session after the timeout expires, the unsaved changes are left intact and may be saved. If another user starts an edit session after the timeout expires, unsaved changes are automatically reverted and the lock is given to that new user. Specify a value of -1 to indicate that you do not want the edit to time out. In this case, if you do not stop your edit session, only an administrator can stop the edit session by invokeing the cancelEdit operation. "), ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"exclusive", (String)"Specifies whether the edit session should be exclusive. An edit session will cause a subsequent call to startEdit by the same owner to wait until the edit session lock is released. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"EditTimedOutException thrown when the start edit request times out because the wait time has elasped and another user still has the edit session.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Starts an edit session on behalf of the currently authenticated user and prevents other users from editing the configuration for the duration of the session. A user must call this operation before modifying the configuration of the domain.</p>  <p>Prevents multiple users or processes from starting an edit session under the same user identity.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("stopEdit", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Stops the current edit session, releases the edit lock, and enables other users to start an edit session. Any unsaved changes are discarded.</p>  <p>This operation can be invoked only by the user who started the edit session.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("cancelEdit", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Cancels the current edit session, releases the edit lock, and enables other users to start an edit session. Any unsaved changes are discarded; saved changes remain pending.</p>  <p>This operation can be called by any user with administrator privileges, even if the user is not the one who started the edit session. Use this operation to cancel an edit session when the current editor can not be contacted to stop an edit session and release the lock. To instead discard all changes, saved and unsaved, see the undoUnactivatedChanges operation.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("validate", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session."), BeanInfoHelper.encodeEntities((String)"ValidationException thrown if an validation error occurs while validating changes.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Verifies that all unsaved changes satisfy dependencies between MBean attributes and makes other checks that cannot be made at the time that you set the value of a single attribute.</p>  <p>The <code>save</code> operation also validates changes, but you can use this (<code>validate</code>) operation to check that changes are valid before saving them.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("reload", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session."), BeanInfoHelper.encodeEntities((String)"ValidationException thrown if an validation error occurs  while reloading files.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Reloads the configuration files from the pending directory updates the configuration contained in the Edit MBeanServer.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("save", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session."), BeanInfoHelper.encodeEntities((String)"ValidationException thrown if an validation error occurs while saving changes.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Validates unsaved changes and saves them to the pending configuration files on disk.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("undo", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Undoes all unsaved changes. This reverts the hierarchy of pending configuration MBeans to the last saved state of the pending configuration files, discarding in-memory changes.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("haveUnactivatedChanges", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Returns true if any changes (saved or unsaved) have been made since the <code>activate</code> operation completed successfully. This includes any changes that have been saved but not activated in the current and previous edit sessions.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("undoUnactivatedChanges", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Undoes all of the changes (saved or unsaved) that have been made since the <code>activate</code> operation completed successfully. This includes any changes that have been saved but not activated in the current and previous edit sessions.</p>  <p>This reverts the hierarchy of pending configuration MBeans to the last successful activate state of the domain, discarding any changes made but not activated.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConfigurationManagerMBean.class.getMethod("activate", Long.TYPE);
        parameterDescriptorArray = new ParameterDescriptor[]{ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"timeout", (String)"long that contains the time (milliseconds) for the operation to complete. If the elasped time exceeds that value, then the activation of the configuration changes will be canceled. If -1, then the activation will not timeout. If a non-zero timeout is specified, then the activate will wait   until the activate operation has completed or until the timeout period   has elasped. If a zero timeout is specified, then the activate will return   immediately and the caller can wait for completion using the ActivationTaskMBean. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Activates the changes that have been saved to the pending configuration files.</p>  <p>To activate changes, WebLogic Server copies the pending configuration files to a pending directory within each server instance's root directory. Each server instance determines whether it can consume the changes. If all servers can, then the pending configuration files become the active configuration files and the in-memory hierarchy of active configuration MBeans is updated for each server.</p>  <p>If any server is unable to consume the change, then the activation fails for all servers. All saved changes remain in the pending configuration files and can be activated later.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConfigurationManagerMBean.class.getMethod("purgeCompletedActivationTasks", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Purges from memory all <code>ActivationTaskMBeans</code> that represent completed activation tasks.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConfigurationManagerMBean.class.getMethod("getChangesToDestroyBean", DescriptorBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"configurationMBean", null)};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Contains <code>Change</code> objects for the changes required to destroy the specified instance of a configuration bean. Each change to an MBean attribute is represented in its own <code>Change</code> object.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConfigurationManagerMBean.class.getMethod("removeReferencesToBean", DescriptorBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConfigurationManagerMBeanImplBeanInfo.createParameterDescriptor((String)"configurationMBean", null)};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotEditorException thrown if the caller did not start the current edit session.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Removes references to bean that must be removed in order to destroy the specified instance of a configuration bean.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

