/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.io.IOException;
import java.security.AccessController;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.jmx.modelmbean.WLSModelMBean;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class EditLockInterceptor
extends WLSMBeanServerInterceptorBase {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXEdit");
    private WLSMBeanServer wlsMBeanServer;
    private EditAccess editAccess;

    public EditLockInterceptor(WLSMBeanServer wLSMBeanServer) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.editAccess = ManagementServiceRestricted.getEditAccess(authenticatedSubject);
        this.wlsMBeanServer = wLSMBeanServer;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        this.checkEditLock();
        ObjectInstance objectInstance = super.createMBean(string, objectName);
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        this.checkEditLock();
        ObjectInstance objectInstance = super.createMBean(string, objectName, objectName2);
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        this.checkEditLock();
        ObjectInstance objectInstance = super.createMBean(string, objectName, objectArray, stringArray);
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        this.checkEditLock();
        ObjectInstance objectInstance = super.createMBean(string, objectName, objectName2, objectArray, stringArray);
        return objectInstance;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.checkEditLock();
        super.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        this.checkEditLock();
        AttributeList attributeList2 = super.setAttributes(objectName, attributeList);
        return attributeList2;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        WLSModelMBean wLSModelMBean;
        String string2;
        if (this.editAccess.isEditor()) {
            return super.invoke(objectName, string, objectArray, stringArray);
        }
        String string3 = string;
        boolean bl = false;
        Object object = this.wlsMBeanServer.lookupObject(objectName);
        if (object != null && object instanceof WLSModelMBean && (string2 = (wLSModelMBean = (WLSModelMBean)object).getRole(string3, objectArray, stringArray)) != null) {
            String string4;
            if (string2.equals("factory") || string2.equals("collection")) {
                bl = true;
            } else if (string2.equals("operation") && (string4 = wLSModelMBean.getImpact(string3, objectArray, stringArray)) != null && !string4.equals("info")) {
                bl = true;
            }
        }
        if (bl) {
            this.checkEditLock();
        }
        return super.invoke(objectName, string, objectArray, stringArray);
    }

    private void checkEditLock() {
        if (!this.editAccess.isEditor()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Caller does not own the edit lock.");
            }
            throw new NoAccessRuntimeException("Operation can not be performed as caller has not started an edit session");
        }
    }
}

