/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.JMXMBean;
import weblogic.management.jmx.ObjectNameManager;
import weblogic.management.jmx.ObjectSecurityManager;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptor;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.jmx.modelmbean.WLSModelMBeanFactory;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.mbeanservers.edit.RecordingManagerMBean;
import weblogic.management.mbeanservers.edit.internal.EditLockInterceptor;
import weblogic.management.mbeanservers.edit.internal.EditServiceMBeanImpl;
import weblogic.management.mbeanservers.edit.internal.RecordingInterceptor;
import weblogic.management.mbeanservers.internal.JMXContextInterceptor;
import weblogic.management.mbeanservers.internal.MBeanServerServiceBase;
import weblogic.management.mbeanservers.internal.SecurityInterceptor;
import weblogic.management.mbeanservers.internal.SecurityMBeanMgmtOpsInterceptor;
import weblogic.management.mbeanservers.internal.WLSObjectNameManager;
import weblogic.management.mbeanservers.internal.WLSObjectSecurityManagerImpl;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServiceFailureException;

public class EditServerService
extends MBeanServerServiceBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXEdit");
    private static final String JNDI = "/jndi/";
    private WLSModelMBeanContext context;
    private static EditServerService singleton;
    private static AuthenticatedSubject kernelId;

    public EditServerService() {
        singleton = this;
    }

    public void start() throws ServiceFailureException {
        if (!this.isEnabled()) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("Starting MBeanServer weblogic.management.mbeanservers.edit");
        }
        this.initialize("weblogic.management.mbeanservers.edit", null);
        WLSMBeanServer wLSMBeanServer = (WLSMBeanServer)this.getMBeanServer();
        SecurityInterceptor securityInterceptor = new SecurityInterceptor(wLSMBeanServer);
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)securityInterceptor);
        EditLockInterceptor editLockInterceptor = new EditLockInterceptor(wLSMBeanServer);
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)editLockInterceptor);
        SecurityMBeanMgmtOpsInterceptor securityMBeanMgmtOpsInterceptor = new SecurityMBeanMgmtOpsInterceptor(1);
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)securityMBeanMgmtOpsInterceptor);
        RecordingInterceptor recordingInterceptor = new RecordingInterceptor();
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)recordingInterceptor);
        JMXContextInterceptor jMXContextInterceptor = new JMXContextInterceptor();
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)jMXContextInterceptor);
        wLSMBeanServer.setFirstAccessCallback(this.createAccessCallback());
        super.start();
        if (debug.isDebugEnabled()) {
            debug.debug("Starting MBeanServer weblogic.management.mbeanservers.edit");
        }
    }

    private WLSMBeanServer.FirstAccessCallback createAccessCallback() {
        return new WLSMBeanServer.FirstAccessCallback(){

            public void accessed(MBeanServer mBeanServer) {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        EditServerService.this.registerAllMBeans();
                        return null;
                    }
                });
            }
        };
    }

    private void registerAllMBeans() {
        try {
            EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            WLSObjectNameManager wLSObjectNameManager = new WLSObjectNameManager(runtimeAccess.getDomainName());
            WLSMBeanServer wLSMBeanServer = (WLSMBeanServer)this.getMBeanServer();
            this.context = new WLSModelMBeanContext((MBeanServer)wLSMBeanServer, (ObjectNameManager)wLSObjectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            this.context.setRecurse(false);
            this.context.setVersion("12.0.0.0");
            this.context.setReadOnly(false);
            EditServiceMBeanImpl editServiceMBeanImpl = new EditServiceMBeanImpl(editAccess, this.context);
            this.registerTypeService(this.context);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)editServiceMBeanImpl, (ObjectName)new ObjectName(EditServiceMBean.OBJECT_NAME), (WLSModelMBeanContext)this.context);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)editServiceMBeanImpl.getConfigurationManager(), (ObjectName)new ObjectName(ConfigurationManagerMBean.OBJECT_NAME), (WLSModelMBeanContext)this.context);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)editServiceMBeanImpl.getRecordingManager(), (ObjectName)new ObjectName(RecordingManagerMBean.OBJECT_NAME), (WLSModelMBeanContext)this.context);
            this.context.setRecurse(true);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)editServiceMBeanImpl.getDomainConfiguration(), (WLSModelMBeanContext)this.context);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (OperationsException operationsException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Operations exception starting MBeanServer ", (Throwable)operationsException);
            }
            throw new Error("Unable to register Edit Access ", operationsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            if (debug.isDebugEnabled()) {
                debug.debug("MBean registration exception starting MBeanServer ", (Throwable)mBeanRegistrationException);
            }
            throw new Error("Unable to register Edit Access ", mBeanRegistrationException);
        }
    }

    private boolean isEnabled() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (!runtimeAccess.isAdminServer()) {
            return false;
        }
        JMXMBean jMXMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getJMX();
        return jMXMBean.isEditMBeanServerEnabled();
    }

    public void stop() throws ServiceFailureException {
        if (!this.isEnabled()) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("Stopping MBeanServer weblogic.management.mbeanservers.edit");
        }
        super.stop();
    }

    public static WLSModelMBeanContext getContext() {
        return EditServerService.singleton.context;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

