/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.Date;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementLogger;
import weblogic.management.WebLogicMBean;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.RecordingManagerMBean;
import weblogic.management.mbeanservers.internal.RecordingManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.scripting.WLSTPathUtil;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.StringUtils;

public class RecordingInterceptor
extends WLSMBeanServerInterceptorBase {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXEdit");
    private static HashMap cmOperToWLSTMap = null;
    private static final AuthenticatedSubject kernelIdentity;
    private HashMap pathCache = new HashMap();
    private String domainName = ManagementService.getRuntimeAccess(kernelIdentity).getDomainName();

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            if (RecordingManager.getInstance().isRecording()) {
                String string = attribute.getName();
                Object object = attribute.getValue();
                String string2 = this.lookupPath(objectName);
                if (string2 != null) {
                    this.write("cd('" + string2 + "')", true);
                    if (object instanceof String && this.isEncrypted(objectName, string)) {
                        String string3 = string + "_" + String.valueOf(new Date().getTime());
                        this.encrypt(string, string3, (String)object);
                    } else {
                        String string4 = this.objectToString(object);
                        if (string4.startsWith("jarray")) {
                            this.write("set('" + string + "'," + string4 + ")");
                        } else {
                            this.write("cmo.set" + string + "(" + string4 + ")");
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            ManagementLogger.logSetAttributeRecordingIOException((ObjectName)objectName, (String)attribute.getName(), (Throwable)iOException);
        }
        super.setAttribute(objectName, attribute);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            if (RecordingManager.getInstance().isRecording() && !string.startsWith("lookup") && !string.equals("isSet")) {
                String string2;
                if (ConfigurationManagerMBean.OBJECT_NAME.equals(objectName.toString())) {
                    String string3 = (String)cmOperToWLSTMap.get(string);
                    if (string3 != null) {
                        String string4;
                        if (string.equals("removeReferencesToBean")) {
                            string4 = this.getParameterList(objectArray);
                            string3 = string3 + "(" + string4 + ")";
                        }
                        if (string.equals("startEdit") && RecordingManager.getInstance().isVerbose()) {
                            string4 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelIdentity);
                            String string5 = "# User " + SubjectUtils.getUsername((AuthenticatedSubject)string4) + " starts a new edit session at " + new Date().toString();
                            string3 = string5 + "\n" + string3;
                        }
                        this.write(string3, true);
                    }
                } else if (!RecordingManagerMBean.OBJECT_NAME.equals(objectName.toString()) && (string2 = this.lookupPath(objectName)) != null) {
                    this.write("cd('" + string2 + "')", true);
                    this.write("cmo." + string + "(" + this.getParameterList(objectArray) + ")");
                }
            }
        }
        catch (IOException iOException) {
            ManagementLogger.logInvokeRecordingIOException((ObjectName)objectName, (String)string, (Throwable)iOException);
        }
        return super.invoke(objectName, string, objectArray, stringArray);
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "None";
        }
        if (object instanceof String) {
            String string = StringUtils.escapeString((String)((String)object));
            return "'" + string + "'";
        }
        if (object instanceof ObjectName) {
            String string = this.lookupPath((ObjectName)object);
            return "getMBean('" + string + "')";
        }
        if (object instanceof String[]) {
            Object[] objectArray = (String[])object;
            return this.arrayToString(objectArray, "String");
        }
        if (object instanceof ObjectName[]) {
            Object[] objectArray = (ObjectName[])object;
            return this.arrayToString(objectArray, "ObjectName");
        }
        if (object instanceof WebLogicMBean[]) {
            WebLogicMBean[] webLogicMBeanArray = (WebLogicMBean[])object;
            Object[] objectArray = new ObjectName[webLogicMBeanArray.length];
            for (int i = 0; i < webLogicMBeanArray.length; ++i) {
                objectArray[i] = webLogicMBeanArray[i].getObjectName();
            }
            return this.arrayToString(objectArray, "ObjectName");
        }
        return object.toString();
    }

    private String arrayToString(Object[] objectArray, String string) {
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string + "('" + objectArray[i] + "')";
        }
        return "jarray.array([" + string2 + "], " + string + ")";
    }

    private String getParameterList(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.objectToString(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    private String lookupPath(ObjectName objectName) {
        String string;
        block5: {
            if (objectName == null) {
                throw new IllegalArgumentException("ObjectName can not be null.");
            }
            string = (String)this.pathCache.get(objectName);
            if (string != null) {
                return string;
            }
            try {
                string = WLSTPathUtil.lookupPath((MBeanServerConnection)((Object)this), this.domainName, objectName);
            }
            catch (Exception exception) {
                if (!debugLogger.isDebugEnabled()) break block5;
                debugLogger.debug("Recording error: can not get WLST path for " + objectName.getCanonicalName(), (Throwable)exception);
            }
        }
        if (string == null) {
            return null;
        }
        string = string.startsWith("Domains") ? "/" : "/" + string;
        this.pathCache.put(objectName, string);
        return string;
    }

    private boolean isEncrypted(ObjectName objectName, String string) {
        try {
            Object object;
            ModelMBeanAttributeInfo modelMBeanAttributeInfo;
            MBeanInfo mBeanInfo = this.getMBeanInfo(objectName);
            if (mBeanInfo != null && mBeanInfo instanceof ModelMBeanInfo && (modelMBeanAttributeInfo = ((ModelMBeanInfo)((Object)mBeanInfo)).getAttribute(string)) != null && (object = modelMBeanAttributeInfo.getDescriptor().getFieldValue("com.bea.encrypted")) != null) {
                return (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void write(String string) throws IOException {
        this.write(string, false);
    }

    private void write(String string, boolean bl) throws IOException {
        RecordingManager.getInstance().write(string, bl, true);
    }

    private void encrypt(String string, String string2, String string3) throws IOException {
        RecordingManager.getInstance().encrypt(string, string2, string3);
    }

    static {
        cmOperToWLSTMap = new HashMap();
        cmOperToWLSTMap.put("startEdit", "startEdit()");
        cmOperToWLSTMap.put("stopEdit", "stopEdit('y')");
        cmOperToWLSTMap.put("cancelEdit", "cancelEdit('y')");
        cmOperToWLSTMap.put("undo", "undo(defaultAnswer='y')");
        cmOperToWLSTMap.put("undoUnactivatedChanges", "undo(defaultAnswer='y', unactivatedChanges='true')");
        cmOperToWLSTMap.put("activate", "activate()");
        cmOperToWLSTMap.put("removeReferencesToBean", "editService.getConfigurationManager().removeReferencesToBean");
        kernelIdentity = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

