/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.edit.internal;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.mbeanservers.edit.RecordingManagerMBean;
import weblogic.management.mbeanservers.edit.internal.RecordingManagerMBeanImpl;
import weblogic.management.mbeanservers.internal.ServiceImplBeanInfo;

public class RecordingManagerMBeanImplBeanInfo
extends ServiceImplBeanInfo {
    public static Class INTERFACE_CLASS = RecordingManagerMBean.class;

    public RecordingManagerMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public RecordingManagerMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = RecordingManagerMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.mbeanservers.edit.internal");
        String string = new String("<p>This MBean records configuration actions that occur during an edit session and writes the actions as series of WebLogic Scripting Tool (WLST) commands. You can then use WLST to replay the commands.</p>  <p>WLST is a command-line scripting environment that you can use to create, manage, and monitor WebLogic Server domains. It is installed on your system when you install WebLogic Server. </p> <p> This MBean does <b>not</b> record WLST commands for the following: </p> <ul> <li> Changes to the security data that is maintained by a security provider. For example, you cannot record the commands to add or remove users, roles, and policies. </li> <li>Changes to deployment plans.</li> <li> Runtime operations found on Control or Monitoring pages, such as starting and stopping applications or servers. </li> </ul> <p> You cannot remove or undo a command once it has been recorded. Instead, you can edit the script file after you stop recording. </p> <p>If you record commands that get or set the values of encrypted attributes (such the password for a server's Java Standard Trust keystore), this MBean creates two files in addition to the script file: a user configuration file that contains the encrypted data and a key file that contains the key used to encrypt the data. Use the file system to limit read and write access to the key file. Users who can read the key file can read all of the encrypted data that you recorded. </p>  <p>The key file and user configuration files are created in the same directory as the recorded script file and are named <code><i>recording-file</i>Config</code> and <code><i>recording-file</i>Secret</code> where <code><i>recording-file</i></code> is the name of the recorded script file.</p> <p>When you use WLST to replay the commands, the user configuration and key files must be in the same directory as the script file. If you move the script file, you must also move the user configuration and key files. Only the key file that was used to encrypt the data can be used to unencrypt the data.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
        beanDescriptor.setValue("rolesAllowed", stringArray);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.mbeanservers.edit.RecordingManagerMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Name", RecordingManagerMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>A unique key that WebLogic Server generates to identify the current instance of this MBean type.</p>  <p>For a singleton, such as <code>DomainRuntimeServiceMBean</code>, this key is often just the bean's short class name.</p> ");
        }
        if (!map.containsKey("ParentAttribute")) {
            string2 = "getParentAttribute";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentAttribute", RecordingManagerMBean.class, string2, string);
            map.put("ParentAttribute", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the attribute of the parent that refers to this bean</p> ");
        }
        if (!map.containsKey("ParentService")) {
            string2 = "getParentService";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentService", RecordingManagerMBean.class, string2, string);
            map.put("ParentService", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean that created the current MBean instance.</p>  <p>In the data model for WebLogic Server MBeans, an MBean that creates another MBean is called a <i>parent</i>. MBeans at the top of the hierarchy have no parents.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("Path")) {
            string2 = "getPath";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Path", RecordingManagerMBean.class, string2, string);
            map.put("Path", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the path to the bean relative to the reoot of the heirarchy of services</p> ");
        }
        if (!map.containsKey("RecordingFileName")) {
            string2 = "getRecordingFileName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("RecordingFileName", RecordingManagerMBean.class, string2, string);
            map.put("RecordingFileName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the full path of the recording file. </p> ");
        }
        if (!map.containsKey("Type")) {
            string2 = "getType";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Type", RecordingManagerMBean.class, string2, string);
            map.put("Type", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean type for this instance. This is useful for MBean types that support multiple intances, such as <code>ActivationTaskMBean</code>.</p> ");
        }
        if (!map.containsKey("Recording")) {
            string2 = "isRecording";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Recording", RecordingManagerMBean.class, string2, string);
            map.put("Recording", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether a recording session is currently in progress.</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        MethodDescriptor methodDescriptor;
        Method method = RecordingManagerMBean.class.getMethod("startRecording", String.class, Boolean.TYPE);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{RecordingManagerMBeanImplBeanInfo.createParameterDescriptor((String)"fileName", (String)"Absolute path and file name for the file in which to write WLST commands. "), RecordingManagerMBeanImplBeanInfo.createParameterDescriptor((String)"append", (String)"If set to true, this method writes WLST commands at the end of the recording file instead of the beginning. ")};
        Object object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"RecordingException If a recording session is already started or            the specified file cannot be opened.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Starts a recording session. The recorded actions will be saved as WLST commands in the specified file. Actions are recorded and written as you invoke them.</p> <p>If the specified file already exists, this method adds the WLST commands to the beginning or end of the file, depending on which value you pass in the <code>append</code> argument. This method does not overwrite an existing file.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = RecordingManagerMBean.class.getMethod("startRecording", String.class, Map.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RecordingManagerMBeanImplBeanInfo.createParameterDescriptor((String)"fileName", (String)"recording filename "), RecordingManagerMBeanImplBeanInfo.createParameterDescriptor((String)"options", (String)"contains flags to control recording behavior. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"RecordingException if a recording session is already started or the specified file           cannot be opened for some reason")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Starts a recording session. The generated WLST scripts will be saved to the specified file.</p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RecordingManagerMBean.class.getMethod("stopRecording", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"RecordingException If there is no active recording session")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Stops a recording session. </p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = RecordingManagerMBean.class.getMethod("record", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RecordingManagerMBeanImplBeanInfo.createParameterDescriptor((String)"str", null)};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"RecordingException if there is no active recording session")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Writes a string to the script file.</p> <p>If you invoke this method while a recording session is in progress, the method writes the string immediately after the WLST command that it has most recently recorded.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

