/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.IOException;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class JMXAuthenticator
implements javax.management.remote.JMXAuthenticator {
    private PrincipalAuthenticator authenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    protected JMXAuthenticator() {
    }

    public Subject authenticate(Object object) {
        try {
            if (object == null) {
                Subject subject;
                JMXContext jMXContext;
                AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
                if (System.getSecurityManager() != null && SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject) && (jMXContext = JMXContextHelper.getJMXContext(false)) != null && (subject = jMXContext.getSubject()) != null && SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)SecurityServiceManager.getASFromWire((AuthenticatedSubject)AuthenticatedSubject.getFromSubject((Subject)subject)))) {
                    return authenticatedSubject.getSubject();
                }
                return AuthenticatedSubject.ANON.getSubject();
            }
            if (!(object instanceof String[])) {
                throw new SecurityException("Invalid JMX credential type passed to JMX connector: " + object.getClass().getName());
            }
            String[] stringArray = (String[])object;
            if (stringArray.length < 2 || stringArray[0] == null || stringArray[1] == null) {
                throw new SecurityException("Invalid JMX credential, empty username and/or password");
            }
            AuthenticatedSubject authenticatedSubject = this.authenticator.authenticate((CallbackHandler)new JMXCallbackHandler((String[])object));
            AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
            if (authenticatedSubject2.equals((Object)authenticatedSubject) && authenticatedSubject2.getQOS() == authenticatedSubject.getQOS()) {
                return authenticatedSubject2.getSubject();
            }
            return authenticatedSubject.getSubject();
        }
        catch (LoginException loginException) {
            throw new SecurityException(loginException);
        }
    }

    private class JMXCallbackHandler
    implements CallbackHandler {
        String userName;
        String password;

        protected JMXCallbackHandler(String[] stringArray) {
            this.userName = stringArray[0];
            this.password = stringArray[1];
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback = callbackArray[i];
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.userName);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
            }
        }
    }
}

