/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.ObjectInputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConnectorSubjectForwarder
implements MBeanServerForwarder {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private MBeanServer delegate;

    @Override
    public MBeanServer getMBeanServer() {
        return this.delegate;
    }

    @Override
    public void setMBeanServer(MBeanServer mBeanServer) {
        this.delegate = mBeanServer;
    }

    @Override
    public ObjectInstance createMBean(final String string, final ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance = null;
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            objectInstance = (ObjectInstance)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final String string2 = string;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                            @Override
                            public ObjectInstance run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().createMBean(string2, objectName2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof MBeanRegistrationException) {
                            throw (MBeanRegistrationException)exception;
                        }
                        if (exception instanceof InstanceAlreadyExistsException) {
                            throw (InstanceAlreadyExistsException)exception;
                        }
                        if (exception instanceof NotCompliantMBeanException) {
                            throw (NotCompliantMBeanException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowCreateException(objectName, privilegedActionException);
        }
        return objectInstance;
    }

    public void rethrowCreateException(ObjectName objectName, PrivilegedActionException privilegedActionException) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof NoAccessRuntimeException) {
            throw (NoAccessRuntimeException)((Object)exception);
        }
        if (exception instanceof ReflectionException) {
            throw (ReflectionException)exception;
        }
        if (exception instanceof InstanceAlreadyExistsException) {
            throw (InstanceAlreadyExistsException)exception;
        }
        if (exception instanceof MBeanRegistrationException) {
            throw (MBeanRegistrationException)exception;
        }
        if (exception instanceof MBeanException) {
            throw (MBeanException)exception;
        }
        if (exception instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new AssertionError((Object)exception);
    }

    @Override
    public ObjectInstance createMBean(final String string, final ObjectName objectName, final ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance = null;
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            objectInstance = (ObjectInstance)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName3 = objectName;
                        final String string2 = string;
                        final ObjectName objectName22 = objectName2;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                            @Override
                            public ObjectInstance run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().createMBean(string2, objectName3, objectName22);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof MBeanRegistrationException) {
                            throw (MBeanRegistrationException)exception;
                        }
                        if (exception instanceof NotCompliantMBeanException) {
                            throw (NotCompliantMBeanException)exception;
                        }
                        if (exception instanceof InstanceAlreadyExistsException) {
                            throw (InstanceAlreadyExistsException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            this.rethrowCreateException(objectName, privilegedActionException);
        }
        return objectInstance;
    }

    @Override
    public ObjectInstance createMBean(final String string, final ObjectName objectName, final Object[] objectArray, final String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance = null;
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            objectInstance = (ObjectInstance)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final String string2 = string;
                        final Object[] objectArray2 = objectArray;
                        final String[] stringArray2 = stringArray;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                            @Override
                            public ObjectInstance run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().createMBean(string2, objectName2, objectArray2, stringArray2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceAlreadyExistsException) {
                            throw (InstanceAlreadyExistsException)exception;
                        }
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof NotCompliantMBeanException) {
                            throw (NotCompliantMBeanException)exception;
                        }
                        if (exception instanceof MBeanRegistrationException) {
                            throw (MBeanRegistrationException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowCreateException(objectName, privilegedActionException);
        }
        return objectInstance;
    }

    @Override
    public ObjectInstance createMBean(final String string, final ObjectName objectName, final ObjectName objectName2, final Object[] objectArray, final String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance = null;
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            objectInstance = (ObjectInstance)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName3 = objectName;
                        final String string2 = string;
                        final ObjectName objectName22 = objectName2;
                        final Object[] objectArray2 = objectArray;
                        final String[] stringArray2 = stringArray;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                            @Override
                            public ObjectInstance run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().createMBean(string2, objectName3, objectName22, objectArray2, stringArray2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof MBeanRegistrationException) {
                            throw (MBeanRegistrationException)exception;
                        }
                        if (exception instanceof NotCompliantMBeanException) {
                            throw (NotCompliantMBeanException)exception;
                        }
                        if (exception instanceof InstanceAlreadyExistsException) {
                            throw (InstanceAlreadyExistsException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            this.rethrowCreateException(objectName, privilegedActionException);
        }
        return objectInstance;
    }

    @Override
    public Object getAttribute(final ObjectName objectName, final String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Object object = null;
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            object = authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final String string2 = string;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().getAttribute(objectName2, string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof AttributeNotFoundException) {
                            throw (AttributeNotFoundException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
        return object;
    }

    @Override
    public AttributeList getAttributes(final ObjectName objectName, final String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList = null;
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            attributeList = (AttributeList)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final String[] stringArray2 = stringArray;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<AttributeList>(){

                            @Override
                            public AttributeList run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().getAttributes(objectName2, stringArray2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
        return attributeList;
    }

    @Override
    public void unregisterMBean(final ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().unregisterMBean(objectName2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof MBeanRegistrationException) {
                            throw (MBeanRegistrationException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowUnregisterException(privilegedActionException);
        }
    }

    public void rethrowUnregisterException(PrivilegedActionException privilegedActionException) throws InstanceNotFoundException, MBeanRegistrationException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)exception;
        }
        if (exception instanceof NoAccessRuntimeException) {
            throw (NoAccessRuntimeException)((Object)exception);
        }
        if (exception instanceof MBeanRegistrationException) {
            throw (MBeanRegistrationException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new AssertionError((Object)exception);
    }

    @Override
    public ObjectInstance registerMBean(final Object object, final ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance objectInstance = null;
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            objectInstance = (ObjectInstance)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final Object object2 = object;
                        final ObjectName objectName2 = objectName;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                            @Override
                            public ObjectInstance run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().registerMBean(object2, objectName2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceAlreadyExistsException) {
                            throw (InstanceAlreadyExistsException)exception;
                        }
                        if (exception instanceof MBeanRegistrationException) {
                            throw (MBeanRegistrationException)exception;
                        }
                        if (exception instanceof NotCompliantMBeanException) {
                            throw (NotCompliantMBeanException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowRegisterException(privilegedActionException);
        }
        return objectInstance;
    }

    public void rethrowRegisterException(PrivilegedActionException privilegedActionException) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof InstanceAlreadyExistsException) {
            throw (InstanceAlreadyExistsException)exception;
        }
        if (exception instanceof NoAccessRuntimeException) {
            throw (NoAccessRuntimeException)((Object)exception);
        }
        if (exception instanceof MBeanRegistrationException) {
            throw (MBeanRegistrationException)exception;
        }
        if (exception instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new AssertionError((Object)exception);
    }

    @Override
    public void setAttribute(final ObjectName objectName, final Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final Attribute attribute2 = attribute;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().setAttribute(objectName2, attribute2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof InvalidAttributeValueException) {
                            throw (InvalidAttributeValueException)exception;
                        }
                        if (exception instanceof AttributeNotFoundException) {
                            throw (AttributeNotFoundException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public AttributeList setAttributes(final ObjectName objectName, final AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList2 = null;
        try {
            AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
            attributeList2 = (AttributeList)authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final AttributeList attributeList2 = attributeList;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<AttributeList>(){

                            @Override
                            public AttributeList run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().setAttributes(objectName2, attributeList2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
        return attributeList2;
    }

    @Override
    public Object invoke(final ObjectName objectName, final String string, final Object[] objectArray, final String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object = null;
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            object = authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final String string2 = string;
                        final Object[] objectArray2 = objectArray;
                        final String[] stringArray2 = stringArray;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                return JMXConnectorSubjectForwarder.this.getMBeanServer().invoke(objectName2, string2, objectArray2, stringArray2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof MBeanException) {
                            throw (MBeanException)exception;
                        }
                        if (exception instanceof ReflectionException) {
                            throw (ReflectionException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
        return object;
    }

    @Override
    public void addNotificationListener(final ObjectName objectName, final NotificationListener notificationListener, final NotificationFilter notificationFilter, final Object object) throws InstanceNotFoundException {
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        if (authenticatedSubject == null) {
            this.getMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, object);
            return;
        }
        try {
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final NotificationListener notificationListener2 = notificationListener;
                        final NotificationFilter notificationFilter2 = notificationFilter;
                        final Object object2 = object;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().addNotificationListener(objectName2, notificationListener2, notificationFilter2, object2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowAddNotificationListenerException(objectName, privilegedActionException);
        }
    }

    public void rethrowAddNotificationListenerException(ObjectName objectName, PrivilegedActionException privilegedActionException) throws InstanceNotFoundException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof NoAccessRuntimeException) {
            throw (NoAccessRuntimeException)((Object)exception);
        }
        if (exception instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new AssertionError((Object)exception);
    }

    @Override
    public void addNotificationListener(final ObjectName objectName, final ObjectName objectName2, final NotificationFilter notificationFilter, final Object object) throws InstanceNotFoundException {
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName3 = objectName;
                        final ObjectName objectName22 = objectName2;
                        final NotificationFilter notificationFilter2 = notificationFilter;
                        final Object object2 = object;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().addNotificationListener(objectName3, objectName22, notificationFilter2, object2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowAddNotificationListenerException(objectName, privilegedActionException);
        }
    }

    @Override
    public void removeNotificationListener(final ObjectName objectName, final ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName3 = objectName;
                        final ObjectName objectName22 = objectName2;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().removeNotificationListener(objectName3, objectName22);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof ListenerNotFoundException) {
                            throw (ListenerNotFoundException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowRemoveNotificationListenerException(objectName, privilegedActionException);
        }
    }

    public void rethrowRemoveNotificationListenerException(ObjectName objectName, PrivilegedActionException privilegedActionException) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof NoAccessRuntimeException) {
            throw (NoAccessRuntimeException)((Object)exception);
        }
        if (exception instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)exception;
        }
        if (exception instanceof ListenerNotFoundException) {
            throw (ListenerNotFoundException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new AssertionError((Object)exception);
    }

    @Override
    public void removeNotificationListener(final ObjectName objectName, final ObjectName objectName2, final NotificationFilter notificationFilter, final Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        try {
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName3 = objectName;
                        final ObjectName objectName22 = objectName2;
                        final NotificationFilter notificationFilter2 = notificationFilter;
                        final Object object2 = object;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().removeNotificationListener(objectName3, objectName22, notificationFilter2, object2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof ListenerNotFoundException) {
                            throw (ListenerNotFoundException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowRemoveNotificationListenerException(objectName, privilegedActionException);
        }
    }

    @Override
    public void removeNotificationListener(final ObjectName objectName, final NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        if (authenticatedSubject == null) {
            this.getMBeanServer().removeNotificationListener(objectName, notificationListener);
            return;
        }
        try {
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final NotificationListener notificationListener2 = notificationListener;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().removeNotificationListener(objectName2, notificationListener2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof ListenerNotFoundException) {
                            throw (ListenerNotFoundException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowRemoveNotificationListenerException(objectName, privilegedActionException);
        }
    }

    @Override
    public void removeNotificationListener(final ObjectName objectName, final NotificationListener notificationListener, final NotificationFilter notificationFilter, final Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        AuthenticatedSubject authenticatedSubject = this.getAuthenticatedSubject();
        if (authenticatedSubject == null) {
            this.getMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, object);
            return;
        }
        try {
            authenticatedSubject.doAs((AbstractSubject)KERNEL_ID, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        final ObjectName objectName2 = objectName;
                        final NotificationListener notificationListener2 = notificationListener;
                        final NotificationFilter notificationFilter2 = notificationFilter;
                        final Object object2 = object;
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JMXConnectorSubjectForwarder.this.getMBeanServer().removeNotificationListener(objectName2, notificationListener2, notificationFilter2, object2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)exception;
                        }
                        if (exception instanceof ListenerNotFoundException) {
                            throw (ListenerNotFoundException)exception;
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.rethrowRemoveNotificationListenerException(objectName, privilegedActionException);
        }
    }

    @Override
    public final ClassLoaderRepository getClassLoaderRepository() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoaderRepository>(){

                @Override
                public ClassLoaderRepository run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getClassLoaderRepository();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        try {
            final ObjectName objectName2 = objectName;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getClassLoaderFor(objectName2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        try {
            final ObjectName objectName2 = objectName;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getClassLoader(objectName2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    @Deprecated
    public final ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws OperationsException {
        try {
            final ObjectName objectName2 = objectName;
            final byte[] byArray2 = byArray;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInputStream>(){

                @Override
                public ObjectInputStream run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().deserialize(objectName2, byArray2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof OperationsException) {
                throw (OperationsException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    @Deprecated
    public final ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        try {
            final String string2 = string;
            final byte[] byArray2 = byArray;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInputStream>(){

                @Override
                public ObjectInputStream run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().deserialize(string2, byArray2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof OperationsException) {
                throw (OperationsException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    @Deprecated
    public final ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws OperationsException, ReflectionException {
        try {
            final String string2 = string;
            final ObjectName objectName2 = objectName;
            final byte[] byArray2 = byArray;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInputStream>(){

                @Override
                public ObjectInputStream run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().deserialize(string2, objectName2, byArray2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof OperationsException) {
                throw (OperationsException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        try {
            final String string2 = string;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().instantiate(string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            final String string2 = string;
            final ObjectName objectName2 = objectName;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().instantiate(string2, objectName2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        try {
            final String string2 = string;
            final Object[] objectArray2 = objectArray;
            final String[] stringArray2 = stringArray;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().instantiate(string2, objectArray2, stringArray2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            final String string2 = string;
            final ObjectName objectName2 = objectName;
            final Object[] objectArray2 = objectArray;
            final String[] stringArray2 = stringArray;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().instantiate(string2, objectName2, objectArray2, stringArray2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        try {
            final ObjectName objectName2 = objectName;
            final String string2 = string;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return new Boolean(JMXConnectorSubjectForwarder.this.getMBeanServer().isInstanceOf(objectName2, string2));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            final ObjectName objectName2 = objectName;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<MBeanInfo>(){

                @Override
                public MBeanInfo run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getMBeanInfo(objectName2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IntrospectionException) {
                throw (IntrospectionException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public String[] getDomains() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                @Override
                public String[] run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getDomains();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public String getDefaultDomain() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getDefaultDomain();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Integer getMBeanCount() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getMBeanCount();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        try {
            final ObjectName objectName2 = objectName;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return new Boolean(JMXConnectorSubjectForwarder.this.getMBeanServer().isRegistered(objectName2));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        try {
            final ObjectName objectName2 = objectName;
            final QueryExp queryExp2 = queryExp;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Set<ObjectName>>(){

                @Override
                public Set<ObjectName> run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().queryNames(objectName2, queryExp2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        try {
            final ObjectName objectName2 = objectName;
            final QueryExp queryExp2 = queryExp;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Set<ObjectInstance>>(){

                @Override
                public Set<ObjectInstance> run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().queryMBeans(objectName2, queryExp2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        try {
            final ObjectName objectName2 = objectName;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                @Override
                public ObjectInstance run() throws Exception {
                    return JMXConnectorSubjectForwarder.this.getMBeanServer().getObjectInstance(objectName2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    private AuthenticatedSubject getAuthenticatedSubject() {
        final AccessControlContext accessControlContext = AccessController.getContext();
        if (accessControlContext != null) {
            Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    return Subject.getSubject(accessControlContext);
                }
            });
            if (subject != null) {
                AuthenticatedSubject authenticatedSubject = AuthenticatedSubject.getFromSubject((Subject)subject);
                if (!AuthenticatedSubject.ANON.equals((Object)authenticatedSubject) && !KERNEL_ID.equals((Object)authenticatedSubject)) {
                    return authenticatedSubject;
                }
                AuthenticatedSubject authenticatedSubject2 = JMXConnectorSubjectForwarder.getAuthenticatedSubjectFromJMXContext();
                if (authenticatedSubject2 != null && !AuthenticatedSubject.ANON.equals((Object)authenticatedSubject2)) {
                    return authenticatedSubject2;
                }
                AuthenticatedSubject authenticatedSubject3 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
                return authenticatedSubject3;
            }
            return AuthenticatedSubject.ANON;
        }
        return AuthenticatedSubject.ANON;
    }

    private static AuthenticatedSubject getAuthenticatedSubjectFromJMXContext() {
        Subject subject;
        JMXContext jMXContext = JMXContextHelper.getJMXContext(false);
        if (jMXContext != null && (subject = jMXContext.getSubject()) != null) {
            return AuthenticatedSubject.getFromSubject((Subject)subject);
        }
        return null;
    }
}

