/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import javax.management.ObjectName;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;

public class JMXContextHandler
implements ContextHandler {
    private static final String[] common_keys = new String[]{"com.bea.contextelement.jmx.ObjectName", "com.bea.contextelement.jmx.ShortName"};
    private static final String[] invoke_keys = new String[]{"com.bea.contextelement.jmx.ObjectName", "com.bea.contextelement.jmx.ShortName", "com.bea.contextelement.jmx.Parameters", "com.bea.contextelement.jmx.Signature", "com.bea.contextelement.jmx.AuditProtectedArgInfo", "com.bea.contextelement.jmx.OldAttributeValue"};
    private final ObjectName objectName;
    private final String[] keys;
    private final Object[] parameters;
    private final String[] signature;
    private final String auditProtectedArgInfo;
    private final Object oldAttributeValue;

    public JMXContextHandler(ObjectName objectName) {
        this.objectName = objectName;
        this.keys = common_keys;
        this.parameters = null;
        this.signature = null;
        this.auditProtectedArgInfo = null;
        this.oldAttributeValue = null;
    }

    public JMXContextHandler(ObjectName objectName, Object[] objectArray, String[] stringArray, String string, Object object) {
        this.objectName = objectName;
        this.parameters = objectArray;
        this.signature = stringArray;
        this.auditProtectedArgInfo = string;
        this.keys = invoke_keys;
        this.oldAttributeValue = object;
    }

    public int size() {
        return this.keys.length;
    }

    public String[] getNames() {
        return this.keys;
    }

    public Object getValue(String string) {
        if ("com.bea.contextelement.jmx.ObjectName".equals(string)) {
            return this.objectName;
        }
        if ("com.bea.contextelement.jmx.ShortName".equals(string) && this.objectName != null) {
            return this.objectName.getKeyProperty("Name");
        }
        if ("com.bea.contextelement.jmx.Parameters".equals(string)) {
            return this.parameters;
        }
        if ("com.bea.contextelement.jmx.Signature".equals(string)) {
            return this.signature;
        }
        if ("com.bea.contextelement.jmx.AuditProtectedArgInfo".equals(string)) {
            return this.auditProtectedArgInfo;
        }
        if ("com.bea.contextelement.jmx.OldAttributeValue".equals(string)) {
            return this.oldAttributeValue;
        }
        return null;
    }

    public ContextElement[] getValues(String[] stringArray) {
        ContextElement[] contextElementArray = new ContextElement[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getValue(stringArray[i]);
            if (object == null) continue;
            contextElementArray[n++] = new ContextElement(stringArray[i], object);
        }
        if (n < stringArray.length) {
            ContextElement[] contextElementArray2 = contextElementArray;
            contextElementArray = new ContextElement[n];
            System.arraycopy(contextElementArray2, 0, contextElementArray, 0, n);
        }
        return contextElementArray;
    }
}

