/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.mbeanservers.internal.LocalNotificationHandback;
import weblogic.management.utils.MBeanInfoLocalizationHelper;

public class JMXContextInterceptor
extends WLSMBeanServerInterceptorBase {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugJMXContext");
    private boolean isDomainRuntime;
    private String domainName;
    private final Map<ObjectName, InternalWeakReference> mbeansContextLoaderCache_ = new ConcurrentHashMap<ObjectName, InternalWeakReference>();
    private ReferenceQueue<ClassLoader> referenceQueue_ = new ReferenceQueue();

    public JMXContextInterceptor() {
        this.isDomainRuntime = false;
    }

    public JMXContextInterceptor(String string) {
        this.isDomainRuntime = true;
        this.domainName = string;
    }

    public void setNextMBeanServerConnection(MBeanServerConnection mBeanServerConnection) {
        super.setNextMBeanServerConnection(mBeanServerConnection);
        try {
            mBeanServerConnection.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, new RegistrationUnRegistrationMBeanServerNotificationListener(), (NotificationFilter)new RegistrationUnRegistrationMBeanServerNotificationFilter(), (Object)new LocalNotificationHandback());
        }
        catch (Exception exception) {
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("JMXContextInterceptor.setNextMBeanServerConnection(MBeanServerConnection next). Error registering listener with MBeanServerDelegate: " + exception.getMessage());
            }
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = null;
        if (this.isLocalizable(objectName) && (classLoader = this.getMBeanContextLoader(objectName)) != null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            Object object = super.getAttribute(objectName, string);
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = null;
        if (this.isLocalizable(objectName) && (classLoader = this.getMBeanContextLoader(objectName)) != null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            AttributeList attributeList = super.getAttributes(objectName, stringArray);
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            return attributeList;
        }
        catch (Throwable throwable) {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = null;
        if (this.isLocalizable(objectName) && (classLoader = this.getMBeanContextLoader(objectName)) != null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            super.setAttribute(objectName, attribute);
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
        catch (Throwable throwable) {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = null;
        if (this.isLocalizable(objectName) && (classLoader = this.getMBeanContextLoader(objectName)) != null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            Object object = super.invoke(objectName, string, objectArray, stringArray);
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = null;
        if (this.isLocalizable(objectName) && (classLoader = this.getMBeanContextLoader(objectName)) != null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            AttributeList attributeList2 = super.setAttributes(objectName, attributeList);
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            return attributeList2;
        }
        catch (Throwable throwable) {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        if (!this.isLocalizable(objectName)) {
            return super.getMBeanInfo(objectName);
        }
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = this.getMBeanContextLoader(objectName);
        if (classLoader2 != null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        try {
            MBeanInfo mBeanInfo = super.getMBeanInfo(objectName);
            Locale locale = this.getLocale();
            if (locale == null) {
                MBeanInfo mBeanInfo2 = mBeanInfo;
                return mBeanInfo2;
            }
            MBeanInfo mBeanInfo3 = MBeanInfoLocalizationHelper.localizeMBeanInfo(mBeanInfo, locale);
            return mBeanInfo3;
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    private boolean isLocalizable(ObjectName objectName) {
        return objectName == null || !"com.bea".equals(objectName.getDomain()) && !"Security".equals(objectName.getDomain()) && !this.isDelegate(objectName);
    }

    private boolean isDelegate(ObjectName objectName) {
        String string;
        return this.isDomainRuntime && objectName != null && (string = objectName.getKeyProperty("Location")) != null && string.length() > 0 && !string.equals(this.domainName);
    }

    private Locale getLocale() {
        Locale locale;
        block2: {
            locale = null;
            try {
                locale = JMXContextInterceptor.getThreadLocale();
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!DEBUG_LOGGER.isDebugEnabled()) break block2;
                DEBUG_LOGGER.debug("JMXContextInterceptor.getLocale(): Privileged action violation: " + privilegedActionException.getMessage());
            }
        }
        return locale;
    }

    public static Locale getThreadLocale() throws PrivilegedActionException {
        JMXContext jMXContext = JMXContextHelper.getJMXContext(false);
        if (jMXContext != null) {
            return jMXContext.getLocale();
        }
        return null;
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance objectInstance = super.registerMBean(object, objectName);
        this.cleanupCache();
        return objectInstance;
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        super.unregisterMBean(objectName);
    }

    private ClassLoader getMBeanContextLoader(ObjectName objectName) {
        ClassLoader classLoader = null;
        InternalWeakReference internalWeakReference = this.mbeansContextLoaderCache_.get(objectName);
        if (internalWeakReference != null) {
            classLoader = (ClassLoader)internalWeakReference.get();
            if (classLoader == null) {
                this.mbeansContextLoaderCache_.remove(objectName);
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("JMXContextInterceptor.getMBeanContextLoader(objectName mbeanName): MBean associated ClassLoader was recycled, prior to MBean named: \"" + objectName + "\" was unregistered. This mostly indicates improper unregistration life-cycle.");
                }
            }
        } else if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("JMXContextInterceptor.getMBeanContextLoader(objectName mbeanName): Could not find ClassLoader associated with MBean named: \"" + objectName + "\"");
        }
        return classLoader;
    }

    private synchronized void cleanupCache() {
        InternalWeakReference internalWeakReference = (InternalWeakReference)InternalWeakReference.class.cast(this.referenceQueue_.poll());
        while (internalWeakReference != null) {
            ObjectName objectName = internalWeakReference.getObjectName();
            this.mbeansContextLoaderCache_.remove(objectName);
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("JMXContextInterceptor.cleanupCache: MBean associated ClassLoader was recycled, prior to MBean named: \"" + objectName + "\" was unregistered. This mostly indicates improper MBean unregistration life-cycle.");
            }
            internalWeakReference = (InternalWeakReference)InternalWeakReference.class.cast(this.referenceQueue_.poll());
        }
    }

    private class RegistrationUnRegistrationMBeanServerNotificationListener
    implements NotificationListener {
        private RegistrationUnRegistrationMBeanServerNotificationListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)MBeanServerNotification.class.cast(notification);
            if ("JMX.mbean.registered".equals(mBeanServerNotification.getType())) {
                InternalWeakReference internalWeakReference = new InternalWeakReference(Thread.currentThread().getContextClassLoader(), mBeanServerNotification.getMBeanName());
                JMXContextInterceptor.this.mbeansContextLoaderCache_.put(mBeanServerNotification.getMBeanName(), internalWeakReference);
            }
            if ("JMX.mbean.unregistered".equals(mBeanServerNotification.getType())) {
                JMXContextInterceptor.this.mbeansContextLoaderCache_.remove(mBeanServerNotification.getMBeanName());
            }
        }
    }

    private class RegistrationUnRegistrationMBeanServerNotificationFilter
    implements NotificationFilter {
        private RegistrationUnRegistrationMBeanServerNotificationFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            ObjectName objectName;
            return notification instanceof MBeanServerNotification && ("JMX.mbean.registered".equals(notification.getType()) || "JMX.mbean.unregistered".equals(notification.getType())) && JMXContextInterceptor.this.isLocalizable(objectName = ((MBeanServerNotification)MBeanServerNotification.class.cast(notification)).getMBeanName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalWeakReference
    extends WeakReference<ClassLoader> {
        private ObjectName associatedMBean_;

        InternalWeakReference(ClassLoader classLoader, ObjectName objectName) {
            super(classLoader, JMXContextInterceptor.this.referenceQueue_);
            this.associatedMBean_ = objectName;
        }

        public ObjectName getObjectName() {
            return this.associatedMBean_;
        }
    }
}

