/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.jmx.JMXLogger;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerBuilder;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.jmx.modelmbean.WLSModelMBeanFactory;
import weblogic.management.mbeanservers.MBeanTypeService;
import weblogic.management.mbeanservers.internal.JMXAuthenticator;
import weblogic.management.mbeanservers.internal.JMXConnectorSubjectForwarder;
import weblogic.management.mbeanservers.internal.MBeanTypeServiceImpl;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ServerURL;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class MBeanServerServiceBase
extends AbstractServerService {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXCore");
    protected static final String CURRENT_VERSION = "12.0.0.0";
    private static final String PROTOCOL_IIOP = "iiop";
    private static final String JNDI = "/jndi/";
    private static final ObjectName MBEANTYPESERVICE;
    private static AuthenticatedSubject kernelId;
    private MBeanServer mbeanServer;
    private JMXServiceURL serviceURL;
    private JMXConnectorServer connectorServer = null;

    protected MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    protected synchronized void initialize(String string, MBeanServer mBeanServer) throws ServiceFailureException {
        this.initialize(string, mBeanServer, null);
    }

    protected void registerTypeService(WLSModelMBeanContext wLSModelMBeanContext) throws OperationsException, MBeanRegistrationException {
        MBeanTypeServiceImpl mBeanTypeServiceImpl = new MBeanTypeServiceImpl(wLSModelMBeanContext);
        WLSModelMBeanFactory.registerWLSModelMBean((Object)mBeanTypeServiceImpl, (ObjectName)MBEANTYPESERVICE, (WLSModelMBeanContext)wLSModelMBeanContext);
    }

    protected synchronized void initialize(String string, MBeanServer mBeanServer, MBeanServer mBeanServer2) throws ServiceFailureException {
        String string2;
        Object object;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        this.mbeanServer = mBeanServer;
        if (mBeanServer2 != null && mBeanServer2 instanceof WLSMBeanServer) {
            this.mbeanServer = mBeanServer2;
        } else if (this.mbeanServer == null) {
            object = new WLSMBeanServerBuilder();
            string2 = runtimeAccess.getDomainName();
            this.mbeanServer = object.newMBeanServer(string2, null, null, mBeanServer2);
        }
        try {
            object = URLManager.findAdministrationURL(runtimeAccess.getServerName());
            string2 = new ServerURL((String)object);
            this.serviceURL = new JMXServiceURL(PROTOCOL_IIOP, string2.getHost(), string2.getPort(), JNDI + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)(" Malformed URL" + malformedURLException));
        }
        catch (UnknownHostException unknownHostException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Unable to obtain URL for managed server " + runtimeAccess.getServerName());
            }
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("Registering JMXConnectorServer at " + this.serviceURL);
        }
        try {
            object = new Hashtable();
            ((Hashtable)object).put("weblogic.jndi.replicateBindings", Boolean.FALSE.toString());
            ((Hashtable)object).put("weblogic.jndi.createIntermediateContexts", Boolean.TRUE.toString());
            ((Hashtable)object).put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            ((Hashtable)object).put("jmx.remote.x.server.connection.timeout", new Long(Long.MAX_VALUE));
            ((Hashtable)object).put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            ((Hashtable)object).put("jmx.remote.authenticator", new JMXAuthenticator());
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.serviceURL, object, this.mbeanServer);
            this.connectorServer.setMBeanServerForwarder(new JMXConnectorSubjectForwarder());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)(" Failed to start JMXConnector Server" + iOException));
        }
        if (debug.isDebugEnabled()) {
            debug.debug("JMXConnectorServer registered at " + this.serviceURL);
        }
    }

    private String getServiceURLString() {
        if (this.serviceURL == null) {
            return "<not established>";
        }
        return this.serviceURL.toString();
    }

    public void start() throws ServiceFailureException {
        try {
            this.connectorServer.start();
            JMXLogger.logStartedJMXConnectorServer((String)this.getServiceURLString());
        }
        catch (IOException iOException) {
            throw new ServiceFailureException("Unable to start JMX Connector Server", (Throwable)iOException);
        }
    }

    public void stop() throws ServiceFailureException {
        try {
            if (this.connectorServer == null) {
                return;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("Stopping connectionServer: ConnectionIds: " + this.connectorServer.getConnectionIds());
            }
            this.connectorServer.stop();
            JMXLogger.logStoppedJMXConnectorServer((String)this.getServiceURLString());
        }
        catch (IOException iOException) {
            throw new ServiceFailureException("Unable to stop JMX Connector Server", (Throwable)iOException);
        }
    }

    public void halt() throws ServiceFailureException {
        this.stop();
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            MBEANTYPESERVICE = new ObjectName(MBeanTypeService.OBJECT_NAME);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }
}

