/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.Serializable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.management.jmx.ObjectNameManager;
import weblogic.management.jmx.modelmbean.ModelMBeanInfoWrapper;
import weblogic.management.jmx.modelmbean.ModelMBeanInfoWrapperManager;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.mbeanservers.MBeanTypeService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;

public class MBeanTypeServiceImpl
implements MBeanTypeService {
    private WLSModelMBeanContext context;
    private BeanInfoAccess access;

    public MBeanTypeServiceImpl(WLSModelMBeanContext wLSModelMBeanContext) {
        this.context = wLSModelMBeanContext;
        this.access = ManagementService.getBeanInfoAccess();
    }

    public ModelMBeanInfo getMBeanInfo(String string) throws OperationsException {
        ModelMBeanInfoWrapper modelMBeanInfoWrapper = ModelMBeanInfoWrapperManager.getModelMBeanInfoForInterface((String)string, (boolean)this.context.isReadOnly(), (String)this.context.getVersion(), (ObjectNameManager)this.context.getNameManager());
        return modelMBeanInfoWrapper.getModelMBeanInfo();
    }

    public String[] getSubtypes(String string) {
        return this.access.getSubtypes(string);
    }

    public void validateAttribute(String string, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ModelMBeanInfoWrapper modelMBeanInfoWrapper;
        try {
            modelMBeanInfoWrapper = ModelMBeanInfoWrapperManager.getModelMBeanInfoForInterface((String)string, (boolean)this.context.isReadOnly(), (String)this.context.getVersion(), (ObjectNameManager)this.context.getNameManager());
        }
        catch (OperationsException operationsException) {
            throw new MBeanException(operationsException);
        }
        MBeanTypeServiceImpl.validateOneAttribute(attribute, modelMBeanInfoWrapper);
    }

    public AttributeList validateAttributes(String string, AttributeList attributeList) throws MBeanException, ReflectionException {
        ModelMBeanInfoWrapper modelMBeanInfoWrapper;
        try {
            modelMBeanInfoWrapper = ModelMBeanInfoWrapperManager.getModelMBeanInfoForInterface((String)string, (boolean)this.context.isReadOnly(), (String)this.context.getVersion(), (ObjectNameManager)this.context.getNameManager());
        }
        catch (OperationsException operationsException) {
            throw new MBeanException(operationsException);
        }
        AttributeList attributeList2 = MBeanTypeServiceImpl.validateMultipleAttributes(attributeList, modelMBeanInfoWrapper);
        return attributeList2;
    }

    public void validateAttribute(ObjectName objectName, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ModelMBeanInfoWrapper modelMBeanInfoWrapper = this.getWrapperForObjectName(objectName);
        MBeanTypeServiceImpl.validateOneAttribute(attribute, modelMBeanInfoWrapper);
    }

    public AttributeList validateAttributes(ObjectName objectName, AttributeList attributeList) throws MBeanException, ReflectionException {
        ModelMBeanInfoWrapper modelMBeanInfoWrapper = this.getWrapperForObjectName(objectName);
        return MBeanTypeServiceImpl.validateMultipleAttributes(attributeList, modelMBeanInfoWrapper);
    }

    private static void validateOneAttribute(Attribute attribute, ModelMBeanInfoWrapper modelMBeanInfoWrapper) throws AttributeNotFoundException, MBeanException, InvalidAttributeValueException, ReflectionException {
        Object object;
        Serializable serializable;
        String string = attribute.getName();
        Object object2 = attribute.getValue();
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = modelMBeanInfoWrapper.getModelMBeanInfo().getAttribute(string);
        if (modelMBeanAttributeInfo == null) {
            throw new AttributeNotFoundException(string + " for " + modelMBeanInfoWrapper.getModelMBeanInfo().getClassName());
        }
        try {
            if (object2 != null) {
                serializable = Class.forName(modelMBeanAttributeInfo.getType());
                if (!object2.getClass().isAssignableFrom((Class<?>)serializable)) {
                    throw new InvalidAttributeValueException(object2.getClass() + "is not assignable from " + serializable);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        serializable = modelMBeanAttributeInfo.getDescriptor();
        Boolean bl = (Boolean)serializable.getFieldValue("isNullable");
        if (bl != null && bl.booleanValue()) {
            if (object2 == null) {
                return;
            }
            if (object2 == null) {
                throw new InvalidAttributeValueException("Null value is not allowed for " + string);
            }
        }
        if ((object = serializable.getFieldValue("minValue")) != null && (object2 == null || MBeanTypeServiceImpl.compareTo(object2, object) < 0)) {
            throw new InvalidAttributeValueException("Value " + object2 + " is less than " + object + " for " + string);
        }
        Object object3 = serializable.getFieldValue("maxValue");
        if (object3 != null && (object2 == null || MBeanTypeServiceImpl.compareTo(object2, object3) > 0)) {
            throw new InvalidAttributeValueException("Value " + object2 + " is greater than " + object3 + " for " + string);
        }
        Object[] objectArray = (Object[])serializable.getFieldValue("legalValues");
        if (objectArray != null) {
            boolean bl2 = true;
            int n = 0;
            while (bl2 && n < objectArray.length) {
                Object object4 = objectArray[n++];
                bl2 = object4.equals(object2);
            }
            if (bl2) {
                throw new InvalidAttributeValueException("Value " + object2 + " is not in " + objectArray + " for " + string);
            }
        }
    }

    private static AttributeList validateMultipleAttributes(AttributeList attributeList, ModelMBeanInfoWrapper modelMBeanInfoWrapper) throws MBeanException, ReflectionException {
        AttributeList attributeList2 = new AttributeList();
        for (Attribute attribute : attributeList) {
            try {
                MBeanTypeServiceImpl.validateOneAttribute(attribute, modelMBeanInfoWrapper);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                attributeList2.add(new Attribute(attribute.getName(), invalidAttributeValueException));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                attributeList2.add(new Attribute(attribute.getName(), attributeNotFoundException));
            }
        }
        return attributeList2;
    }

    private ModelMBeanInfoWrapper getWrapperForObjectName(ObjectName objectName) throws MBeanException {
        ModelMBeanInfoWrapper modelMBeanInfoWrapper;
        try {
            Object object = this.context.getNameManager().lookupObject(objectName);
            modelMBeanInfoWrapper = ModelMBeanInfoWrapperManager.getModelMBeanInfoForInstance((Object)object, (boolean)this.context.isReadOnly(), (String)this.context.getVersion(), (ObjectNameManager)this.context.getNameManager());
        }
        catch (OperationsException operationsException) {
            throw new MBeanException(operationsException);
        }
        return modelMBeanInfoWrapper;
    }

    private static int compareTo(Object object, Object object2) {
        if (object2 instanceof Comparable) {
            return ((Comparable)object).compareTo((Comparable)object2);
        }
        throw new AssertionError((Object)"Attribute with legalMin or legalMax is not comparable");
    }
}

