/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.mbeanservers.edit.RecordingException;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.utils.StringUtils;

public class RecordingManager {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXEdit");
    private String recordingFileName;
    private String configFileName;
    private String secretFileName;
    private boolean recording = false;
    private String lastCD = "";
    private String lastCommand = "";
    private boolean verbose = false;

    RecordingManager() {
    }

    public static RecordingManager getInstance() {
        return Maker.SINGLETON;
    }

    public synchronized void startRecording(String string, boolean bl) throws RecordingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("append", bl ? "true" : "false");
        this.startRecording(string, hashMap);
    }

    public synchronized void startRecording(String string, Map map) throws RecordingException {
        if (this.isRecording()) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getRecordingAlreadyStarted());
        }
        if (StringUtils.isEmptyString((String)string)) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getMissingRecordingFileName());
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Starting WLST script recording session. The generated scripts will be written to " + string);
        }
        boolean bl = false;
        if ("true".equals((String)map.get("append"))) {
            bl = true;
        }
        this.verbose = false;
        if ("true".equals((String)map.get("verbose"))) {
            this.verbose = true;
        }
        BufferedWriter bufferedWriter = null;
        File file = new File(string);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, bl));
            if (this.verbose) {
                boolean bl2 = true;
                if (file.length() > 0L) {
                    bl2 = false;
                }
                bufferedWriter.write("\n# WLST scripts recording begin time: " + new Date().toString() + "\n\n");
                if (bl2) {
                    bufferedWriter.write("connect()\nedit()\n");
                }
                bufferedWriter.flush();
            }
        }
        catch (IOException iOException) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getRecordingIOException(), iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        this.recordingFileName = string;
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        String string2 = file2.getAbsolutePath();
        string2 = StringUtils.replaceGlobal((String)string2, (String)File.separator, (String)"/");
        String string3 = file.getName();
        int n = string3.lastIndexOf(".");
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        this.configFileName = string2 + "/" + string3 + "Config";
        this.secretFileName = string2 + "/" + string3 + "Secret";
        if (!bl) {
            File file3;
            File file4 = new File(this.configFileName);
            if (file4.exists()) {
                file4.delete();
            }
            if ((file3 = new File(this.secretFileName)).exists()) {
                file3.delete();
            }
        }
        this.recording = true;
    }

    public synchronized void stopRecording() throws RecordingException {
        if (!this.isRecording()) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getRecordingAlreadyStopped());
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Stopping WLST script recording session.");
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.recordingFileName), true));
            if (this.verbose) {
                bufferedWriter.write("\n# WLST scripts recording end time: " + new Date().toString() + "\n\n");
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getRecordingIOException(), iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        this.recording = false;
    }

    public synchronized void record(String string) throws RecordingException {
        if (!this.isRecording()) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getRecordFailedDueToRecordingNotStarted(string));
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Caller adds string '" + string + "' to recording file.");
        }
        try {
            this.write(string, false, false);
        }
        catch (IOException iOException) {
            throw new RecordingException(ManagementTextTextFormatter.getInstance().getRecordingIOException(), iOException);
        }
    }

    public synchronized void encrypt(String string, String string2, String string3) throws IOException {
        System.setProperty("weblogic.management.confirmKeyfileCreation", "true");
        UserConfigFileManager.setUsernameAndPassword(new UsernameAndPassword("", string3.toCharArray()), this.configFileName, this.secretFileName, string2);
        String string4 = "'" + string + "', '" + string2 + "', '" + this.configFileName + "', '" + this.secretFileName + "'";
        this.write("setEncrypted(" + string4 + ")");
    }

    public synchronized boolean isRecording() {
        return this.recording;
    }

    public synchronized String getRecordingFileName() {
        return this.recordingFileName;
    }

    public synchronized boolean isVerbose() {
        return this.verbose;
    }

    public synchronized void write(String string) throws IOException {
        this.write(string, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(String string, boolean bl, boolean bl2) throws IOException {
        if (!this.isRecording()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Can not write to recording file since caller has not started a recording session.");
            }
            throw new NoAccessRuntimeException("Operation can not be performed as caller has not started a recording session");
        }
        if (StringUtils.isEmptyString((String)string)) {
            return;
        }
        if (bl2) {
            if (string.equals(this.lastCommand)) {
                return;
            }
            if (string.equals(this.lastCD)) {
                return;
            }
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.recordingFileName), true));
            if (bl) {
                bufferedWriter.write("\n");
            }
            bufferedWriter.write(string);
            this.lastCommand = string;
            if (string.startsWith("cd(")) {
                this.lastCD = string;
            }
            bufferedWriter.write("\n");
            bufferedWriter.flush();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class Maker {
        private static RecordingManager SINGLETON = new RecordingManager();

        private Maker() {
        }
    }
}

