/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.jmx.JMXLogger;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.jmx.modelmbean.WLSModelMBeanFactory;
import weblogic.management.provider.RegistrationHandler;
import weblogic.management.provider.RegistrationManager;
import weblogic.management.provider.Service;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class RuntimeMBeanAgent {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    final WLSModelMBeanContext context;
    final RegistrationManager access;

    public RuntimeMBeanAgent(WLSModelMBeanContext wLSModelMBeanContext, RegistrationManager registrationManager) {
        this.context = wLSModelMBeanContext;
        this.access = registrationManager;
        registrationManager.initiateRegistrationHandler(this.createRegistrationHandler());
    }

    private RegistrationHandler createRegistrationHandler() {
        return new RegistrationHandler(){

            public void registeredCustom(ObjectName objectName, Object object) {
                try {
                    if (RuntimeMBeanAgent.this.context.getNameManager().isClassMapped(object.getClass())) {
                        RuntimeMBeanAgent.this.context.getNameManager().registerObject(objectName, object);
                        WLSModelMBeanFactory.registerWLSModelMBean((Object)object, (ObjectName)objectName, (WLSModelMBeanContext)RuntimeMBeanAgent.this.context);
                    } else {
                        WLSMBeanServer wLSMBeanServer = (WLSMBeanServer)RuntimeMBeanAgent.this.context.getMBeanServer();
                        wLSMBeanServer.getMBeanServer().registerMBean(object, objectName);
                    }
                }
                catch (OperationsException operationsException) {
                    JMXLogger.logRegistrationFailed((ObjectName)objectName, (Throwable)operationsException);
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    JMXLogger.logRegistrationFailed((ObjectName)objectName, (Throwable)mBeanRegistrationException);
                }
            }

            public void unregisteredCustom(final ObjectName objectName) {
                SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        Object object = RuntimeMBeanAgent.this.context.getNameManager().lookupObject(objectName);
                        if (object != null) {
                            RuntimeMBeanAgent.this.context.unregister(object);
                        } else {
                            try {
                                WLSMBeanServer wLSMBeanServer = (WLSMBeanServer)RuntimeMBeanAgent.this.context.getMBeanServer();
                                wLSMBeanServer.getMBeanServer().unregisterMBean(objectName);
                            }
                            catch (InstanceNotFoundException instanceNotFoundException) {
                                JMXLogger.logUnregisterFailed((ObjectName)objectName, (Throwable)instanceNotFoundException);
                            }
                            catch (MBeanRegistrationException mBeanRegistrationException) {
                                JMXLogger.logUnregisterFailed((ObjectName)objectName, (Throwable)mBeanRegistrationException);
                            }
                        }
                        return null;
                    }
                });
            }

            public void registered(RuntimeMBean runtimeMBean, DescriptorBean descriptorBean) {
                WLSModelMBeanFactory.registerWLSModelMBean((Object)runtimeMBean, (WLSModelMBeanContext)RuntimeMBeanAgent.this.context);
            }

            public void unregistered(RuntimeMBean runtimeMBean) {
                this.unregisteredInternal(runtimeMBean);
            }

            public void registered(Service service2) {
                WLSModelMBeanFactory.registerWLSModelMBean((Object)service2, (WLSModelMBeanContext)RuntimeMBeanAgent.this.context);
            }

            public void unregistered(Service service2) {
                this.unregisteredInternal(service2);
            }

            private void unregisteredInternal(Object object) {
                if (!RuntimeMBeanAgent.this.context.getNameManager().isClassMapped(object.getClass())) {
                    return;
                }
                ObjectName objectName = RuntimeMBeanAgent.this.context.getNameManager().unregisterObjectInstance(object);
                if (objectName == null) {
                    JMXLogger.logBeanUnregisterFailed((String)object.toString());
                    return;
                }
                try {
                    MBeanServer mBeanServer = RuntimeMBeanAgent.this.context.getMBeanServer();
                    if (mBeanServer instanceof WLSMBeanServer) {
                        ((WLSMBeanServer)mBeanServer).internalUnregisterMBean(objectName);
                    } else {
                        mBeanServer.unregisterMBean(objectName);
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    JMXLogger.logUnregisterFailed((ObjectName)objectName, (Throwable)mBeanRegistrationException);
                }
            }
        };
    }
}

