/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.common.internal.VersionInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commo.StandardInterface;
import weblogic.management.internal.ConfigurationAuditor;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.jmx.JMXLogger;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.jmx.modelmbean.WLSModelMBean;
import weblogic.management.mbeanservers.internal.JMXContextHandler;
import weblogic.management.mbeanservers.internal.WLSObjectNameManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.audit.AuditorMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.ConsumptionException;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.JMXPolicyConsumer;
import weblogic.security.service.JMXPolicyHandler;
import weblogic.security.service.JMXResource;
import weblogic.security.service.MBeanResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;

public class SecurityInterceptor
extends WLSMBeanServerInterceptorBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXCore");
    WLSMBeanServer wlsMBeanServer;
    private boolean useSecurityFramework;
    private boolean auditorsConfigured;
    private AuthorizationManager authorizer;
    private JMXPolicyConsumer policyConsumer;
    static boolean registeredPolicies;
    private static Map securityInterceptors;
    private static final String[] APP_SCOPED_TYPES;
    private static AuthenticatedSubject kernelId;
    private static String BEA_DOMAIN;

    public SecurityInterceptor(WLSMBeanServer wLSMBeanServer) {
        this(wLSMBeanServer, null);
    }

    public SecurityInterceptor(WLSMBeanServer wLSMBeanServer, String string) {
        this.wlsMBeanServer = wLSMBeanServer;
        RealmMBean realmMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurityConfiguration().getDefaultRealm();
        this.useSecurityFramework = realmMBean.isDelegateMBeanAuthorization();
        AuditorMBean[] auditorMBeanArray = realmMBean.getAuditors();
        if (this.useSecurityFramework && auditorMBeanArray != null && auditorMBeanArray.length > 0) {
            this.auditorsConfigured = true;
        }
        this.authorizer = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        this.policyConsumer = SecurityServiceManager.getJMXPolicyConsumer((AuthenticatedSubject)kernelId);
        if (string != null) {
            securityInterceptors.put(string, this);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            this.checkForBEADomain(objectName);
            this.checkCreateSecurity(string, objectName);
            ObjectInstance objectInstance = super.createMBean(string, objectName);
            ConfigurationAuditor.getInstance().create(objectName, null);
            return objectInstance;
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().create(objectName, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().create(objectName, reflectionException);
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ConfigurationAuditor.getInstance().create(objectName, instanceAlreadyExistsException);
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanRegistrationException);
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanException);
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, notCompliantMBeanException);
            throw notCompliantMBeanException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().create(objectName, iOException);
            throw iOException;
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            this.checkForBEADomain(objectName);
            this.checkCreateSecurity(string, objectName, objectName2);
            ObjectInstance objectInstance = super.createMBean(string, objectName, objectName2);
            ConfigurationAuditor.getInstance().create(objectName, null);
            return objectInstance;
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().create(objectName, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().create(objectName, reflectionException);
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ConfigurationAuditor.getInstance().create(objectName, instanceAlreadyExistsException);
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanRegistrationException);
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanException);
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, notCompliantMBeanException);
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ConfigurationAuditor.getInstance().create(objectName, instanceNotFoundException);
            throw instanceNotFoundException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().create(objectName, iOException);
            throw iOException;
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            this.checkForBEADomain(objectName);
            this.checkCreateSecurity(string, objectName, objectArray, stringArray);
            ObjectInstance objectInstance = super.createMBean(string, objectName, objectArray, stringArray);
            ConfigurationAuditor.getInstance().create(objectName, null);
            return objectInstance;
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().create(objectName, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().create(objectName, reflectionException);
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ConfigurationAuditor.getInstance().create(objectName, instanceAlreadyExistsException);
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanRegistrationException);
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanException);
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, notCompliantMBeanException);
            throw notCompliantMBeanException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().create(objectName, iOException);
            throw iOException;
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            this.checkForBEADomain(objectName);
            this.checkCreateSecurity(string, objectName, objectName2, objectArray, stringArray);
            ObjectInstance objectInstance = super.createMBean(string, objectName, objectName2, objectArray, stringArray);
            ConfigurationAuditor.getInstance().create(objectName, null);
            return objectInstance;
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().create(objectName, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().create(objectName, reflectionException);
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ConfigurationAuditor.getInstance().create(objectName, instanceAlreadyExistsException);
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanRegistrationException);
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, mBeanException);
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ConfigurationAuditor.getInstance().create(objectName, notCompliantMBeanException);
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ConfigurationAuditor.getInstance().create(objectName, instanceNotFoundException);
            throw instanceNotFoundException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().create(objectName, iOException);
            throw iOException;
        }
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        this.checkGetSecurity(objectName, string);
        Object object = super.getAttribute(objectName, string);
        return object;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
        this.checkGetSecurity(objectName, stringArray);
        return super.getAttributes(objectName, stringArray);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            if (this.isWLSMBean(objectName)) {
                Loggable loggable = JMXLogger.logWLSMBeanUnregisterFailedLoggable((String)objectName.getCanonicalName());
                throw new NoAccessRuntimeException(loggable.getMessage());
            }
            this.checkUnregisterSecurity(objectName);
            super.unregisterMBean(objectName);
            ConfigurationAuditor.getInstance().remove(objectName, null);
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().remove(objectName, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ConfigurationAuditor.getInstance().remove(objectName, instanceNotFoundException);
            throw instanceNotFoundException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ConfigurationAuditor.getInstance().remove(objectName, mBeanRegistrationException);
            throw mBeanRegistrationException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().remove(objectName, iOException);
            throw iOException;
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        Object object = null;
        PropertyDescriptor propertyDescriptor = null;
        try {
            if (ConfigurationAuditor.getInstance().isAuditable(objectName) || this.auditorsConfigured) {
                propertyDescriptor = this.getPropertyDescriptor(objectName, attribute.getName());
                object = super.getAttribute(objectName, attribute.getName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception caught while performing getAttribute for setAttribute " + exception);
        }
        try {
            this.checkSetSecurity(objectName, attribute, object);
            super.setAttribute(objectName, attribute);
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, null);
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)instanceNotFoundException);
            throw instanceNotFoundException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)attributeNotFoundException);
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)invalidAttributeValueException);
            throw invalidAttributeValueException;
        }
        catch (MBeanException mBeanException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)mBeanException);
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)reflectionException);
            throw reflectionException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().modify(objectName, object, attribute, propertyDescriptor, (Exception)iOException);
            throw iOException;
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        Object object;
        AttributeList attributeList2 = null;
        PropertyDescriptor[] propertyDescriptorArray = null;
        if (ConfigurationAuditor.getInstance().isAuditable(objectName) || this.auditorsConfigured) {
            try {
                object = attributeList.iterator();
                propertyDescriptorArray = new PropertyDescriptor[attributeList.size()];
                String[] stringArray = new String[attributeList.size()];
                for (int i = 0; i < attributeList.size(); ++i) {
                    Object e = object.next();
                    if (!(e instanceof Attribute)) {
                        throw new RuntimeException("AttributeList must contain instances of Attribute");
                    }
                    Attribute attribute = (Attribute)e;
                    stringArray[i] = new String(attribute.getName());
                    propertyDescriptorArray[i] = this.getPropertyDescriptor(objectName, attribute.getName());
                }
                attributeList2 = super.getAttributes(objectName, stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.checkSetSecurity(objectName, attributeList);
            object = super.setAttributes(objectName, attributeList);
            ConfigurationAuditor.getInstance().modify(objectName, attributeList2, attributeList, propertyDescriptorArray, null);
            return object;
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().modify(objectName, attributeList2, attributeList, propertyDescriptorArray, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ConfigurationAuditor.getInstance().modify(objectName, attributeList2, attributeList, propertyDescriptorArray, (Exception)instanceNotFoundException);
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().modify(objectName, attributeList2, attributeList, propertyDescriptorArray, (Exception)reflectionException);
            throw reflectionException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().modify(objectName, attributeList2, attributeList, propertyDescriptorArray, (Exception)iOException);
            throw iOException;
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object object = null;
        MethodDescriptor methodDescriptor = this.getMethodDescriptor(objectName, string, stringArray);
        try {
            this.checkInvokeSecurity(objectName, string, objectArray, stringArray, methodDescriptor);
            object = super.invoke(objectName, string, objectArray, stringArray);
            ConfigurationAuditor.getInstance().invoke(objectName, methodDescriptor, string, objectArray, null);
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            ConfigurationAuditor.getInstance().invoke(objectName, methodDescriptor, string, objectArray, (Exception)((Object)noAccessRuntimeException));
            throw noAccessRuntimeException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ConfigurationAuditor.getInstance().invoke(objectName, methodDescriptor, string, objectArray, instanceNotFoundException);
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            ConfigurationAuditor.getInstance().invoke(objectName, methodDescriptor, string, objectArray, mBeanException);
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            ConfigurationAuditor.getInstance().invoke(objectName, methodDescriptor, string, objectArray, reflectionException);
            throw reflectionException;
        }
        catch (IOException iOException) {
            ConfigurationAuditor.getInstance().invoke(objectName, methodDescriptor, string, objectArray, iOException);
            throw iOException;
        }
        return object;
    }

    public static boolean isGetAccessAllowed(String string, ObjectName objectName, String string2) throws AttributeNotFoundException, InstanceNotFoundException {
        SecurityInterceptor securityInterceptor = (SecurityInterceptor)((Object)securityInterceptors.get(string));
        if (securityInterceptor == null) {
            throw new InstanceNotFoundException("MBeanServer " + string + "does not exist");
        }
        try {
            securityInterceptor.checkGetSecurity(objectName, string2);
            return true;
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            return false;
        }
    }

    private void checkCreateSecurity(String string, ObjectName objectName) {
        this.initDefaultPolicies();
        if (objectName == null) {
            return;
        }
        if (this.useSecurityFramework) {
            this.isAccessAllowed(objectName, "create", null);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        }
    }

    private void checkCreateSecurity(String string, ObjectName objectName, ObjectName objectName2) {
        this.initDefaultPolicies();
        if (objectName == null) {
            return;
        }
        if (this.useSecurityFramework) {
            this.isAccessAllowed(objectName, "create", null);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        }
    }

    private void checkCreateSecurity(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) {
        this.initDefaultPolicies();
        if (this.useSecurityFramework) {
            this.isAccessAllowed(objectName, "create", null);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        }
    }

    private void checkCreateSecurity(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) {
        this.initDefaultPolicies();
        if (this.useSecurityFramework) {
            this.isAccessAllowed(objectName, "create", null);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.REGISTER, null, "createMBean", this.getBeanDescriptor(objectName));
        }
    }

    private void checkGetSecurity(ObjectName objectName, String string) throws AttributeNotFoundException {
        String string2;
        boolean bl;
        this.initDefaultPolicies();
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(objectName, string);
        Boolean bl2 = null;
        Boolean bl3 = null;
        if (propertyDescriptor != null) {
            bl2 = (Boolean)propertyDescriptor.getValue("encrypted");
            bl3 = (Boolean)propertyDescriptor.getValue("sensitive");
        }
        if (bl2 != null && bl2.booleanValue() && !string.endsWith("Encrypted") && !(bl = (string2 = System.getProperty("weblogic.management.clearTextCredentialAccessEnabled")) != null && string2.length() > 0 ? Boolean.parseBoolean(string2) : ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurityConfiguration().isClearTextCredentialAccessEnabled())) {
            throw new NoAccessRuntimeException("Access to sensitive attribute in clear text is not allowed due to the setting of ClearTextCredentialAccessEnabled attribute in SecurityConfigurationMBean. Attr: " + string + ", MBean name: " + objectName);
        }
        if (this.useSecurityFramework) {
            String string3 = "get";
            if (bl2 != null && bl2.booleanValue() || bl3 != null && bl3.booleanValue()) {
                string3 = "getEncrypted";
            }
            this.isAccessAllowed(objectName, string3, string);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.READ, string, "getAttribute", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, string));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.READ, string, "getAttribute", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, string));
        }
    }

    private void checkGetSecurity(ObjectName objectName, String[] stringArray) {
        this.initDefaultPolicies();
        if (this.useSecurityFramework) {
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                try {
                    this.checkGetSecurity(objectName, stringArray[i]);
                    continue;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    // empty catch block
                }
            }
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                try {
                    SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.READ, stringArray[i], "getAttributes", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, stringArray[i]));
                    continue;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                try {
                    SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.READ, stringArray[i], "getAttributes", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, stringArray[i]));
                    continue;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private void checkUnregisterSecurity(ObjectName objectName) {
        this.initDefaultPolicies();
        if (this.useSecurityFramework) {
            this.isAccessAllowed(objectName, "unregister", null);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.UNREGISTER, null, "unregisterMBean", this.getBeanDescriptor(objectName));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.UNREGISTER, null, "unregisterMBean", this.getBeanDescriptor(objectName));
        }
    }

    private void checkSetSecurity(ObjectName objectName, Attribute attribute, Object object) throws AttributeNotFoundException {
        this.initDefaultPolicies();
        String string = attribute.getName();
        if (this.useSecurityFramework) {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(objectName, string);
            String string2 = "set";
            Boolean bl = null;
            Boolean bl2 = null;
            String[] stringArray = new String[1];
            Object[] objectArray = new Object[]{attribute.getValue()};
            stringArray[0] = "java.lang.Object";
            String string3 = null;
            if (propertyDescriptor != null) {
                bl = (Boolean)propertyDescriptor.getValue("encrypted");
                bl2 = (Boolean)propertyDescriptor.getValue("sensitive");
                stringArray[0] = propertyDescriptor.getPropertyType().getName();
            }
            if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
                string2 = "setEncrypted";
                string3 = "1";
            }
            this.isAccessAllowedInvoke(objectName, string2, string, objectArray, stringArray, string3, object);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.WRITE, string, "setAttribute", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, string));
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.WRITE, string, "setAttribute", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSetSecurity(ObjectName objectName, AttributeList attributeList) {
        this.initDefaultPolicies();
        boolean bl = true;
        if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            bl = false;
        }
        AttributeList attributeList2 = attributeList;
        synchronized (attributeList2) {
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    if (e instanceof Attribute) {
                        Attribute attribute = (Attribute)e;
                        if (this.useSecurityFramework) {
                            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(objectName, attribute.getName());
                            String string = "set";
                            Boolean bl2 = null;
                            Boolean bl3 = null;
                            if (propertyDescriptor != null) {
                                bl2 = (Boolean)propertyDescriptor.getValue("encrypted");
                                bl3 = (Boolean)propertyDescriptor.getValue("sensitive");
                            }
                            if (bl2 != null && bl2.booleanValue() || bl3 != null && bl3.booleanValue()) {
                                string = "setEncrypted";
                            }
                            this.isAccessAllowed(objectName, string, attribute.getName());
                            continue;
                        }
                        if (!bl) {
                            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.WRITE, attribute.getName(), "setAttributes", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, attribute.getName()));
                            continue;
                        }
                        SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.WRITE, attribute.getName(), "setAttributes", this.getBeanDescriptor(objectName), this.getPropertyDescriptor(objectName, attribute.getName()));
                        continue;
                    }
                    throw new RuntimeException("AttributeList must contain instances of Attribute");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    iterator.remove();
                }
                catch (NoAccessRuntimeException noAccessRuntimeException) {
                    iterator.remove();
                }
            }
        }
    }

    private void checkInvokeSecurity(ObjectName objectName, String string, Object[] objectArray, String[] stringArray, MethodDescriptor methodDescriptor) {
        Object object;
        this.initDefaultPolicies();
        Object object2 = this.wlsMBeanServer.lookupObject(objectName);
        String string2 = null;
        if (object2 != null && object2 instanceof WLSModelMBean) {
            object = (WLSModelMBean)object2;
            string2 = object.getRole(string, objectArray, stringArray);
        } else if (methodDescriptor != null) {
            string2 = (String)methodDescriptor.getValue("role");
        }
        if (string2 != null && string2.equals("finder")) {
            if (this.useSecurityFramework) {
                object = null;
                if (methodDescriptor != null) {
                    object = (String)methodDescriptor.getValue("wls:auditProtectedArgs");
                }
                this.isAccessAllowedInvoke(objectName, "find", string, objectArray, stringArray, (String)object, null);
            } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
                SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.FIND, string, "invoke", this.getBeanDescriptor(objectName), methodDescriptor);
            } else {
                SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.FIND, string, "invoke", this.getBeanDescriptor(objectName), methodDescriptor);
            }
            return;
        }
        if (this.useSecurityFramework) {
            object = null;
            if (methodDescriptor != null) {
                object = (String)methodDescriptor.getValue("wls:auditProtectedArgs");
            }
            this.isAccessAllowedInvoke(objectName, "invoke", string, objectArray, stringArray, (String)object, null);
        } else if (this.isWLSMBean(objectName) || !this.isCommoMBean(objectName)) {
            SecurityHelper.isAccessAllowed(objectName, MBeanResource.ActionType.EXECUTE, string, "invoke", this.getBeanDescriptor(objectName), methodDescriptor);
        } else {
            SecurityHelper.isAccessAllowedCommo(objectName, MBeanResource.ActionType.EXECUTE, string, "invoke", this.getBeanDescriptor(objectName), methodDescriptor);
        }
    }

    private boolean isCommoMBean(ObjectName objectName) {
        Object object = this.wlsMBeanServer.lookupObject(objectName);
        if (object != null && object instanceof WLSModelMBean) {
            WLSModelMBean wLSModelMBean = (WLSModelMBean)object;
            return StandardInterface.class.isAssignableFrom(wLSModelMBean.getManagedResourceClass());
        }
        return false;
    }

    private boolean isWLSMBean(ObjectName objectName) {
        if (objectName == null) {
            return false;
        }
        if (objectName instanceof WebLogicObjectName) {
            return true;
        }
        return WLSObjectNameManager.isBEADomain(objectName.getDomain());
    }

    private BeanDescriptor getBeanDescriptor(ObjectName objectName) {
        String string;
        BeanInfo beanInfo;
        if (objectName == null) {
            return null;
        }
        Object object = this.wlsMBeanServer.lookupObject(objectName);
        if (object != null && object instanceof WLSModelMBean && (beanInfo = (string = (WLSModelMBean)object).getBeanInfo()) != null) {
            return beanInfo.getBeanDescriptor();
        }
        string = objectName.getKeyProperty("Type");
        if (string != null) {
            return SecurityHelper.getBeanDescriptor(string);
        }
        return null;
    }

    private PropertyDescriptor getPropertyDescriptor(ObjectName objectName, String string) throws AttributeNotFoundException {
        if (objectName == null) {
            return null;
        }
        Object object = this.wlsMBeanServer.lookupObject(objectName);
        if (object != null && object instanceof WLSModelMBean) {
            WLSModelMBean wLSModelMBean = (WLSModelMBean)object;
            return wLSModelMBean.getPropertyDescriptorForAttribute(string);
        }
        String string2 = objectName.getKeyProperty("Type");
        if (string2 != null) {
            return SecurityHelper.getPropertyDescriptor(string2, string);
        }
        return null;
    }

    private MethodDescriptor getMethodDescriptor(ObjectName objectName, String string, String[] stringArray) {
        Object object = this.wlsMBeanServer.lookupObject(objectName);
        if (object != null && object instanceof WLSModelMBean) {
            WLSModelMBean wLSModelMBean = (WLSModelMBean)object;
            return wLSModelMBean.getMethodDescriptor(string, stringArray);
        }
        String string2 = objectName.getKeyProperty("Type");
        if (string2 != null) {
            return SecurityHelper.getMethodDescriptor(string2, string);
        }
        return null;
    }

    private void initDefaultPolicies() {
        if (!registeredPolicies) {
            try {
                this.registerDefaultPolicies();
            }
            catch (ConsumptionException consumptionException) {
                throw new RuntimeException(consumptionException);
            }
        }
    }

    private synchronized void registerDefaultPolicies() throws ConsumptionException {
        registeredPolicies = true;
        if (!this.useSecurityFramework) {
            return;
        }
        String string = "WLSDefaultJMXResourcePolicies";
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2005, 7, 11, 0, 0, 0);
        String string2 = "" + calendar.getTime().getTime();
        String string3 = this.formatTimestamp(string2);
        String string4 = VersionInfo.theOne().getReleaseVersion();
        long l = 0L;
        if (debug.isDebugEnabled()) {
            debug.debug("Start registration of default JMX Resource policies.");
            l = System.currentTimeMillis();
        }
        boolean bl = true;
        JMXPolicyHandler jMXPolicyHandler = this.policyConsumer.getJMXPolicyHandler(string, string4, string3);
        if (jMXPolicyHandler != null) {
            this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("get", null, null, null));
            this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("find", null, null, null));
            this.setPolicy(jMXPolicyHandler, new JMXResource(null, null, null, null), new String[0], null);
            jMXPolicyHandler.done();
        }
        BeanInfoAccess beanInfoAccess = ManagementService.getBeanInfoAccess();
        String[] stringArray = beanInfoAccess.getBeanInfoFactoryNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            String[] stringArray2 = beanInfoAccess.getInterfacesWithRoleInfo(string5);
            if (stringArray2 == null || stringArray2.length == 0 || (jMXPolicyHandler = this.policyConsumer.getJMXPolicyHandler(string5, string4, string3 = this.formatTimestamp(string2 = beanInfoAccess.getRoleInfoImplementationFactoryTimestamp(string5)))) == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                String[] stringArray3;
                String[] stringArray4;
                BeanInfo beanInfo = beanInfoAccess.getBeanInfoForInterface(stringArray2[j], true, string4);
                if (beanInfo == null) {
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Beaninfo for interface is null - interface is " + stringArray2[j]);
                    continue;
                }
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                Boolean bl2 = (Boolean)beanDescriptor.getValue("rolePermitAll");
                if (bl2 != null && bl2.booleanValue()) {
                    this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("set", null, stringArray2[j], null));
                    this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("invoke", null, stringArray2[j], null));
                    this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("create", null, stringArray2[j], null));
                    this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("unregister", null, stringArray2[j], null));
                }
                if ((stringArray4 = (String[])beanDescriptor.getValue("rolesAllowed")) != null) {
                    this.setPolicy(jMXPolicyHandler, new JMXResource("set", null, stringArray2[j], null), stringArray4, null);
                    this.setPolicy(jMXPolicyHandler, new JMXResource("invoke", null, stringArray2[j], null), stringArray4, null);
                    this.setPolicy(jMXPolicyHandler, new JMXResource("create", null, stringArray2[j], null), stringArray4, null);
                    this.setPolicy(jMXPolicyHandler, new JMXResource("unregister", null, stringArray2[j], null), stringArray4, null);
                }
                MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
                for (int k = 0; methodDescriptorArray != null && k < methodDescriptorArray.length; ++k) {
                    MethodDescriptor methodDescriptor = methodDescriptorArray[k];
                    bl2 = (Boolean)methodDescriptor.getValue("rolePermitAll");
                    if (bl2 != null && bl2.booleanValue()) {
                        this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource("invoke", null, stringArray2[j], methodDescriptor.getName()));
                    }
                    if ((stringArray3 = (String[])methodDescriptor.getValue("rolesAllowed")) == null) continue;
                    this.setPolicy(jMXPolicyHandler, new JMXResource("invoke", null, stringArray2[j], methodDescriptor.getName()), stringArray4, stringArray3);
                }
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int k = 0; propertyDescriptorArray != null && k < propertyDescriptorArray.length; ++k) {
                    String[] stringArray5;
                    stringArray3 = propertyDescriptorArray[k];
                    String string6 = "get";
                    String string7 = "set";
                    Boolean bl3 = (Boolean)stringArray3.getValue("encrypted");
                    Boolean bl4 = (Boolean)stringArray3.getValue("sensitive");
                    if (bl3 != null && bl3.booleanValue() || bl4 != null && bl4.booleanValue()) {
                        string6 = "getEncrypted";
                        string7 = "setEncrypted";
                    }
                    if ((bl2 = (Boolean)stringArray3.getValue("rolePermitAllGet")) != null && bl2.booleanValue()) {
                        this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource(string6, null, stringArray2[j], stringArray3.getName()));
                    }
                    if ((stringArray5 = (String[])stringArray3.getValue("rolesAllowedGet")) != null) {
                        this.setPolicy(jMXPolicyHandler, new JMXResource(string6, null, stringArray2[j], stringArray3.getName()), stringArray4, stringArray5);
                    }
                    if ((bl2 = (Boolean)stringArray3.getValue("rolePermitAllSet")) != null && bl2.booleanValue()) {
                        this.setUncheckedPolicy(jMXPolicyHandler, new JMXResource(string7, null, stringArray2[j], stringArray3.getName()));
                    }
                    if ((stringArray5 = (String[])stringArray3.getValue("rolesAllowedSet")) == null) continue;
                    this.setPolicy(jMXPolicyHandler, new JMXResource(string7, null, stringArray2[j], stringArray3.getName()), stringArray4, stringArray5);
                }
            }
            jMXPolicyHandler.done();
        }
        if (debug.isDebugEnabled()) {
            long l2 = System.currentTimeMillis();
            debug.debug("End registration of default JMX Resource policies. Elasped time is " + (l2 - l));
        }
    }

    private void isAccessAllowed(ObjectName objectName, String string, String string2) throws NoAccessRuntimeException {
        JMXContextHandler jMXContextHandler;
        if (!this.isWLSMBean(objectName) && !this.isCommoMBean(objectName) && objectName != null && objectName.getKeyProperty("Type") == null) {
            return;
        }
        String string3 = this.getBeanType(objectName);
        String string4 = this.getAppName(objectName);
        JMXResource jMXResource = new JMXResource(string, string4, string3, string2);
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (!this.authorizer.isAccessAllowed(authenticatedSubject, (Resource)jMXResource, (ContextHandler)(jMXContextHandler = new JMXContextHandler(objectName)))) {
            String string5 = "Access not allowed for subject: " + authenticatedSubject + ", on Resource " + string3 + " Operation: " + string + " , Target: " + string2;
            throw new NoAccessRuntimeException(string5);
        }
    }

    private void isAccessAllowedInvoke(ObjectName objectName, String string, String string2, Object[] objectArray, String[] stringArray, String string3, Object object) throws NoAccessRuntimeException {
        JMXContextHandler jMXContextHandler;
        if (!this.isWLSMBean(objectName) && !this.isCommoMBean(objectName) && objectName != null && objectName.getKeyProperty("Type") == null) {
            return;
        }
        String string4 = this.getBeanType(objectName);
        String string5 = this.getAppName(objectName);
        JMXResource jMXResource = new JMXResource(string, string5, string4, string2);
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (!this.authorizer.isAccessAllowed(authenticatedSubject, (Resource)jMXResource, (ContextHandler)(jMXContextHandler = new JMXContextHandler(objectName, objectArray, stringArray, string3, object)))) {
            String string6 = "Access not allowed for subject: " + authenticatedSubject + ", on Resource " + string4 + " Operation: " + string + " , Target: " + string2;
            throw new NoAccessRuntimeException(string6);
        }
    }

    private String getBeanType(ObjectName objectName) {
        Object object;
        String string;
        Object object2;
        if (objectName == null) {
            return null;
        }
        Object object3 = this.wlsMBeanServer.lookupObject(objectName);
        if (object3 != null && object3 instanceof WLSModelMBean && (object2 = (string = (WLSModelMBean)object3).getBeanInfo()) != null && (object = object2.getBeanDescriptor()) != null) {
            return (String)((FeatureDescriptor)object).getValue("interfaceclassname");
        }
        string = objectName.getKeyProperty("Type");
        if (string != null) {
            object2 = null;
            object2 = string.endsWith("Runtime") ? "weblogic.management.runtime." + string + "MBean" : "weblogic.management.configuration." + string + "MBean";
            try {
                object = Class.forName((String)object2);
                return object2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private String getAppName(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        for (int i = 0; i < APP_SCOPED_TYPES.length; ++i) {
            String string = objectName.getKeyProperty(APP_SCOPED_TYPES[i]);
            if (string != null) {
                return string;
            }
            String string2 = objectName.getKeyProperty("Type");
            if (!APP_SCOPED_TYPES[i].equals(string2)) continue;
            return objectName.getKeyProperty("Name");
        }
        String string = objectName.getKeyProperty("Path");
        if (string != null) {
            int n = string.indexOf("[");
            int n2 = string.indexOf("]");
            if (n != -1 && n2 != -1 && n < n2) {
                return string.substring(n + 1, n2);
            }
            return objectName.getKeyProperty("Name");
        }
        return null;
    }

    private void setUncheckedPolicy(JMXPolicyHandler jMXPolicyHandler, JMXResource jMXResource) throws ConsumptionException {
        if (debug.isDebugEnabled()) {
            debug.debug("Register unchecked policy " + jMXResource);
        }
        jMXPolicyHandler.setUncheckedPolicy(jMXResource);
    }

    private void setPolicy(JMXPolicyHandler jMXPolicyHandler, JMXResource jMXResource, String[] stringArray, String[] stringArray2) throws ConsumptionException {
        int n;
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = stringArray2 == null ? 0 : stringArray2.length;
        int n4 = n2 + n3;
        String[] stringArray3 = new String[n4 + 1];
        for (n = 0; n < n2; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < n3; ++n) {
            stringArray3[n + n2] = stringArray2[n];
        }
        stringArray3[n4] = "Admin";
        if (debug.isDebugEnabled()) {
            String string = "";
            for (int i = 0; stringArray3 != null && i < stringArray3.length; ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + stringArray3[i];
            }
            debug.debug("Register checked policy " + jMXResource + " roles " + string);
        }
        jMXPolicyHandler.setPolicy(jMXResource, stringArray3);
    }

    private String formatTimestamp(String string) {
        Serializable serializable;
        Date date = null;
        try {
            serializable = new Long(string);
            date = new Date((Long)serializable);
        }
        catch (NumberFormatException numberFormatException) {
            date = new Date();
        }
        serializable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        ((DateFormat)serializable).setTimeZone(TimeZone.getTimeZone("GMT"));
        return ((DateFormat)serializable).format(date);
    }

    private void checkForBEADomain(ObjectName objectName) {
        if (objectName != null && BEA_DOMAIN.equals(objectName.getDomain())) {
            Loggable loggable = JMXLogger.logMBeanRegistrationFailedLoggable((String)objectName.getCanonicalName());
            throw new NoAccessRuntimeException(loggable.getMessage());
        }
    }

    static {
        securityInterceptors = Collections.synchronizedMap(new HashMap());
        APP_SCOPED_TYPES = new String[]{"ApplicationRuntime", "JDBCSystemResource", "JMSSystemResource", "WLDFSystemResource", "CustomResource"};
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        BEA_DOMAIN = "com.bea";
    }
}

