/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.io.IOException;
import java.security.AccessController;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class SecurityMBeanMgmtOpsInterceptor
extends WLSMBeanServerInterceptorBase {
    private static final String REALM_MBEAN = "weblogic.management.security.RealmMBean";
    private static final String SECURITY_STORE_MBEAN = "weblogic.management.security.RDBMSSecurityStoreMBean";
    private static final String ULM_MBEAN = "weblogic.management.security.authentication.UserLockoutManagerMBean";
    private static final String PROVIDER_MBEAN = "weblogic.management.security.ProviderMBean";
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMX");
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final int EDIT_MBS = 1;
    public static final int DOMAIN_RUNTIME_MBS = 2;
    private int mbsType;

    public SecurityMBeanMgmtOpsInterceptor(int n) {
        this.mbsType = n;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if (!this.isInvokeAllowed(objectName, string)) {
            String string2 = ManagementTextTextFormatter.getInstance().getMgmtOperationsIllegal();
            if (this.mbsType == 2) {
                string2 = ManagementTextTextFormatter.getInstance().getMgmtOperationsIllegalDomainRuntime();
            }
            throw new MBeanException(new RuntimeException(string2), string2);
        }
        return super.invoke(objectName, string, objectArray, stringArray);
    }

    private boolean isInvokeAllowed(ObjectName objectName, String string) throws InstanceNotFoundException, IOException, MBeanException, ReflectionException {
        try {
            if (this.mbsType == 2 && !ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isRestartRequired()) {
                return true;
            }
            MBeanInfo mBeanInfo = super.getMBeanInfo(objectName);
            if (!(mBeanInfo instanceof ModelMBeanInfo)) {
                return true;
            }
            ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)mBeanInfo);
            String string2 = modelMBeanInfo.getClassName();
            Class clazz = DescriptorClassLoader.loadClass((String)string2);
            if (this.isSecurityMBean(clazz)) {
                if (modelMBeanInfo.getOperation(string) == null || modelMBeanInfo.getOperation(string).getImpact() == 0) {
                    return true;
                }
                Descriptor descriptor = modelMBeanInfo.getOperation(string).getDescriptor();
                Boolean bl = (Boolean)descriptor.getFieldValue("com.bea.allowSecurityOperations");
                if (bl != null && bl.booleanValue()) {
                    return true;
                }
                String string3 = (String)descriptor.getFieldValue("com.bea.collectionRole");
                if (string3 != null) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("This operation " + string + " is a Management operation " + "on MBean " + objectName + " and will be prevented.");
                    }
                    return false;
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            if (debug.isDebugEnabled()) {
                debug.debug("IntrospectionException thrown while checking the mgmt operations.", (Throwable)introspectionException);
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug.isDebugEnabled()) {
                debug.debug("ClassNotFoundException thrown while checking the mgmt operations.", (Throwable)classNotFoundException);
            }
            return true;
        }
        return true;
    }

    private boolean isSecurityMBean(Class clazz) throws ClassNotFoundException {
        if (Class.forName(REALM_MBEAN).isAssignableFrom(clazz) || Class.forName(PROVIDER_MBEAN).isAssignableFrom(clazz) || Class.forName(ULM_MBEAN).isAssignableFrom(clazz) || Class.forName(SECURITY_STORE_MBEAN).isAssignableFrom(clazz)) {
            if (debug.isDebugEnabled()) {
                debug.debug("Invoking a management operation on a security mbean.");
            }
            return true;
        }
        return false;
    }
}

