/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal;

import java.beans.BeanInfo;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.WebLogicMBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.ObjectNameManagerBase;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.Service;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.runtime.DomainRuntimeMBean;

public class WLSObjectNameManager
extends ObjectNameManagerBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXCore");
    private static final String BEA_DOMAIN_NAME = "com.bea";
    private final String domainName;
    private final BeanInfoAccess beanInfoAccess;
    private boolean addDomainToReadOnly = false;

    public void setAddDomainToReadOnly(boolean bl) {
        this.addDomainToReadOnly = bl;
    }

    public WLSObjectNameManager(String string) {
        super(DescriptorBean.class);
        this.domainName = string;
        this.beanInfoAccess = ManagementService.getBeanInfoAccess();
    }

    public boolean isClassMapped(Class clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        if (clazz == String.class) {
            return false;
        }
        if (Service.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (StandardInterface.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (WebLogicMBean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (DescriptorBean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (this.beanInfoAccess.hasBeanInfo(clazz)) {
            BeanInfo beanInfo = this.beanInfoAccess.getBeanInfoForInterface(clazz.getName(), false, null);
            Boolean bl = (Boolean)beanInfo.getBeanDescriptor().getValue("valueObject");
            return bl == null || bl == false;
        }
        return false;
    }

    protected String getDomainName() {
        return this.domainName;
    }

    public ObjectName lookupObjectName(Object object) {
        ObjectName objectName = super.lookupObjectName(object);
        if (objectName != null) {
            return objectName;
        }
        objectName = this.buildObjectName(object);
        if (objectName == null) {
            throw new Error("Unable to build an ObjectName for the instance " + object + " of class " + (object == null ? "null" : object.getClass().getName()));
        }
        super.registerObject(objectName, object);
        if (debug.isDebugEnabled()) {
            String string = object == null ? "null" : object.getClass().getName() + "{" + object.hashCode() + "}";
            debug.debug("WLSObjectNameManager.lookupObjectName: registered in " + (Object)((Object)this) + ":" + objectName + ":" + string);
        }
        return objectName;
    }

    public ObjectName buildObjectName(Object object) {
        ObjectName objectName = null;
        if (object instanceof WebLogicMBean) {
            objectName = this.lookupWebLogicObjectName(object);
        } else {
            if (object instanceof StandardInterface) {
                return WLSObjectNameManager.buildCommoObjectName(object);
            }
            if (object instanceof AbstractDescriptorBean) {
                objectName = this.lookupDescriptorObjectName((AbstractDescriptorBean)object);
            } else if (object instanceof Service) {
                objectName = this.lookupServiceObjectName((Service)object);
            }
        }
        return objectName;
    }

    private ObjectName lookupServiceObjectName(Service service2) {
        Service service3;
        String string;
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = service2.getType();
        if (string2 != null) {
            hashtable.put("Type", service2.getType());
        }
        if ((string = service2.getName()) != null) {
            hashtable.put("Name", service2.getName());
        }
        if ((service3 = service2.getParentService()) != null) {
            hashtable.put("Path", service2.getPath());
        }
        try {
            objectName = new ObjectName(BEA_DOMAIN_NAME, WLSObjectNameManager.quoteObjectNameEntries(hashtable));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException(malformedObjectNameException);
        }
        return objectName;
    }

    private ObjectName lookupDescriptorObjectName(AbstractDescriptorBean abstractDescriptorBean) {
        AbstractDescriptorBean abstractDescriptorBean2;
        Object object;
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        AbstractDescriptorBean abstractDescriptorBean3 = (AbstractDescriptorBean)abstractDescriptorBean.getDescriptor().getRootBean();
        DescriptorImpl descriptorImpl = (DescriptorImpl)abstractDescriptorBean.getDescriptor();
        AbstractDescriptorBean abstractDescriptorBean4 = (AbstractDescriptorBean)descriptorImpl.getContext().get("DescriptorConfigExtension");
        String string = (String)descriptorImpl.getContext().get("DescriptorConfigExtensionAttribute");
        hashtable.put("Parent", abstractDescriptorBean4._getQualifiedName());
        Object object2 = abstractDescriptorBean._getKey();
        for (AbstractDescriptorBean abstractDescriptorBean5 = (AbstractDescriptorBean)abstractDescriptorBean.getParentBean(); object2 == null && abstractDescriptorBean5 != null; abstractDescriptorBean5 = (AbstractDescriptorBean)abstractDescriptorBean5.getParentBean()) {
            object2 = abstractDescriptorBean5._getKey();
        }
        if (object2 == null && abstractDescriptorBean4 != null) {
            object2 = abstractDescriptorBean4._getKey();
        }
        if (object2 != null) {
            hashtable.put("Name", object2.toString());
        }
        if ((object = abstractDescriptorBean3._getKey()) == null) {
            object = abstractDescriptorBean4._getKey();
        }
        String string2 = object.toString();
        StringBuffer stringBuffer = new StringBuffer(string);
        String string3 = abstractDescriptorBean._getQualifiedName();
        if (string3 != null && string3.length() > 0) {
            if (!string3.startsWith("[")) {
                stringBuffer.append("[");
                stringBuffer.append(string2);
                stringBuffer.append("]");
            }
            stringBuffer.append(string3);
        }
        hashtable.put("Path", stringBuffer.toString());
        hashtable.put("Type", this.beanInfoAccess.getInterfaceForInstance((Object)abstractDescriptorBean).getName());
        if (this.addDomainToReadOnly && abstractDescriptorBean instanceof AbstractDescriptorBean && !(abstractDescriptorBean2 = abstractDescriptorBean).getDescriptor().isEditable()) {
            hashtable.put("Location", this.domainName);
        }
        try {
            objectName = new ObjectName(BEA_DOMAIN_NAME, WLSObjectNameManager.quoteObjectNameEntries(hashtable));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("Created new ObjectName =>" + objectName.getCanonicalName());
        }
        return objectName;
    }

    private ObjectName lookupWebLogicObjectName(Object object) {
        WebLogicMBean webLogicMBean;
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        WebLogicMBean webLogicMBean2 = (WebLogicMBean)object;
        hashtable.put("Type", webLogicMBean2.getType());
        String string = webLogicMBean2.getName();
        for (WebLogicMBean webLogicMBean3 = webLogicMBean2.getParent(); string == null && webLogicMBean3 != null; webLogicMBean3 = webLogicMBean3.getParent()) {
            string = webLogicMBean3.getName();
        }
        if (string == null) {
            throw new Error("Unable to determine name for bean " + object);
        }
        hashtable.put("Name", string);
        if (this.addDomainToReadOnly && object instanceof AbstractDescriptorBean && !(webLogicMBean = (AbstractDescriptorBean)object).getDescriptor().isEditable()) {
            hashtable.put("Location", this.domainName);
        }
        for (webLogicMBean = webLogicMBean2.getParent(); webLogicMBean != null && !(webLogicMBean instanceof DomainMBean) && !(webLogicMBean instanceof DomainRuntimeMBean); webLogicMBean = webLogicMBean.getParent()) {
            hashtable.put(webLogicMBean.getType(), webLogicMBean.getName());
        }
        try {
            objectName = new ObjectName(BEA_DOMAIN_NAME, WLSObjectNameManager.quoteObjectNameEntries(hashtable));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)("There is problem in constructing ObjectName " + malformedObjectNameException));
        }
        return objectName;
    }

    String getShortName(DescriptorBean descriptorBean) {
        if (descriptorBean instanceof WebLogicMBean) {
            return ((WebLogicMBean)descriptorBean).getName();
        }
        if (descriptorBean instanceof StandardInterface) {
            return ((StandardInterface)descriptorBean).getName();
        }
        return null;
    }

    String getShortType(DescriptorBean descriptorBean) {
        if (descriptorBean instanceof WebLogicMBean) {
            return ((WebLogicMBean)descriptorBean).getType();
        }
        if (descriptorBean instanceof StandardInterface) {
            return ((StandardInterface)descriptorBean).wls_getInterfaceClassName();
        }
        return null;
    }

    private static ObjectName buildCommoObjectName(Object object) {
        return ((StandardInterface)object).wls_getObjectName();
    }

    static boolean isBEADomain(String string) {
        return BEA_DOMAIN_NAME.equals(string);
    }
}

