/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal.utils.typing;

import java.io.Serializable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public interface MBeanCategorizer
extends Serializable {
    public String categorize(MBeanServerConnection var1, ObjectName var2);

    public TypeInfo getTypeInfo(MBeanServerConnection var1, ObjectName var2);

    public static class Impl
    implements MBeanCategorizer {
        static final long serialVersionUID = 1L;
        private Plugin[] plugins;

        public Impl(Plugin[] pluginArray) {
            this.plugins = pluginArray;
        }

        public String categorize(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            try {
                String string = objectName.getCanonicalName();
                for (int i = 0; i < this.plugins.length; ++i) {
                    Plugin plugin = this.plugins[i];
                    if (!plugin.handles(mBeanServerConnection, objectName)) continue;
                    return plugin.getCategoryName();
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public TypeInfo getTypeInfo(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            try {
                String string = objectName.getCanonicalName();
                for (int i = 0; i < this.plugins.length; ++i) {
                    String string2;
                    Plugin plugin = this.plugins[i];
                    if (!plugin.handles(mBeanServerConnection, objectName) || (string2 = plugin.getTypeName(mBeanServerConnection, objectName)) == null) continue;
                    return new TypeInfoImpl(string2, plugin.getCategoryName());
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class TypeInfoImpl
    implements TypeInfo {
        String type;
        String category;

        TypeInfoImpl(String string, String string2) {
            this.type = string;
            this.category = string2;
        }

        public String getTypeName() {
            return this.type;
        }

        public String getCategoryName() {
            return this.category;
        }
    }

    public static interface Plugin
    extends Serializable {
        public boolean handles(MBeanServerConnection var1, ObjectName var2);

        public String getTypeName(MBeanServerConnection var1, ObjectName var2);

        public String getCategoryName();
    }

    public static interface TypeInfo {
        public String getTypeName();

        public String getCategoryName();
    }
}

