/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal.utils.typing;

import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.management.mbeanservers.internal.utils.typing.MBeanCategorizer;

public interface MBeanCategorizerPlugins {
    public static final String MODEL_MBEAN_TYPE_TAG = "DiagnosticTypeName";

    public static class CustomPlugin
    implements MBeanCategorizer.Plugin {
        static final long serialVersionUID = 1L;
        public static final String CATEGORY_NAME = "Custom-MBean";

        public boolean handles(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            return true;
        }

        public String getTypeName(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            String string = null;
            try {
                if (mBeanServerConnection.isInstanceOf(objectName, "javax.management.modelmbean.ModelMBean")) {
                    ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)mBeanServerConnection.getMBeanInfo(objectName));
                    Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
                    string = (String)descriptor.getFieldValue(MBeanCategorizerPlugins.MODEL_MBEAN_TYPE_TAG);
                } else {
                    MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
                    string = mBeanInfo.getClassName();
                }
                return string;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public String getCategoryName() {
            return CATEGORY_NAME;
        }
    }

    public static class PlatformPlugin
    extends CustomPlugin {
        static final long serialVersionUID = 1L;
        public static final String CATEGORY_NAME = "Platform-MBean";

        public boolean handles(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            String string = this.getTypeName(mBeanServerConnection, objectName);
            return string != null && (string.startsWith("sun.") || string.startsWith("com.sun"));
        }

        public String getCategoryName(ObjectName objectName) {
            return CATEGORY_NAME;
        }
    }

    public static class JMXPlugin
    extends CustomPlugin {
        static final long serialVersionUID = 1L;
        public static final String CATEGORY_NAME = "JMX-MBean";

        public boolean handles(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            String string = this.getTypeName(mBeanServerConnection, objectName);
            return string != null && string.startsWith("javax.management");
        }

        public String getCategoryName(ObjectName objectName) {
            return CATEGORY_NAME;
        }
    }

    public static class NonWLSPlugin
    extends CustomPlugin {
        static final long serialVersionUID = 1L;
        public static final String CATEGORY_NAME = "Non-WLS-MBean";

        public boolean handles(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            try {
                return !mBeanServerConnection.isInstanceOf(objectName, "weblogic.management.jmx.modelmbean.WLSModelMBean");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public String getCategoryName(ObjectName objectName) {
            return CATEGORY_NAME;
        }
    }

    public static class WLSPlugin
    implements MBeanCategorizer.Plugin {
        static final long serialVersionUID = 1L;
        public static final String CATEGORY_NAME = "WLS-MBean";

        public boolean handles(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            try {
                return mBeanServerConnection.isInstanceOf(objectName, "weblogic.management.jmx.modelmbean.WLSModelMBean");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public String getTypeName(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            try {
                ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)mBeanServerConnection.getMBeanInfo(objectName));
                Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
                return (String)descriptor.getFieldValue("interfaceclassname");
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public String getCategoryName() {
            return CATEGORY_NAME;
        }
    }
}

