/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.internal.utils.typing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import weblogic.management.mbeanservers.internal.utils.typing.MBeanCategorizer;
import weblogic.management.mbeanservers.internal.utils.typing.MyNotificationFilter;
import weblogic.management.mbeanservers.internal.utils.typing.QueryFilter;

public class MBeanTypeUtil {
    private MBeanServerConnection mbs;
    private MBeanCategorizer categorizer;
    private Map notificationListeners = Collections.synchronizedMap(new HashMap());
    private static final String MBEAN_HARVESTABLE_TYPE_NAME = "DiagnosticTypeName";
    private UpdateTracker updateTracker = new UpdateTracker();

    public MBeanTypeUtil(MBeanServerConnection mBeanServerConnection, MBeanCategorizer mBeanCategorizer) throws JMException {
        this.mbs = mBeanServerConnection;
        this.categorizer = mBeanCategorizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistrationHandler(final RegHandler regHandler) throws JMException, IOException {
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        NotificationListener notificationListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleNotification(Notification notification, Object object) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                String string = mBeanServerNotification.getType();
                if (((MBeanTypeUtil)MBeanTypeUtil.this).updateTracker.initDone) {
                    MBeanTypeUtil.this.callbackNow(string, objectName, regHandler);
                } else {
                    UpdateTracker updateTracker = MBeanTypeUtil.this.updateTracker;
                    synchronized (updateTracker) {
                        if (((MBeanTypeUtil)MBeanTypeUtil.this).updateTracker.initDone) {
                            MBeanTypeUtil.this.callbackNow(string, objectName, regHandler);
                        } else if (string.equals("JMX.mbean.registered")) {
                            arrayList2.add(objectName);
                        } else if (string.equals("JMX.mbean.unregistered")) {
                            arrayList.add(objectName);
                        }
                    }
                }
            }
        };
        this.mbs.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), notificationListener, (NotificationFilter)new MyNotificationFilter(), null);
        this.notificationListeners.put(regHandler, notificationListener);
        Set<ObjectName> set = this.mbs.queryNames(new ObjectName("*:*"), this.categorizer != null ? new QueryFilter(this.categorizer) : null);
        UpdateTracker updateTracker = this.updateTracker;
        synchronized (updateTracker) {
            for (ObjectName objectName : arrayList2) {
                set.add(objectName);
            }
            for (ObjectName objectName : arrayList) {
                if (this.mbs.isRegistered(objectName)) continue;
                set.remove(objectName);
            }
            for (ObjectName objectName : set) {
                this.newInstance(objectName, regHandler);
            }
            this.updateTracker.initDone = true;
        }
    }

    public void removeRegistrationHandler(RegHandler regHandler) throws InstanceNotFoundException, ListenerNotFoundException, MalformedObjectNameException, IOException {
        NotificationListener notificationListener = (NotificationListener)this.notificationListeners.get(regHandler);
        if (regHandler != null) {
            this.mbs.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), notificationListener);
        }
    }

    private void callbackNow(String string, ObjectName objectName, RegHandler regHandler) {
        if (string.equals("JMX.mbean.registered")) {
            try {
                this.newInstance(objectName, regHandler);
            }
            catch (JMException jMException) {
                throw new RuntimeException(jMException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (string.equals("JMX.mbean.unregistered")) {
            try {
                this.deletedInstance(objectName, regHandler);
            }
            catch (JMException jMException) {
                throw new RuntimeException(jMException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private void newInstance(ObjectName objectName, RegHandler regHandler) throws JMException, IOException {
        MBeanCategorizer.TypeInfo typeInfo = this.categorizer.getTypeInfo(this.mbs, objectName);
        if (typeInfo == null) {
            return;
        }
        String string = typeInfo.getTypeName();
        if (string != null) {
            try {
                regHandler.newInstance(string, objectName.getCanonicalName(), typeInfo.getCategoryName());
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() == null || !(runtimeException.getCause() instanceof InstanceNotFoundException)) {
                    throw runtimeException;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void deletedInstance(ObjectName objectName, RegHandler regHandler) throws JMException, IOException {
        try {
            regHandler.instanceDeleted(objectName.getCanonicalName());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String[] getAttributes(String string) throws JMException {
        return null;
    }

    public static interface RegHandler {
        public void newInstance(String var1, String var2, String var3) throws Exception;

        public void instanceDeleted(String var1) throws Exception;
    }

    private class MBSListener
    implements NotificationListener {
        private MBSListener() {
        }

        public void handleNotification(Notification notification, Object object) {
        }
    }

    private class UpdateTracker {
        boolean initDone = false;

        private UpdateTracker() {
        }
    }
}

