/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.runtime.internal;

import java.beans.BeanInfo;
import java.security.AccessController;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.diagnostics.harvester.internal.TreeBeanHarvestableDataProviderHelper;
import weblogic.management.jmx.ObjectNameManager;
import weblogic.management.mbeanservers.internal.WLSObjectNameManager;
import weblogic.management.mbeanservers.runtime.internal.RuntimeServerService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class DiagnosticSupportService
extends AbstractServerService {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    boolean trackingInstances = true;
    BeanInfoAccess beanInfoAccess;
    ObjectNameManager objectNameManager;

    public void start() throws ServiceFailureException {
        this.beanInfoAccess = ManagementService.getBeanInfoAccess();
        this.objectNameManager = new WLSObjectNameManager(ManagementService.getRuntimeAccess(kernelId).getDomainName());
        TreeBeanHarvestableDataProviderHelper.setSupportService((Object)this);
        RuntimeServerService.setSupportService(this);
    }

    public BeanInfo getBeanInfo(String string) {
        return this.beanInfoAccess.getBeanInfoForInterface(string, true, null);
    }

    public void unregisterInstance(Object object) {
        if (this.trackingInstances) {
            this.objectNameManager.unregisterObjectInstance(object);
        }
    }

    public String getInterfaceClassForObjectIdentifier(String string) {
        try {
            Object object = this.objectNameManager.lookupObject(new ObjectName(string));
            if (object == null) {
                return null;
            }
            return this.beanInfoAccess.getInterfaceForInstance(object).getName();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    public String getObjectIdentifier(Object object) {
        ObjectName objectName = this.objectNameManager.lookupObjectName(object);
        if (objectName == null) {
            return null;
        }
        return objectName.getCanonicalName();
    }

    public String getRegisteredObjectIdentifier(Object object) {
        ObjectName objectName = this.objectNameManager.lookupRegisteredObjectName(object);
        if (objectName == null) {
            objectName = this.objectNameManager.buildObjectName(object);
        }
        if (objectName == null) {
            return null;
        }
        return objectName.getCanonicalName();
    }

    ObjectNameManager getObjectNameManager() {
        this.trackingInstances = false;
        return this.objectNameManager;
    }

    public Object getInstanceForObjectIdentifier(String string) {
        try {
            return this.objectNameManager.lookupObject(new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }
}

