/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.runtime.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.descriptor.InstanceMetricBean;
import weblogic.diagnostics.image.descriptor.JMXDomainStatisticsBean;
import weblogic.diagnostics.image.descriptor.ManagementRuntimeImageBean;
import weblogic.diagnostics.image.descriptor.MetricBean;
import weblogic.diagnostics.image.descriptor.ServerRuntimeStateBean;
import weblogic.diagnostics.image.descriptor.ServerRuntimeStatisticsBean;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;

public class ManagementRuntimeImageSource
implements ImageSource {
    private static final String[][] METRICS_TABLE = new String[][]{{"com.bea:Type=WorkManagerRuntime,*", "StuckThreadCount"}, {"com.bea:Type=JRockitRuntime,*", "HeapFreePercent", "JvmProcessorLoad"}, {"com.bea:Type=JVMRuntime,*", "HeapFreePercent"}, {"com.bea:Type=ThreadPoolRuntime,*", "HoggingThreadCount", "PendingUserRequestCount", "Throughput"}, {"com.bea:Type=JDBCDataSourceRuntime,*", "LeakedConnectionCount", "ActiveConnectionsCurrentCount", "ConnectionDelayTime", "LeakedConnectionCount", "NumAvailable", "ReserveRequestCount"}, {"com.bea:Type=JTARuntime,*", "ActiveTransactionsTotalCount", "SecondsActiveTotalCount"}, {"com.bea:Type=LogBroadcasterRuntime,*", "MessagesLogged"}, {"com.bea:Type=ServerRuntime,*", "OpenSocketsCurrentCount", "State"}, {"com.bea:Type=WebAppComponentRuntime,*", "OpenSessionsCurrentCount"}};
    private WLSMBeanServer mbs;
    private boolean timedOut;

    public ManagementRuntimeImageSource(WLSMBeanServer wLSMBeanServer) {
        this.mbs = wLSMBeanServer;
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        try {
            String[] stringArray;
            DescriptorManager descriptorManager = new DescriptorManager();
            Descriptor descriptor = descriptorManager.createDescriptorRoot(ManagementRuntimeImageBean.class);
            ManagementRuntimeImageBean managementRuntimeImageBean = (ManagementRuntimeImageBean)descriptor.getRootBean();
            ServerRuntimeStatisticsBean serverRuntimeStatisticsBean = managementRuntimeImageBean.getServerRuntimeStatistics();
            serverRuntimeStatisticsBean.setTotalRegisteredMBeansCount(this.mbs.getMBeanCount());
            for (String string : stringArray = this.mbs.getDomains()) {
                if (this.timedOut) break;
                Set set = this.mbs.queryMBeans(new ObjectName(string + ":*"), null);
                JMXDomainStatisticsBean jMXDomainStatisticsBean = serverRuntimeStatisticsBean.createJMXDomainStatistic();
                jMXDomainStatisticsBean.setDomainName(string);
                jMXDomainStatisticsBean.setCount(set.size());
            }
            this.populateMBeanStats(managementRuntimeImageBean);
            this.writeImageSourceBean(outputStream, descriptorManager, descriptor);
        }
        catch (Exception exception) {
            throw new ImageSourceCreationException((Throwable)exception);
        }
    }

    private void writeImageSourceBean(OutputStream outputStream, DescriptorManager descriptorManager, Descriptor descriptor) throws ImageSourceCreationException {
        if (this.timedOut) {
            return;
        }
        try {
            descriptorManager.writeDescriptorAsXML(descriptor, outputStream);
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException((Throwable)iOException);
        }
    }

    private void populateMBeanStats(ManagementRuntimeImageBean managementRuntimeImageBean) throws Exception {
        if (this.timedOut) {
            return;
        }
        ServerRuntimeStateBean serverRuntimeStateBean = managementRuntimeImageBean.getServerRuntimeState();
        for (String[] stringArray : METRICS_TABLE) {
            if (this.timedOut) break;
            this.queryValues(serverRuntimeStateBean, stringArray);
        }
    }

    public void timeoutImageCreation() {
        this.timedOut = true;
    }

    private void queryValues(ServerRuntimeStateBean serverRuntimeStateBean, String[] stringArray) throws Exception {
        ObjectName objectName = new ObjectName(stringArray[0]);
        Set set = this.mbs.queryMBeans(objectName, null);
        for (Object e : set) {
            if (this.timedOut) break;
            ObjectInstance objectInstance = (ObjectInstance)e;
            InstanceMetricBean instanceMetricBean = serverRuntimeStateBean.createInstanceMetric();
            instanceMetricBean.setInstanceName(objectInstance.getObjectName().getCanonicalName());
            String[] stringArray2 = this.copyAttributes(stringArray);
            AttributeList attributeList = this.mbs.getAttributes(objectInstance.getObjectName(), stringArray2);
            for (Object e2 : attributeList) {
                Attribute attribute = (Attribute)e2;
                String string = this.getAttributeType(objectInstance.getObjectName(), attribute.getName());
                MetricBean metricBean = instanceMetricBean.createMBeanMetric();
                metricBean.setAttributeName(attribute.getName());
                metricBean.setAttributeType(string);
                metricBean.setAttributeValue(attribute.getValue().toString());
            }
        }
    }

    private String[] copyAttributes(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, Math.min(stringArray.length - 1, stringArray2.length));
        return stringArray2;
    }

    private String getAttributeType(ObjectName objectName, String string) throws Exception {
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray = this.mbs.getMBeanInfo(objectName).getAttributes()) {
            if (!mBeanAttributeInfo.getName().equals(string)) continue;
            return mBeanAttributeInfo.getType();
        }
        return String.class.getName();
    }
}

