/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.runtime.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.management.configuration.JMXMBean;
import weblogic.management.jmx.JMXLogger;
import weblogic.management.mbeanservers.domainruntime.MBeanServerConnectionManagerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.protocol.ServerURL;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.EnableListenersIfAdminChannelAbsentService;

public abstract class RegisterWithDomainRuntimeService
extends AbstractServerService {
    private static final String JNDI = "/jndi/";
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXRuntime");
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static boolean doNotPingPort = Boolean.getBoolean("weblogic.management.failover.doNotPingAdminPort");
    JMXConnector domainRuntimeConnector = null;
    RuntimeAccess runtimeAccess;

    public void start() throws ServiceFailureException {
        this.runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (!this.isEnabled() || this.runtimeAccess.isAdminServer()) {
            if (debug.isDebugEnabled()) {
                debug.debug("Runtime MBeanServer Disabledweblogic.management.mbeanservers.runtime");
            }
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("Starting MBeanServer weblogic.management.mbeanservers.runtime");
        }
        this.notifyDomainRuntime();
    }

    public void stop() throws ServiceFailureException {
        block4: {
            if (this.runtimeAccess == null) {
                this.runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            }
            if (!this.isEnabled() || this.runtimeAccess.isAdminServer()) {
                return;
            }
            try {
                ConnectMonitorFactory.unregister();
            }
            catch (Throwable throwable) {
                if (!debug.isDebugEnabled()) break block4;
                debug.debug("Unable to unregister disconnect listener");
            }
        }
    }

    private boolean isEnabled() {
        JMXMBean jMXMBean = this.runtimeAccess.getDomain().getJMX();
        return jMXMBean.isRuntimeMBeanServerEnabled() && (jMXMBean.isDomainMBeanServerEnabled() || jMXMBean.isManagementEJBEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDomainRuntime() {
        MBeanServerConnection mBeanServerConnection;
        if (debug.isDebugEnabled()) {
            debug.debug("Contacting Domain MBeanServer " + MBeanServerConnectionManagerMBean.OBJECT_NAME);
        }
        if ((mBeanServerConnection = this.getDomainMBeanServerConnection()) == null) {
            return;
        }
        try {
            ObjectName objectName = new ObjectName(MBeanServerConnectionManagerMBean.OBJECT_NAME);
            mBeanServerConnection.invoke(objectName, "notifyNewMBeanServer", new Object[]{ManagementService.getRuntimeAccess(kernelId).getServerName()}, new String[]{String.class.getName()});
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            JMXLogger.logExceptionEstablishingJMXConnectivity((Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            JMXLogger.logExceptionEstablishingJMXConnectivity((Throwable)instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            JMXLogger.logExceptionEstablishingJMXConnectivity((Throwable)mBeanException);
        }
        catch (ReflectionException reflectionException) {
            JMXLogger.logExceptionEstablishingJMXConnectivity((Throwable)reflectionException);
        }
        catch (IOException iOException) {
            JMXLogger.logExceptionEstablishingJMXConnectivity((Throwable)iOException);
        }
        finally {
            try {
                this.domainRuntimeConnector.close();
                this.domainRuntimeConnector = null;
            }
            catch (IOException iOException) {
                debug.debug("Failed to close DomainMBeanServerConnection", (Throwable)iOException);
            }
        }
    }

    private MBeanServerConnection getDomainMBeanServerConnection() {
        Object object;
        JMXServiceURL jMXServiceURL = null;
        String string = ManagementService.getRuntimeAccess(kernelId).getAdminServerName();
        String string2 = null;
        try {
            string2 = URLManager.findAdministrationURL(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string3 = "<JMXServiceURL:null>";
            JMXLogger.logAdminstrationServerNotAvailable((String)string, (String)string3);
            string2 = ManagementService.getPropertyService(kernelId).getAdminHost();
            if (!Boolean.getBoolean("weblogic.management.failover.useSpecifiedProtocol") && string2.startsWith("http")) {
                string2 = "t3" + string2.substring(4);
            }
            this.registerForDisconnects(string2);
            return null;
        }
        try {
            this.registerForDisconnects(string2);
            object = new ServerURL(string2);
            jMXServiceURL = new JMXServiceURL(object.getProtocol(), object.getHost(), object.getPort(), "/jndi/weblogic.management.mbeanservers.domainruntime");
        }
        catch (MalformedURLException malformedURLException) {
            JMXLogger.logExceptionEstablishingJMXConnectivity((Throwable)malformedURLException);
            return null;
        }
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            int n = ManagementService.getRuntimeAccess(kernelId).getDomain().getJMX().getInvocationTimeoutSeconds();
            if (n > 0) {
                hashtable.put("jmx.remote.x.request.waiting.timeout", new Long(n * 1000));
            }
            if (string2 != null && string2.length() > 0) {
                hashtable.put("java.naming.provider.url", string2);
            }
            this.domainRuntimeConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
            object = this.domainRuntimeConnector.getMBeanServerConnection();
        }
        catch (IOException iOException) {
            String string4 = jMXServiceURL != null ? jMXServiceURL.toString() : "<JMXServiceURL:null>";
            JMXLogger.logUnableToEstablishJMXConnectivity((String)string, (String)string4, (Throwable)iOException);
            return null;
        }
        JMXLogger.logEstablishedJMXConnectivity((String)string, (String)jMXServiceURL.toString());
        return object;
    }

    private void registerForDisconnects(String string) {
        block10: {
            ArrayList<Environment> arrayList = new ArrayList<Environment>();
            Environment environment = new Environment();
            environment.setProviderUrl(string);
            arrayList.add(environment);
            String string2 = ManagementService.getPropertyService(kernelId).getAdminHost();
            String[] stringArray = URLManager.findAllAddressesForHost(string2);
            if (debug.isDebugEnabled()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    debug.debug("In register for alternate disconnects - adminURL[" + i + "] = " + stringArray[i]);
                }
            }
            if (stringArray != null && stringArray.length > 1) {
                String string3 = this.getHostFromURL(string);
                String[] stringArray2 = URLManager.findAllAddressesForHost(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (!Boolean.getBoolean("weblogic.management.failover.useSpecifiedProtocol") && string4.startsWith("http")) {
                        string4 = "t3" + string4.substring(4);
                    }
                    if (this.getHostFromURL(stringArray[i]).equalsIgnoreCase(string3)) continue;
                    boolean bl = false;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (!this.getHostFromURL(stringArray[i]).equalsIgnoreCase(this.getHostFromURL(stringArray2[j]))) continue;
                        bl = true;
                        break;
                    }
                    if (bl || this.isReachable(string4)) continue;
                    environment = new Environment();
                    environment.setProviderUrl(string4);
                    arrayList.add(environment);
                }
            }
            try {
                if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Registering for disconnects for " + string);
                    }
                    ConnectMonitorFactory.registerForever(arrayList);
                }
            }
            catch (Throwable throwable) {
                if (!debug.isDebugEnabled()) break block10;
                debug.debug("Unable to register disconnect listener for " + string);
            }
        }
    }

    private String getHostFromURL(String string) {
        try {
            ServerURL serverURL = new ServerURL(string);
            return serverURL.getHost();
        }
        catch (Exception exception) {
            if (debug.isDebugEnabled()) {
                debug.debug("Error getting host from URL " + exception.getMessage());
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReachable(String string) {
        if (doNotPingPort) {
            return false;
        }
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            ServerURL serverURL = new ServerURL(string);
            String string2 = serverURL.getHost();
            int n = serverURL.getPort();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string2), n);
            abstractInterruptibleChannel = SocketChannel.open();
            Socket socket = ((SocketChannel)abstractInterruptibleChannel).socket();
            socket.connect(inetSocketAddress, 1000);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (debug.isDebugEnabled()) {
                debug.debug("Error pinging socket " + exception.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean doEarly() {
        return EnableListenersIfAdminChannelAbsentService.isOpenForManagementConnectionsEarly();
    }
}

