/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.runtime.internal;

import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.OperationsException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSourceNotFoundException;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMXMBean;
import weblogic.management.jmx.ObjectNameManager;
import weblogic.management.jmx.ObjectSecurityManager;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptor;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.jmx.modelmbean.WLSModelMBeanFactory;
import weblogic.management.mbeanservers.internal.JMXContextInterceptor;
import weblogic.management.mbeanservers.internal.MBeanServerServiceBase;
import weblogic.management.mbeanservers.internal.RuntimeMBeanAgent;
import weblogic.management.mbeanservers.internal.SecurityInterceptor;
import weblogic.management.mbeanservers.internal.WLSObjectNameManager;
import weblogic.management.mbeanservers.internal.WLSObjectSecurityManagerImpl;
import weblogic.management.mbeanservers.runtime.internal.DiagnosticSupportService;
import weblogic.management.mbeanservers.runtime.internal.ManagementRuntimeImageSource;
import weblogic.management.mbeanservers.runtime.internal.RuntimeServiceMBeanImpl;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServiceFailureException;

public class RuntimeServerService
extends MBeanServerServiceBase {
    private static final String MANAGEMENT_RUNTIME_SOURCE = "ManagementRuntimeImageSource";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXRuntime");
    RuntimeAccess runtimeAccess;
    static DiagnosticSupportService diagnosticSupportService = null;
    private ManagementRuntimeImageSource imageSource;

    static void setSupportService(DiagnosticSupportService diagnosticSupportService) {
        RuntimeServerService.diagnosticSupportService = diagnosticSupportService;
    }

    private ObjectNameManager getObjectNameManager() {
        if (diagnosticSupportService != null) {
            return diagnosticSupportService.getObjectNameManager();
        }
        return new WLSObjectNameManager(ManagementService.getRuntimeAccess(kernelId).getDomainName());
    }

    public void start() throws ServiceFailureException {
        block13: {
            WLSMBeanServer wLSMBeanServer;
            if (!this.isEnabled()) {
                if (debug.isDebugEnabled()) {
                    debug.debug("Runtime MBeanServer Disabledweblogic.management.mbeanservers.runtime");
                }
                return;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("Starting MBeanServer weblogic.management.mbeanservers.runtime");
            }
            this.runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            if (this.isPlatformMBeanServerUsed()) {
                System.setProperty("javax.management.builder.initial", "weblogic.management.jmx.mbeanserver.WLSMBeanServerBuilder");
                if (debug.isDebugEnabled()) {
                    debug.debug("Set system property javax.management.builder.initial=weblogic.management.jmx.mbeanserver.WLSMBeanServerBuilder");
                }
            }
            MBeanServer mBeanServer = null;
            ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
            if (arrayList.size() != 0 || this.isPlatformMBeanServerEnabled() || this.isPlatformMBeanServerUsed()) {
                mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.isPlatformMBeanServerUsed()) {
                if (mBeanServer != null && !(mBeanServer instanceof WLSMBeanServer)) {
                    ManagementLogger.logPlatformMBeanServerInitFailure();
                    this.initialize("weblogic.management.mbeanservers.runtime", null, null);
                } else {
                    if (mBeanServer instanceof WLSMBeanServer) {
                        wLSMBeanServer = (WLSMBeanServer)mBeanServer;
                        wLSMBeanServer.setDefaultDomainName(this.runtimeAccess.getDomainName());
                    }
                    this.initialize("weblogic.management.mbeanservers.runtime", null, mBeanServer);
                }
            } else {
                this.initialize("weblogic.management.mbeanservers.runtime", null, null);
            }
            wLSMBeanServer = (WLSMBeanServer)this.getMBeanServer();
            SecurityInterceptor securityInterceptor = new SecurityInterceptor(wLSMBeanServer, "weblogic.management.mbeanservers.runtime");
            wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)securityInterceptor);
            JMXContextInterceptor jMXContextInterceptor = new JMXContextInterceptor();
            wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)jMXContextInterceptor);
            new RuntimeServiceMBeanImpl(this.runtimeAccess);
            wLSMBeanServer.setFirstAccessCallback(this.createAccessCallback());
            ManagementService.initializeRuntimeMBeanServer(kernelId, (MBeanServer)wLSMBeanServer);
            super.start();
            try {
                this.imageSource = new ManagementRuntimeImageSource(wLSMBeanServer);
                ImageManager.getInstance().registerImageSource(MANAGEMENT_RUNTIME_SOURCE, this.imageSource);
            }
            catch (Exception exception) {
                if (!debug.isDebugEnabled()) break block13;
                debug.debug("Caught exception registering Diagnostics image source for RuntimeService", (Throwable)exception);
            }
        }
    }

    private void registerAllMBeans() {
        try {
            DomainMBean domainMBean = this.runtimeAccess.getDomain();
            ObjectNameManager objectNameManager = this.getObjectNameManager();
            WLSModelMBeanContext wLSModelMBeanContext = new WLSModelMBeanContext(this.getMBeanServer(), objectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            wLSModelMBeanContext.setRecurse(false);
            wLSModelMBeanContext.setVersion("12.0.0.0");
            wLSModelMBeanContext.setReadOnly(false);
            new RuntimeMBeanAgent(wLSModelMBeanContext, this.runtimeAccess);
            this.registerTypeService(wLSModelMBeanContext);
            WLSModelMBeanContext wLSModelMBeanContext2 = new WLSModelMBeanContext(this.getMBeanServer(), objectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            wLSModelMBeanContext2.setRecurse(true);
            wLSModelMBeanContext2.setVersion("12.0.0.0");
            wLSModelMBeanContext2.setReadOnly(true);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)domainMBean, (WLSModelMBeanContext)wLSModelMBeanContext2);
        }
        catch (OperationsException operationsException) {
            throw new Error(operationsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new Error(mBeanRegistrationException);
        }
    }

    private WLSMBeanServer.FirstAccessCallback createAccessCallback() {
        return new WLSMBeanServer.FirstAccessCallback(){

            public void accessed(MBeanServer mBeanServer) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                            public Object run() {
                                RuntimeServerService.this.registerAllMBeans();
                                return null;
                            }
                        });
                        return null;
                    }
                });
            }
        };
    }

    private boolean isPlatformMBeanServerEnabled() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().getJMX().isPlatformMBeanServerEnabled();
    }

    private boolean isPlatformMBeanServerUsed() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().getJMX().isPlatformMBeanServerUsed();
    }

    private boolean isEnabled() {
        JMXMBean jMXMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getJMX();
        return jMXMBean.isRuntimeMBeanServerEnabled() || jMXMBean.isDomainMBeanServerEnabled() || jMXMBean.isManagementEJBEnabled();
    }

    public void stop() throws ServiceFailureException {
        block3: {
            if (!this.isEnabled()) {
                return;
            }
            try {
                ImageManager.getInstance().unregisterImageSource(MANAGEMENT_RUNTIME_SOURCE);
            }
            catch (ImageSourceNotFoundException imageSourceNotFoundException) {
                if (!debug.isDebugEnabled()) break block3;
                debug.debug("Caught exception unregistering RuntimeService image source:", (Throwable)((Object)imageSourceNotFoundException));
            }
        }
        super.stop();
    }
}

