/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.runtime.internal;

import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.mbeanservers.Service;
import weblogic.management.mbeanservers.internal.RuntimeServiceImpl;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;

public class RuntimeServiceMBeanImpl
extends RuntimeServiceImpl
implements RuntimeServiceMBean {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXRuntime");
    private final RuntimeAccess runtime;
    private final String serverName;
    private final DomainMBean domain;
    private final ServerMBean server;
    private final ServerRuntimeMBean serverRuntime;

    RuntimeServiceMBeanImpl(RuntimeAccess runtimeAccess) {
        super("RuntimeService", RuntimeServiceMBean.class.getName(), null);
        this.runtime = runtimeAccess;
        this.domain = this.runtime.getDomain();
        this.server = this.runtime.getServer();
        this.serverName = this.runtime.getServerName();
        this.serverRuntime = this.runtime.getServerRuntime();
    }

    public DomainMBean getDomainConfiguration() {
        return this.domain;
    }

    public ServerMBean getServerConfiguration() {
        return this.server;
    }

    public String getServerName() {
        return this.serverName;
    }

    public ServerRuntimeMBean getServerRuntime() {
        return this.serverRuntime;
    }

    public RuntimeMBean findRuntime(DescriptorBean descriptorBean) {
        return this.runtime.lookupRuntime(descriptorBean);
    }

    public DescriptorBean findConfiguration(RuntimeMBean runtimeMBean) {
        if (debug.isDebugEnabled()) {
            debug.debug("Looking up configuration for a " + runtimeMBean);
        }
        DescriptorBean descriptorBean = this.runtime.lookupConfigurationBean(runtimeMBean);
        if (debug.isDebugEnabled()) {
            debug.debug("Found " + descriptorBean);
        }
        return descriptorBean;
    }

    public Service findService(String string, String string2) {
        return (Service)this.runtime.findService(string, string2);
    }

    public Service[] getServices() {
        weblogic.management.provider.Service[] serviceArray = this.runtime.getRootServices();
        Service[] serviceArray2 = new Service[serviceArray.length];
        System.arraycopy(serviceArray, 0, serviceArray2, 0, serviceArray.length);
        return serviceArray2;
    }
}

