/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.runtime.internal;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.mbeanservers.internal.ServiceImplBeanInfo;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;
import weblogic.management.mbeanservers.runtime.internal.RuntimeServiceMBeanImpl;
import weblogic.management.runtime.RuntimeMBean;

public class RuntimeServiceMBeanImplBeanInfo
extends ServiceImplBeanInfo {
    public static Class INTERFACE_CLASS = RuntimeServiceMBean.class;

    public RuntimeServiceMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public RuntimeServiceMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = RuntimeServiceMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "9.0.0.0");
        beanDescriptor.setValue("package", "weblogic.management.mbeanservers.runtime.internal");
        String string = new String("<p>Provides an entry point for navigating the hierarchy of WebLogic Server runtime MBeans and active configuration MBeans for the current server.</p>  <p>Each server instance in a domain provides its own instance of this MBean.</p>  <p>The <code>javax.management.ObjectName</code> of this MBean is \"<code>com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean</code>\".</p>  <p>This is the only object name that a JMX client needs to navigate the hierarchy available from this MBean. To start navigating, a JMX client invokes the <code>javax.management.MBeanServerConnection.getAttribute()</code> method and passes the following as parameters:</p>  <ul> <li> <p>The <code>ObjectName</code> of this service MBean</p> </li>  <li> <p>A <code>String</code> representation for the name of an attribute in this MBean that contains the root of an MBean hierarchy</p> </li> </ul>  <p>This method call returns the <code>ObjectName</code> for the root MBean. To access MBeans below the root, the JMX client passes the root MBean's <code>ObjectName</code> and the name of a root MBean attribute that contains a child MBean to the <code>MBeanServerConnection.getAttribute()</code> method. This method call returns the <code>ObjectName</code> of the child MBean.</p>  <p>For example:<br clear=\"none\" /> <code>ObjectName rs = new ObjectName(\"com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean\");</code> <br clear=\"none\" /> <code>// Get the ObjectName of the server's ServerRuntimeMBean by getting the value<br clear=\"none\" /> // of the RuntimeServiceMBean ServerRuntime attribute<br clear=\"none\" /> ObjectName serverrt =<br clear=\"none\" /> (ObjectName) MBeanServerConnection.getAttribute(rs,\"ServerRuntime\");<br clear=\"none\" /> // Get the ObjectNames for all ApplicationRuntimeMBeans on the server by getting<br clear=\"none\" /> // the value of the ServerRuntimeMBean ApplicationRuntimes attribute<br clear=\"none\" /> ObjectName[] apprt =<br clear=\"none\" /> (ObjectName[]) MBeanServerConnection.getAttribute(serverrt, \"ApplicationRuntimes\");</code></p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("rolePermitAll", Boolean.TRUE);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("DomainConfiguration")) {
            string2 = "getDomainConfiguration";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DomainConfiguration", RuntimeServiceMBean.class, string2, string);
            map.put("DomainConfiguration", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains the active <code>DomainMBean</code> for the current WebLogic Server domain.</p>  <p>Get this MBean to learn about the active configuration of all servers and resources in the domain.</p>  <dl> <dt>Note:</dt>  <dd> <p>The <code>DomainMBean</code> that can be accessed from this (<code>RuntimeServiceMBean</code>) MBean attribute represents the active configuration of the domain and cannot be edited. The <i>pending</i> <code>DomainMBean</code>, which can be edited, is available only from the Edit MBean Server and its <code>EditServiceMBean</code>.</p> </dd> </dl> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Name", RuntimeServiceMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>A unique key that WebLogic Server generates to identify the current instance of this MBean type.</p>  <p>For a singleton, such as <code>DomainRuntimeServiceMBean</code>, this key is often just the bean's short class name.</p> ");
        }
        if (!map.containsKey("ParentAttribute")) {
            string2 = "getParentAttribute";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentAttribute", RuntimeServiceMBean.class, string2, string);
            map.put("ParentAttribute", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the attribute of the parent that refers to this bean</p> ");
        }
        if (!map.containsKey("ParentService")) {
            string2 = "getParentService";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ParentService", RuntimeServiceMBean.class, string2, string);
            map.put("ParentService", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean that created the current MBean instance.</p>  <p>In the data model for WebLogic Server MBeans, an MBean that creates another MBean is called a <i>parent</i>. MBeans at the top of the hierarchy have no parents.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("Path")) {
            string2 = "getPath";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Path", RuntimeServiceMBean.class, string2, string);
            map.put("Path", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the path to the bean relative to the reoot of the heirarchy of services</p> ");
        }
        if (!map.containsKey("ServerConfiguration")) {
            string2 = "getServerConfiguration";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerConfiguration", RuntimeServiceMBean.class, string2, string);
            map.put("ServerConfiguration", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains the active <code>ServerMBean</code> for the current server instance.</p>  <p>Get this MBean to learn about the configuration of the current server, including any values that were overridden by the server's startup command.</p>  <dl> <dt>Note:</dt>  <dd> <p>The <code>ServerMBean</code> that can be accessed from this (<code>RuntimeServiceMBean</code>) MBean attribute represents the active configuration of the server and cannot be edited.</p> </dd> </dl> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("ServerName")) {
            string2 = "getServerName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerName", RuntimeServiceMBean.class, string2, string);
            map.put("ServerName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the current WebLogic Server instance as defined in the domain configuration.</p> ");
        }
        if (!map.containsKey("ServerRuntime")) {
            string2 = "getServerRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerRuntime", RuntimeServiceMBean.class, string2, string);
            map.put("ServerRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Contains <code>ServerRuntimeMBean</code> for the current server.</p>  <p>The <code>ServerRuntimeMBean</code> is the root of runtime MBean hierarchy for this server instance. Each runtime MBean in the hierarchy provides access to the server's status and control as well as statistical information about any deployed or configured service on the server.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("Services")) {
            string2 = "getServices";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Services", RuntimeServiceMBean.class, string2, string);
            map.put("Services", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns all the services that do not have a parent i.e all the root services ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("Type")) {
            string2 = "getType";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Type", RuntimeServiceMBean.class, string2, string);
            map.put("Type", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The MBean type for this instance. This is useful for MBean types that support multiple intances, such as <code>ActivationTaskMBean</code>.</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = RuntimeServiceMBean.class.getMethod("findRuntime", DescriptorBean.class);
        Object object = new ParameterDescriptor[]{RuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"configurationMBean", null)};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Enables a JMX client to retrieve monitoring statistics for a specified resource on the current server. To use this operation, a JMX client passes a single configuration MBean. The operation returns the corresponding runtime MBean for the resource on the current server.</p>  <p>For example, given the <code>JMSServerMBean</code> for a JMS server named \"JS1\" on a the current server, this operation returns the <code>JMSServerRuntimeMBean</code> for \"JS1.\"</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = RuntimeServiceMBean.class.getMethod("findConfiguration", RuntimeMBean.class);
        object = new ParameterDescriptor[]{RuntimeServiceMBeanImplBeanInfo.createParameterDescriptor((String)"runtimeMBean", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Enables a JMX client to retrieve configuration data for a specific instance of a resource. To use this operation, a JMX client passes a single runtime MBean and the operation returns the active configuration MBean for the resource.</p>  <p>For example, given the <code>JMSServerRuntimeMBean</code> for a JMS server named \"JS1\" on the current server instance, this operation returns the active <code>JMSServerMBean</code> for \"JS1.\"</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = RuntimeServiceMBean.class.getMethod("findService", String.class, String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Enables client to retrieve a specific named service </p> ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

