/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider;

import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.logging.Loggable;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ConfigLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.URLManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class MSIService
extends AbstractServerService
implements ConnectListener {
    private static MSIService singleton;
    private static DebugLogger debugLogger;
    private boolean adminServerAvailable = true;
    private boolean registered = false;
    private String cmdURL = null;
    private static AuthenticatedSubject kernelId;

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
    }

    public void start() throws ServiceFailureException {
    }

    public static MSIService getMSIService() {
        return singleton;
    }

    public MSIService() {
        if (singleton != null) {
            throw new AssertionError((Object)"MSIService already initialized");
        }
        singleton = this;
    }

    public synchronized void doPostParseInitialization(DomainMBean domainMBean) throws ServiceFailureException {
        if (this.isAdminServerAvailable()) {
            return;
        }
        this.cmdURL = ManagementService.getPropertyService(kernelId).getAdminHost();
        String string = ManagementService.getPropertyService(kernelId).getServerName();
        ServerMBean serverMBean = domainMBean.lookupServer(string);
        if (serverMBean == null) {
            ServerMBean[] serverMBeanArray = domainMBean.getServers();
            String string2 = "{";
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                if (i > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + serverMBeanArray[i].getName();
            }
            string2 = string2 + "}";
            Loggable loggable = ManagementLogger.logServerNameDoesNotExistLoggable((String)string, (String)string2);
            loggable.log();
            throw new ServiceFailureException(loggable.getMessage());
        }
        if (!serverMBean.isManagedServerIndependenceEnabled()) {
            Loggable loggable = ConfigLogger.logMSINotEnabledLoggable((String)string);
            loggable.log();
            throw new ServiceFailureException(loggable.getMessage());
        }
        ConfigLogger.logStartingIndependentManagerServer();
        ConnectMonitorFactory.getConnectMonitor().addConnectListener((ConnectListener)this);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added connect listener");
        }
    }

    public synchronized void setAdminServerAvailable(boolean bl) {
        this.adminServerAvailable = bl;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Set admin server available to " + bl);
        }
    }

    public synchronized boolean isAdminServerAvailable() {
        return this.adminServerAvailable;
    }

    public synchronized void registerForReconnectToAdminServer() throws ServiceFailureException {
        Object object;
        if (this.registered) {
            return;
        }
        this.registered = true;
        String[] stringArray = this.getAllAdminBinaryURLs();
        ArrayList<Environment> arrayList = new ArrayList<Environment>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = new Environment();
            ((Environment)object).setProperty("weblogic.jndi.requestTimeout", Long.getLong("weblogic.jndi.MSIlookupRequestTimeout", 0L));
            ((Environment)object).setProviderUrl(stringArray[i]);
            arrayList.add((Environment)object);
        }
        if (!arrayList.isEmpty()) {
            try {
                ConnectMonitorFactory.registerForever(arrayList);
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Registered connect monitor for admin server");
                }
            }
            catch (NamingException namingException) {
                object = ((Environment)arrayList.get(0)).getProviderUrl();
                if (arrayList.size() > 1) {
                    object = "{ ";
                    for (Environment environment : arrayList) {
                        object = (String)object + environment.getProviderUrl() + " ";
                    }
                    object = (String)object + "}";
                }
                Loggable loggable = ConfigLogger.logErrorConnectingAdminServerForHomeLoggable((String)object, (Exception)namingException);
                loggable.log();
                throw new ServiceFailureException(loggable.getMessage(), (Throwable)namingException);
            }
        }
    }

    private String[] getAllAdminBinaryURLs() {
        int n;
        String string = null;
        String string2 = ManagementService.getPropertyService(kernelId).getAdminBinaryURL();
        if (string2 != null && (n = string2.indexOf("://")) != -1) {
            string = string2.substring(0, n);
        }
        ManagementService.getPropertyService(kernelId);
        String[] stringArray = PropertyService.getAllAdminHttpUrls();
        if (stringArray == null) {
            stringArray = new String[]{string2};
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                String string4 = string3.substring(0, string3.indexOf("://"));
                stringArray[i] = string != null ? string3.replace(string4 + "://", string + "://") : URLManager.normalizeToAdminProtocol(string3);
            }
        }
        return stringArray;
    }

    public boolean isAdminRequiredButNotSpecifiedOnBoot() {
        if (this.isAdminServerAvailable()) {
            return false;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ServerMBean serverMBean = runtimeAccess.getDomain().lookupServer(runtimeAccess.getAdminServerName());
        boolean bl = ChannelHelper.isAdminChannelEnabled(serverMBean);
        String string = this.getAdminURL();
        return !bl && string != null;
    }

    private String getAdminURL() {
        try {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            return URLManager.findURL(runtimeAccess.getAdminServerName(), ProtocolHandlerAdmin.PROTOCOL_ADMIN);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public void onConnect(ConnectEvent connectEvent) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("onConnect event, server = " + connectEvent.getServerName());
        }
        ManagementService.getPropertyService(kernelId).waitForChannelServiceReady();
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess == null) {
            return;
        }
        if (!connectEvent.getServerName().equals(runtimeAccess.getAdminServerName())) {
            return;
        }
        if (this.isAdminRequiredButNotSpecifiedOnBoot()) {
            String string = URLManager.normalizeToHttpProtocol(this.getAdminURL());
            ConfigLogger.logAdminRequiredButNotSpecified((String)this.cmdURL, (String)string);
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("onConnect setting admin server available.");
        }
        this.setAdminServerAvailable(true);
        ConnectMonitorFactory.getConnectMonitor().removeConnectListener((ConnectListener)this);
    }

    static {
        debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

