/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider;

import javax.management.MBeanServer;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.PropertyService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.provider.core.ManagementCoreService;
import weblogic.security.acl.internal.AuthenticatedSubject;

public class ManagementService
extends ManagementCoreService {
    private static RuntimeAccess runtimeAccess;
    private static DomainAccess domainAccess;
    private static MBeanServer runtimeMBeanServer;
    private static MBeanServer domainRuntimeMBeanServer;

    public static RuntimeAccess getRuntimeAccess(AuthenticatedSubject authenticatedSubject) {
        assert (runtimeAccess != null) : "The ManagementService has not been initialized & runtimeAccess is null";
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        return runtimeAccess;
    }

    public static DomainAccess getDomainAccess(AuthenticatedSubject authenticatedSubject) {
        assert (domainAccess != null);
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        return domainAccess;
    }

    public static void initializeRuntime(RuntimeAccess runtimeAccess) {
        if (ManagementService.runtimeAccess != null) {
            throw new AssertionError((Object)"The managment service can only be initialized once");
        }
        ManagementService.runtimeAccess = runtimeAccess;
    }

    public static boolean isRuntimeAccessInitialized() {
        return runtimeAccess != null;
    }

    public static void initializeDomain(DomainAccess domainAccess) {
        if (ManagementService.domainAccess != null) {
            throw new AssertionError((Object)"The domain access can only be initialized once");
        }
        ManagementService.domainAccess = domainAccess;
    }

    public static void initializeRuntimeMBeanServer(AuthenticatedSubject authenticatedSubject, MBeanServer mBeanServer) {
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        if (runtimeMBeanServer != null) {
            throw new AssertionError((Object)"MBeanServer may not be reset.");
        }
        javaURLContextFactory.setRuntimeMBeanServer(mBeanServer);
        runtimeMBeanServer = mBeanServer;
    }

    public static void initializeDomainRuntimeMBeanServer(AuthenticatedSubject authenticatedSubject, MBeanServer mBeanServer) {
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        if (domainRuntimeMBeanServer != null) {
            throw new AssertionError((Object)"DomainRuntime MBeanServer may not be reset.");
        }
        domainRuntimeMBeanServer = mBeanServer;
        javaURLContextFactory.setDomainRuntimeMBeanServer(mBeanServer);
    }

    public static MBeanServer getRuntimeMBeanServer(AuthenticatedSubject authenticatedSubject) {
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        return runtimeMBeanServer;
    }

    public static MBeanServer getDomainRuntimeMBeanServer(AuthenticatedSubject authenticatedSubject) {
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        return domainRuntimeMBeanServer;
    }

    public static PropertyService getPropertyService(AuthenticatedSubject authenticatedSubject) {
        return PropertyService.getPropertyService(authenticatedSubject);
    }
}

