/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.EditAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;

public class ManagementServiceRestricted {
    private static EditAccess editAccess;
    private static final Set allowedClasses;

    public static EditAccess getEditAccess(AuthenticatedSubject authenticatedSubject) {
        assert (editAccess != null) : "EditAccess is not initialized";
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        ManagementServiceRestricted.checkAccess(new Throwable());
        return editAccess;
    }

    public static void setEditAccess(EditAccess editAccess) {
        if (ManagementServiceRestricted.editAccess != null) {
            throw new AssertionError((Object)"Edit Access Can only be initialized once.");
        }
        ManagementServiceRestricted.editAccess = editAccess;
    }

    private static void checkAccess(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length < 2) {
            return;
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[1];
        String string = stackTraceElement.getClassName();
        if (!allowedClasses.contains(string)) {
            throw new Error("Access to EditAccess is restricted. Email to wls-oam-dev@bea.com for details");
        }
    }

    static {
        allowedClasses = new HashSet<String>(Arrays.asList("weblogic.management.mbeanservers.compatibility.internal.CompatibilityMBeanServerService", "weblogic.deploy.api.internal.utils.JMXDeployerHelper", "weblogic.deploy.internal.adminserver.ConfigChangesHandler", "weblogic.deploy.internal.adminserver.EditAccessHelper", "weblogic.management.mbeanservers.domainruntime.internal.DomainRuntimeServerService$SINGLETON", "weblogic.management.mbeanservers.domainruntime.internal.DomainRuntimeServiceMBeanImpl$SINGLETON", "weblogic.management.mbeanservers.edit.internal.EditLockInterceptor", "weblogic.management.mbeanservers.edit.internal.EditServerService", "weblogic.cluster.migration.management.MigratableServiceCoordinatorRuntime", "weblogic.cluster.migration.management.MigrationTask", "weblogic.management.provider.internal.ConfigImageSource", "weblogic.management.provider.internal.EditAccessService", "weblogic.management.provider.internal.TestEditAccess", "weblogic.management.provider.internal.TestLockManager", "weblogic.management.deploy.ApplicationsDirPoller"));
    }
}

