/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import weblogic.management.DomainDir;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.common.StartupConfig;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.URLManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.ServerAuthenticate;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.servlet.internal.ProtocolHandlerHTTP;
import weblogic.utils.net.InetAddressHelper;

public class PropertyService
extends AbstractServerService {
    private static PropertyService singleton;
    public static final String ADMIN_ANONYMOUSADMINLOOKUPENABLED_PROP = "weblogic.management.anonymousAdminLookupEnabled";
    public static final String ADMIN_CLEAR_TEXT_CREDENTIAL_ACCESS_ENABLED = "weblogic.management.clearTextCredentialAccessEnabled";
    public static final String ADMIN_IACACHETTL_PROP = "weblogic.security.identityAssertionTTL";
    public static final String ADMIN_SSLENFORCECONSTRAINT_PROP = "weblogic.security.SSL.enforceConstraints";
    public static final String ADMIN_SSLTRUSTCA_PROP = "weblogic.security.SSL.trustedCAKeyStore";
    public static final String ADMIN_SSL_MINIMUM_PROTOCOL_VERSION_PROP = "weblogic.security.SSL.minimumProtocolVersion";
    public static final String ADMIN_SSLVERSION_PROP = "weblogic.security.SSL.protocolVersion";
    public static final String SECURITY_FW_DELEGATE_CLASS_NAME_PROP = "weblogic.security.SecurityServiceManagerDelegate";
    public static final String SECURITY_FW_SUBJECT_MANAGER_CLASS_NAME_PROP = "weblogic.security.SubjectManager";
    public static final String ADMIN_HOST_PROP = "weblogic.management.server";
    public static final String ADMIN_USERNAME_PROP = "weblogic.management.username";
    public static final String ADMIN_PASSWORD_PROP = "weblogic.management.password";
    public static final String LEGAL_BYPASS_ON_PARSING_PROP = "weblogic.mbeanLegalClause.ByPass";
    public static final String MBEAN_AUDITING_ENABLED_PROP = "weblogic.AdministrationMBeanAuditingEnabled";
    public static final String OLD_ADMIN_HOST_PROP = "weblogic.admin.host";
    public static final String ADMIN_PKPASSWORD_PROP = "weblogic.management.pkpassword";
    public static final String ADMIN_HIERARCHY_GROUP_PROP = "weblogic.security.hierarchyGroupMemberships";
    public static final String LDAP_DELEGATE_POOL_SIZE_PROP = "weblogic.security.providers.authentication.LDAPDelegatePoolSize";
    public static final String ADMIN_AUDITLOG_DIR = "weblogic.security.audit.auditLogDir";
    public static final String JMX_REMOTE_REQUEST_TIMEOUT = "weblogic.management.jmx.remote.requestTimeout";
    public static final String CONVERT_SECURITY_EXTENSION_SCHEMA = "weblogic.management.convertSecurityExtensionSchema";
    private static final AuthenticatedSubject KERNEL_ID;
    private static String adminHost;
    private String serverName = "myserver";
    boolean serverNameIsSet = false;
    private static boolean isChannelServiceReady;
    private String userName = null;
    private String password = null;
    private String pkpassword = null;
    private URL adminURL;
    private String adminBinaryURL = null;
    private boolean isAdminServer = false;
    private boolean securityInitialized = false;

    private void checkSecurityInitialized() {
        if (!this.securityInitialized) {
            if (this.serverNameIsSet) {
                this.initializeSecurityProperties(false);
            } else {
                throw new AssertionError((Object)"Security required before it is initialized");
            }
        }
    }

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
    }

    public void start() throws ServiceFailureException {
        this.initializeServerName();
        this.initializeAdminHost();
        if (!this.serverNameIsSet && !this.isAdminServer()) {
            this.serverName = "myserver";
            this.serverNameIsSet = true;
        }
    }

    static PropertyService getPropertyService(AuthenticatedSubject authenticatedSubject) {
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        return singleton;
    }

    public PropertyService() {
        if (singleton != null) {
            throw new AssertionError((Object)"PropertyService already initialized");
        }
        singleton = this;
    }

    public final String getTimestamp1() {
        this.checkSecurityInitialized();
        return this.userName;
    }

    public final String getTimestamp2() {
        this.checkSecurityInitialized();
        return this.password;
    }

    public final String getTimestamp3() {
        this.checkSecurityInitialized();
        return this.pkpassword;
    }

    public void updateTimestamp5(String string) {
        this.password = string;
    }

    public void updateTimestamp6(String string) {
        this.userName = string;
    }

    public void updateTimestamp3() {
        this.pkpassword = null;
    }

    public void initializeSecurityProperties(boolean bl) {
        if (this.securityInitialized) {
            return;
        }
        String[] stringArray = null;
        if (bl) {
            stringArray = new String[]{"domainCreation"};
        }
        ServerAuthenticate.main(stringArray);
        this.userName = System.getProperty(ADMIN_USERNAME_PROP, "guest");
        this.password = System.getProperty(ADMIN_PASSWORD_PROP, "guest");
        this.pkpassword = System.getProperty(ADMIN_PKPASSWORD_PROP);
        Properties properties = System.getProperties();
        properties.remove(ADMIN_USERNAME_PROP);
        properties.remove(ADMIN_PASSWORD_PROP);
        properties.remove(ADMIN_PKPASSWORD_PROP);
        this.securityInitialized = true;
    }

    public void establishServerBootIdentity(StartupConfig startupConfig) {
        this.checkSecurityInitialized();
        ClearOrEncryptedService clearOrEncryptedService = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());
        if (this.userName != null && this.userName.length() != 0) {
            startupConfig.setUsername(clearOrEncryptedService.encrypt(this.userName));
        }
        if (this.password != null && this.password.length() != 0) {
            startupConfig.setPassword(clearOrEncryptedService.encrypt(this.password));
        }
    }

    public synchronized void setAdminHost(String string) throws MalformedURLException {
        int n = string.indexOf("://");
        adminHost = n != -1 ? string.substring(0, n).toLowerCase(Locale.US) + string.substring(n) : string;
        this.adminBinaryURL = null;
        this.adminURL = new URL(PropertyService.getAdminHttpUrl());
        this.isAdminServer = adminHost == null;
    }

    public synchronized String getAdminHost() {
        return adminHost;
    }

    public synchronized void setChannelServiceReady() {
        isChannelServiceReady = true;
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void waitForChannelServiceReady() {
        if (isChannelServiceReady) {
            return;
        }
        try {
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static final synchronized String getAdminHttpUrl() {
        String string = null;
        try {
            if (isChannelServiceReady) {
                Object object;
                String string2 = ManagementService.getRuntimeAccess(KERNEL_ID).getAdminServerName();
                Protocol protocol = null;
                Protocol protocol2 = null;
                Protocol protocol3 = null;
                Iterator iterator = ProtocolManager.iterator();
                while (iterator.hasNext()) {
                    object = (Protocol)iterator.next();
                    switch (object.toByte()) {
                        case 6: {
                            protocol = object;
                            break;
                        }
                        case 1: {
                            protocol2 = object;
                            break;
                        }
                        case 3: {
                            protocol3 = object;
                            break;
                        }
                    }
                }
                object = null;
                String string3 = null;
                String string4 = null;
                if (protocol != null) {
                    object = URLManager.findURL(string2, protocol);
                }
                if (protocol2 != null) {
                    string3 = URLManager.findURL(string2, protocol2);
                }
                if (protocol3 != null) {
                    string4 = URLManager.findURL(string2, protocol3);
                }
                string = URLManager.findAdministrationURL(string2);
                if (object != null) {
                    string = object;
                } else if (string3 != null) {
                    string = string3;
                } else if (string4 != null) {
                    string = string4;
                }
            }
        }
        catch (java.rmi.UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string == null) {
            string = PropertyService.getPropertyService(KERNEL_ID).getAdminHost();
        }
        if (string == null && PropertyService.getPropertyService(KERNEL_ID).isAdminServer()) {
            string = ChannelHelper.getURL(ProtocolHandlerAdmin.PROTOCOL_ADMIN);
            if (string == null) {
                string = ChannelHelper.getURL(ProtocolHandlerHTTP.PROTOCOL_HTTP);
            }
            if (string == null) {
                throw new AssertionError((Object)"Can not extract host name of the adminstration server from JVMID");
            }
        }
        if (string == null) {
            throw new AssertionError((Object)"Could not determine admin url");
        }
        string = InetAddressHelper.convertIfIPV6URL((String)string);
        return URLManager.normalizeToHttpProtocol(string);
    }

    public static final synchronized String[] getAllAdminHttpUrls() {
        String string = PropertyService.getAdminHttpUrl();
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            String string3 = uRL.getHost();
            int n = uRL.getPort();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string3);
            if (inetAddressArray == null || inetAddressArray.length == 0) {
                return PropertyService.stringToArray(string);
            }
            String[] stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new URL(string2, inetAddressArray[i].getHostAddress(), n, "").toString();
            }
            return stringArray;
        }
        catch (MalformedURLException malformedURLException) {
            return PropertyService.stringToArray(string);
        }
        catch (UnknownHostException unknownHostException) {
            return PropertyService.stringToArray(string);
        }
    }

    private static String[] stringToArray(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public String getAdminBinaryURL() {
        if (this.adminBinaryURL != null) {
            return this.adminBinaryURL;
        }
        this.adminBinaryURL = adminHost;
        if (this.adminBinaryURL == null) {
            return null;
        }
        this.adminBinaryURL = URLManager.normalizeToAdminProtocol(this.adminBinaryURL);
        return this.adminBinaryURL;
    }

    private String initializeAdminHost() {
        if (adminHost != null) {
            return adminHost;
        }
        String string = System.getProperty(ADMIN_HOST_PROP);
        if (string == null) {
            string = System.getProperty(OLD_ADMIN_HOST_PROP);
        }
        if (string != null) {
            try {
                this.setAdminHost(string);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            this.isAdminServer = true;
        }
        return adminHost;
    }

    private void initializeServerName() {
        String string = BootStrap.getServerName();
        if (string != null) {
            this.serverName = string;
            this.serverNameIsSet = true;
        } else {
            String string2 = BootStrap.getConfigFileName();
            File file = new File(DomainDir.getConfigDir(), BootStrap.getDefaultConfigFileName());
            File file2 = new File(DomainDir.getRootDir(), string2);
            if (!file2.exists() && !file.exists()) {
                this.serverName = "myserver";
                this.serverNameIsSet = true;
            }
        }
    }

    public URL getAdminURL() {
        return this.adminURL;
    }

    public final String getServerName() {
        if (!this.serverNameIsSet) {
            throw new AssertionError((Object)"Server has not yet been established.");
        }
        return this.serverName;
    }

    public boolean isAdminServer() {
        return this.isAdminServer;
    }

    public void doPostParseInitialization(DomainMBean domainMBean) {
        if (!this.serverNameIsSet && this.isAdminServer()) {
            String string;
            ServerMBean[] serverMBeanArray = domainMBean.getServers();
            if (serverMBeanArray != null && serverMBeanArray.length == 1) {
                this.serverName = serverMBeanArray[0].getName();
                this.serverNameIsSet = true;
            }
            if (!this.serverNameIsSet && (string = domainMBean.getAdminServerName()) != null && string.length() >= 0) {
                this.serverName = string;
                this.serverNameIsSet = true;
            }
        }
        if (!this.serverNameIsSet) {
            this.serverName = "myserver";
            this.serverNameIsSet = true;
        }
    }

    public boolean serverNameIsSet() {
        return this.serverNameIsSet;
    }

    public static void main(String[] stringArray) throws Exception {
        PropertyService propertyService = new PropertyService();
        propertyService.setAdminHost(stringArray[0]);
        String[] stringArray2 = PropertyService.getAllAdminHttpUrls();
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(stringArray2[i]);
        }
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        adminHost = null;
        isChannelServiceReady = false;
    }
}

