/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.custom;

import java.beans.PropertyChangeListener;
import java.security.AccessController;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConfigurationMBeanBase
implements ConfigurationMBean {
    private String name;
    private String type;
    private ConfigurationMBean parent;
    private WebLogicObjectName objectName;
    private String notes;
    private String comments;
    private boolean registered;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void unregister() {
        if (!this.registered) {
            return;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        runtimeAccess.unregisterCustomBean((ObjectName)this.objectName);
        this.registered = false;
    }

    public ConfigurationMBeanBase(String string, String string2, ConfigurationMBean configurationMBean) {
        this.name = string;
        this.type = string2;
        this.parent = configurationMBean;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        try {
            this.objectName = configurationMBean != null ? new WebLogicObjectName(string, string2, runtimeAccess.getDomainName(), configurationMBean.getObjectName()) : new WebLogicObjectName(string, string2, runtimeAccess.getDomainName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException(malformedObjectNameException);
        }
        runtimeAccess.registerCustomBean((ObjectName)this.objectName, this);
        this.registered = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public WebLogicObjectName getObjectName() {
        return this.objectName;
    }

    public DescriptorBean getParentBean() {
        return this.parent;
    }

    public WebLogicMBean getParent() {
        return this.parent;
    }

    public void setParent(WebLogicMBean webLogicMBean) throws ConfigurationException {
        this.parent = (ConfigurationMBean)webLogicMBean;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        this.notes = string;
    }

    public Descriptor getDescriptor() {
        return null;
    }

    public boolean isSet(String string) throws IllegalArgumentException {
        return false;
    }

    public void unSet(String string) throws IllegalArgumentException {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void addBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public void removeBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public boolean isEditable() {
        return true;
    }

    public DescriptorBean createChildCopy(String string, DescriptorBean descriptorBean) {
        return null;
    }

    public DescriptorBean createChildCopyIncludingObsolete(String string, DescriptorBean descriptorBean) {
        return null;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList getAttributes(String[] stringArray) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return null;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return null;
    }

    public MBeanInfo getMBeanInfo() {
        return null;
    }

    public boolean isCachingDisabled() {
        return false;
    }

    public boolean isPersistenceEnabled() {
        return false;
    }

    public void setPersistenceEnabled(boolean bl) {
    }

    public boolean isDefaultedMBean() {
        return false;
    }

    public void setDefaultedMBean(boolean bl) {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return null;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void touch() throws ConfigurationException {
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }
}

