/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.provider.ActivateTask;
import weblogic.management.provider.internal.EditLockManager;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;

public final class ActivateTaskImpl
implements ActivateTask {
    private Map serversStateMap;
    private ArrayList changes;
    private AuthenticatedSubject user;
    private Map failedServersMap;
    private Set activatingServers = Collections.synchronizedSet(new HashSet(20));
    private DeploymentRequestTaskRuntimeMBean deploymentReqTask;
    private final String description;
    private int state;
    private long taskId;
    private long activateTimeoutTime;
    private final long beginTime = System.currentTimeMillis();
    private long endTime;
    private Exception error;
    private boolean subTaskErrorsAdded;
    private boolean waitingForEndFailureCallback;
    private boolean deploySucceededCalled;
    private boolean commitSucceededCalled;
    private boolean commitFailureOccurred;
    private boolean haveConfigDeployments;
    private EditLockManager lockMgr;
    private boolean editLockReleased;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");

    public ActivateTaskImpl(String string, EditLockManager editLockManager, boolean bl, ArrayList arrayList, AuthenticatedSubject authenticatedSubject, long l, long l2, String[] stringArray) throws ManagementException {
        this.description = string;
        this.taskId = l;
        this.haveConfigDeployments = bl;
        this.activateTimeoutTime = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + l2;
        if (!bl) {
            this.endTime = System.currentTimeMillis();
            this.setState(4);
            this.editLockReleased = true;
        } else {
            this.state = 1;
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.activatingServers.add(stringArray[i]);
            }
        }
        this.changes = arrayList;
        this.user = authenticatedSubject;
        this.lockMgr = editLockManager;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created activate task runtime with task " + l + " timeout " + new Date(this.activateTimeoutTime) + " state " + this.getStatus() + " user " + this.getUser());
        }
    }

    public final int getState() {
        if (this.state == 4 && !this.commitSucceededCalled && this.deploymentReqTask != null && !this.deploymentReqTask.isComplete()) {
            return 2;
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setState(int n) {
        ActivateTaskImpl activateTaskImpl = this;
        synchronized (activateTaskImpl) {
            this.state = n;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Setting state for activate task " + this.taskId + " to " + this.getStatus());
            }
            this.notifyAll();
        }
    }

    public Map getStateOnServers() {
        if (this.serversStateMap == null) {
            this.serversStateMap = new HashMap();
        }
        this.checkDeploymentSubTasksStatus();
        return this.serversStateMap;
    }

    public long getTaskId() {
        return this.taskId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean updateServerState(String string, int n) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Updating state for activate task " + this.taskId + " server " + string + " to " + this.getStatusForState(n));
        }
        Integer n2 = (Integer)this.getStateOnServers().get(string);
        if (n == 2) {
            if (n2 == null) {
                this.getStateOnServers().put(string, new Integer(n));
            }
        } else if (n == 5) {
            this.getStateOnServers().put(string, new Integer(n));
        } else if (n == 4) {
            this.getStateOnServers().put(string, new Integer(n));
            this.activatingServers.remove(string);
        } else if (n == 3) {
            this.getStateOnServers().put(string, new Integer(n));
            this.activatingServers.remove(string);
        } else if (n == 6) {
            this.activatingServers.remove(string);
            this.getStateOnServers().put(string, new Integer(5));
        } else if (n == 7) {
            this.commitFailureOccurred = true;
            this.activatingServers.remove(string);
            if (n2 == null || n2 != 5) {
                this.getStateOnServers().put(string, new Integer(n));
            }
        }
        if (n == 4 || n == 3 || n == 7) {
            if (this.activatingServers.size() != 0) return false;
            if (this.commitFailureOccurred) {
                if (!this.isWaitingForEndFailureCallback()) {
                    this.setState(7);
                    return false;
                } else {
                    this.endTime = System.currentTimeMillis();
                    this.setState(5);
                }
                return false;
            } else {
                if (!this.deploySucceededCalled) return n != 3;
                this.endTime = System.currentTimeMillis();
                this.setState(4);
            }
            return false;
        }
        if (n == 6) {
            try {
                String[] stringArray = this.activatingServers.toArray(new String[0]);
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (this.getStateOnServers().get(string2) != null && this.getFailedServers().get(string2) == null) continue;
                    this.activatingServers.remove(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.activatingServers.size() != 0) return false;
            if (!this.isWaitingForEndFailureCallback()) {
                this.setState(6);
                return false;
            } else {
                this.endTime = System.currentTimeMillis();
                this.setState(5);
            }
            return false;
        }
        if (n != 2 || this.activatingServers.size() != 0 || n2 == null || n2 != 3) return false;
        return true;
    }

    public Iterator getChanges() {
        return this.changes != null ? this.changes.iterator() : null;
    }

    public String getUser() {
        return SubjectUtils.getUsername((AuthenticatedSubject)this.user);
    }

    public final Map getFailedServers() {
        if (this.failedServersMap == null) {
            this.failedServersMap = new HashMap();
        }
        this.checkDeploymentSubTasksStatus();
        return this.failedServersMap;
    }

    public final void addFailedServer(String string, Exception exception) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Adding failed server for activate task " + this.taskId + " server " + string + " reason " + exception);
        }
        this.getFailedServers().put(string, exception);
        this.getStateOnServers().put(string, new Integer(5));
        this.setError(exception);
    }

    public void deploySucceeded(FailureDescription[] failureDescriptionArray) {
        this.deploySucceededCalled = true;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Deploy succeeded for activate task " + this.taskId + " releasing lock");
        }
        if (this.getState() != 4) {
            this.releaseEditLock();
            for (int i = 0; failureDescriptionArray != null && i < failureDescriptionArray.length; ++i) {
                this.activatingServers.remove(failureDescriptionArray[i].getServer());
            }
            if (this.activatingServers.size() == 0 && !this.commitFailureOccurred) {
                this.endTime = System.currentTimeMillis();
                this.setState(4);
            } else if (this.getState() == 1) {
                this.setState(2);
            }
        }
    }

    public void commitSucceeded() {
        this.commitSucceededCalled = true;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Commit succeeded for activate task " + this.taskId);
        }
        this.releaseAndSetCommitted();
    }

    public void releaseAndSetCommitted() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Set state to committed " + this.taskId + " releasing lock");
        }
        if (this.getState() != 4) {
            this.releaseEditLock();
            this.endTime = System.currentTimeMillis();
            this.setState(4);
        }
    }

    public void waitForTaskCompletion() {
        this.waitForCompletion(this.activateTimeoutTime);
    }

    public void waitForTaskCompletion(long l) {
        this.waitForCompletion(System.currentTimeMillis() + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void waitForCompletion(long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Waiting for completion for activate task " + this.taskId + " timeoutTime is " + new Date(l));
        }
        ActivateTaskImpl activateTaskImpl = this;
        // MONITORENTER : activateTaskImpl
        while (this.isRunning()) {
            try {
                long l2 = l - System.currentTimeMillis();
                if (l2 > 0L) {
                    this.wait(l2);
                    continue;
                }
                if (System.currentTimeMillis() < this.activateTimeoutTime) {
                    // MONITOREXIT : activateTaskImpl
                    return;
                }
                this.endTime = System.currentTimeMillis();
                this.setError(new RuntimeException("Timed out waiting for completion"));
                this.setState(5);
            }
            catch (InterruptedException interruptedException) {}
        }
        // MONITOREXIT : activateTaskImpl
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Waited for completion of config for activate task " + this.taskId);
        }
        if (this.state == 5) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Waiting for completion of subtasks for activate task " + this.taskId + " timeoutTime is " + new Date(l));
        }
        while (this.deploymentReqTask != null && !this.deploymentReqTask.isComplete() && this.getState() != 5) {
            if (System.currentTimeMillis() >= this.activateTimeoutTime) {
                this.setState(5);
                this.setError(new RuntimeException("Timed out waiting for completion of deployment"));
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.checkDeploymentSubTasksStatus();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Waited for completion of subtasks for activate task " + this.taskId);
        }
        if (this.haveConfigDeployments) return;
        if (this.getState() != 4) return;
        try {
            this.releaseEditLock();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            if (!debugLogger.isDebugEnabled()) return;
            debugLogger.debug("Edit lock taken away", (Throwable)illegalStateException);
        }
    }

    private void releaseEditLock() {
        if (!this.editLockReleased) {
            this.lockMgr.releaseEditLock(this.user);
            this.editLockReleased = true;
        }
    }

    public DeploymentRequestTaskRuntimeMBean getDeploymentRequestTaskRuntimeMBean() {
        return this.deploymentReqTask;
    }

    public final boolean isWaitingForEndFailureCallback() {
        return this.waitingForEndFailureCallback;
    }

    public final void setWaitingForEndFailureCallback(boolean bl) {
        this.waitingForEndFailureCallback = bl;
    }

    void setDeploymentRequestTaskRuntimeMBean(DeploymentRequestTaskRuntimeMBean deploymentRequestTaskRuntimeMBean) {
        this.deploymentReqTask = deploymentRequestTaskRuntimeMBean;
    }

    private synchronized void checkDeploymentSubTasksStatus() {
        if (this.deploymentReqTask == null || !this.deploymentReqTask.isComplete() || this.subTaskErrorsAdded) {
            return;
        }
        this.subTaskErrorsAdded = true;
        Map map = this.deploymentReqTask.getFailedTargets();
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Exception exception = (Exception)entry.getValue();
            String string = (String)entry.getKey();
            this.addFailedServer(string, exception);
        }
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getStatus() {
        return this.getStatusForState(this.state);
    }

    private final String getStatusForState(int n) {
        switch (n) {
            case 0: {
                return "STATE_NEW";
            }
            case 1: {
                return "STATE_DISTRIBUTING";
            }
            case 2: {
                return "STATE_DISTRIBUTED";
            }
            case 3: {
                return "STATE_PENDING";
            }
            case 4: {
                return "STATE_COMMITTED";
            }
            case 5: {
                return "STATE_FAILED";
            }
            case 6: {
                return "STATE_CANCELING";
            }
            case 7: {
                return "STATE_COMMIT_FAILING";
            }
        }
        return "STATE_UNKNOWN";
    }

    public final void cancel() throws Exception {
        if (this.deploymentReqTask == null) {
            return;
        }
        DeploymentService.getDeploymentService().cancel(this.deploymentReqTask.getDeploymentRequest());
    }

    public final boolean isRunning() {
        return this.state == 1 || this.state == 2 || this.state == 3 || this.state == 6 || this.state == 7;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public final Exception getError() {
        if (this.error == null) {
            this.checkDeploymentSubTasksStatus();
        }
        return this.error;
    }

    public final void setError(Exception exception) {
        this.error = exception;
    }

    public final boolean isSystemTask() {
        return false;
    }

    public final void setSystemTask(boolean bl) {
    }
}

