/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import javax.mail.internet.MimeUtility;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.logging.Loggable;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.internal.BootStrapStruct;
import weblogic.management.internal.ConfigLogger;
import weblogic.management.provider.MSIService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class BootStrapHelper {
    public static final String OAM_APPNAME = "bea_wls_management_internal2";
    private static BootStrapStruct bootStrapStruct;
    private static final AuthenticatedSubject kernelId;
    private static final String IGNORE_DEPLOYMENT_STATUS_ON_ADMIN_PROPERTY = "weblogic.ignoreDeploymentStatusOnAdmin";

    BootStrapHelper() {
    }

    static BootStrapStruct getBootStrapStruct() throws ConfigurationException {
        if (bootStrapStruct != null) {
            return bootStrapStruct;
        }
        String string = ManagementService.getPropertyService(kernelId).getTimestamp1();
        String string2 = ManagementService.getPropertyService(kernelId).getTimestamp2();
        String string3 = ManagementService.getPropertyService(kernelId).getServerName();
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        String string4 = null;
        try {
            Object object;
            ManagementService.getPropertyService(kernelId);
            string4 = PropertyService.getAdminHttpUrl();
            uRL = new URL(string4 + "/" + OAM_APPNAME + "/Bootstrap");
            httpURLConnection = URLManager.createAdminHttpConnection(uRL);
            httpURLConnection.setRequestProperty("username", BootStrapHelper.mimeEncode(string));
            httpURLConnection.setRequestProperty("password", BootStrapHelper.mimeEncode(string2));
            httpURLConnection.setRequestProperty("servername", BootStrapHelper.mimeEncode(string3));
            httpURLConnection.setRequestProperty("Version", BootStrapHelper.buildVersionString());
            httpURLConnection.setRequestProperty("action", "bootstrap");
            String string5 = System.getProperty(IGNORE_DEPLOYMENT_STATUS_ON_ADMIN_PROPERTY);
            if (string5 != null && string5.equals("true")) {
                httpURLConnection.setRequestProperty("ignoreDeploymentStatus", "true");
            } else {
                httpURLConnection.setRequestProperty("ignoreDeploymentStatus", "false");
            }
            httpURLConnection.setRequestProperty("action", "bootstrap");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            int n = -1;
            try {
                httpURLConnection.connect();
                httpURLConnection.getHeaderField(0);
                n = httpURLConnection.getResponseCode();
            }
            catch (FileNotFoundException fileNotFoundException) {
                n = 404;
            }
            if (n == 404) {
                String string6 = httpURLConnection.getHeaderField("UnkSvrMsg");
                if (string6 != null) {
                    throw new UnknownServerException(string6);
                }
                String string7 = httpURLConnection.getHeaderField("MatchMsg");
                if (string7 != null) {
                    throw new ConfigurationException(string7);
                }
                throw new ConfigurationException(string3 + " not found");
            }
            if (n == 401) {
                String string8 = httpURLConnection.getHeaderField("ErrorMsg");
                if (string8 == null) {
                    string8 = "";
                }
                Loggable loggable = ConfigLogger.logAuthenticationFailedWhileStartingManagedServerLoggable((String)string, (String)string8);
                loggable.log();
                throw new ConfigurationException(loggable.getMessage());
            }
            if (n == 500 || n == 409) {
                String string9 = httpURLConnection.getHeaderField("ErrorMsg");
                if (string9 == null) {
                    string9 = "";
                }
                string9 = string9 + " " + httpURLConnection.getResponseMessage();
                throw new ConfigurationException(string9);
            }
            if (n == 503) {
                Loggable loggable = ConfigLogger.logErrorConnectingToAdminServerLoggable((String)string4);
                loggable.log();
                throw new ConfigurationException(loggable.getMessage());
            }
            String string10 = httpURLConnection.getHeaderField("DomainVersion");
            if (string10 != null && (object = new VersionInfo(string10)).laterThan((PackageInfo)VersionInfo.theOne())) {
                Loggable loggable = ManagementLogger.logDomainVersionNotSupportedLoggable((String)string10, (String)BootStrapHelper.buildVersionString(".", true));
                loggable.log();
                throw new ConfigurationException(loggable.getMessage());
            }
            inputStream = httpURLConnection.getInputStream();
            object = new WLObjectInputStream(new BufferedInputStream(inputStream));
            BootStrapStruct bootStrapStruct = BootStrapHelper.bootStrapStruct = (BootStrapStruct)((ObjectInputStream)object).readObject();
            return bootStrapStruct;
        }
        catch (Exception exception) {
            Loggable loggable = ConfigLogger.logErrorConnectionAdminServerForBootstrapLoggable(uRL, (String)string, (Exception)exception);
            if (MSIService.getMSIService().isAdminServerAvailable()) {
                loggable.log();
            } else {
                ManagementLogger.logErrorConnectingToAdminServer((String)string4);
            }
            if (exception instanceof ConfigurationException) {
                throw (ConfigurationException)((Object)exception);
            }
            throw new ConfigurationException(loggable.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpURLConnection != null) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String buildVersionString() {
        return BootStrapHelper.buildVersionString(",", false);
    }

    private static String buildVersionString(String string, boolean bl) {
        if (string == null) {
            string = ",";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Integer(VersionInfo.theOne().getMajor()));
        stringBuffer.append(string);
        stringBuffer.append(new Integer(VersionInfo.theOne().getMinor()));
        stringBuffer.append(string);
        stringBuffer.append(new Integer(VersionInfo.theOne().getServicePack()));
        if (bl) {
            stringBuffer.append(string);
            stringBuffer.append(new Integer(VersionInfo.theOne().getRollingPatch()));
        }
        return stringBuffer.toString();
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    static class UnknownServerException
    extends ConfigurationException {
        public UnknownServerException(String string) {
            super(string);
        }
    }
}

