/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementLogger;
import weblogic.management.WebLogicMBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ContextCaseMBean;
import weblogic.management.configuration.CustomRealmMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.EmbeddedLDAPMBean;
import weblogic.management.configuration.FileRealmMBean;
import weblogic.management.configuration.FileT3MBean;
import weblogic.management.configuration.JoltConnectionPoolMBean;
import weblogic.management.configuration.LDAPRealmMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ManagedExternalServerMBean;
import weblogic.management.configuration.MaxThreadsConstraintMBean;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.management.configuration.NTRealmMBean;
import weblogic.management.configuration.PathServiceMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.RDBMSRealmMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ShutdownClassMBean;
import weblogic.management.configuration.StartupClassMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.UnixRealmMBean;
import weblogic.management.configuration.WorkManagerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

final class ChangeUtils {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");

    ChangeUtils() {
    }

    public static String[] getRestartRequiredServers(BeanUpdateEvent beanUpdateEvent) {
        ChangeUtils.say("getRestartRequiredServers");
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        if (descriptorBean == null) {
            ChangeUtils.say("getRestartRequiredServers: bean is null. no servers affected");
            return new String[0];
        }
        if (ChangeUtils.containedByExternal(descriptorBean)) {
            ChangeUtils.say("getRestartRequiredServers: not a server related bean");
            return new String[0];
        }
        BeanInfoAccess beanInfoAccess = ManagementService.getBeanInfoAccess();
        BeanInfo beanInfo = beanInfoAccess.getBeanInfoForDescriptorBean(descriptorBean);
        if (beanInfo == null) {
            ChangeUtils.say("getRestartRequiredServers: bean info is null. no servers affected");
            return new String[0];
        }
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        ChangeUtils.say("getRestartRequiredServers: updates.length=" + propertyUpdateArray.length);
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
            String string = propertyUpdate.getPropertyName();
            if (propertyUpdate.isDynamic()) continue;
            ChangeUtils.say("getRestartRequiredServers: found restart required property");
            DescriptorBean descriptorBean2 = beanUpdateEvent.getSourceBean();
            ManagementLogger.logNonDynamicAttributeChange((String)descriptorBean2.toString(), (String)string);
            return ChangeUtils.getAffectedServers(beanUpdateEvent.getProposedBean());
        }
        return new String[0];
    }

    private static String[] getAffectedServers(DescriptorBean descriptorBean) {
        ChangeUtils.say("getRestartRequiredServers");
        if (descriptorBean instanceof StandardInterface) {
            Descriptor descriptor = descriptorBean.getDescriptor();
            DescriptorBean descriptorBean2 = descriptor.getRootBean();
            if (descriptorBean2 instanceof DomainMBean) {
                return ChangeUtils.getAllServers((DomainMBean)descriptorBean2);
            }
            return ChangeUtils.getAllServers(ManagementService.getRuntimeAccess(KERNEL_ID).getDomain());
        }
        if (!(descriptorBean instanceof ConfigurationMBean)) {
            ChangeUtils.say("getRestartRequiredServers: getAffectedServers: not a config bean");
            return new String[0];
        }
        ConfigurationMBean configurationMBean = (ConfigurationMBean)descriptorBean;
        ChangeUtils.say("checking servers affected by: " + configurationMBean.getName());
        ServerMBean serverMBean = ChangeUtils.containedByServer(configurationMBean);
        if (serverMBean != null) {
            ChangeUtils.say("getRestartRequiredServers: affected server " + serverMBean.getName());
            String[] stringArray = new String[]{serverMBean.getName()};
            return stringArray;
        }
        ChangeUtils.say("getRestartRequiredServers: Not contained by Server");
        ClusterMBean clusterMBean = ChangeUtils.containedByCluster(configurationMBean);
        if (clusterMBean != null) {
            ChangeUtils.say("getRestartRequiredServers: affected cluster " + clusterMBean.getName());
            return ChangeUtils.getServers(clusterMBean);
        }
        ChangeUtils.say("getRestartRequiredServers: Not contained by Cluster");
        MachineMBean machineMBean = ChangeUtils.containedByMachine(configurationMBean);
        if (machineMBean != null) {
            ChangeUtils.say("getRestartRequiredServers: affected machine " + machineMBean.getName());
            return ChangeUtils.getServers(machineMBean);
        }
        ChangeUtils.say("getRestartRequiredServers: Not contained by Machine");
        if (ChangeUtils.isSecurityConfiguration(configurationMBean) || ChangeUtils.isSecurity(configurationMBean) || ChangeUtils.isEmbeddedLDAP(configurationMBean) || ChangeUtils.is6xRealm(configurationMBean)) {
            ChangeUtils.say("getRestartRequiredServers: non-dynamic security setting");
            return ChangeUtils.getAllServers(ChangeUtils.getDomain(configurationMBean));
        }
        ChangeUtils.say("getRestartRequiredServers: not security setting");
        String[] stringArray = ChangeUtils.getTargetServersIfDeployableNeedsRestart(configurationMBean);
        if (stringArray != null) {
            if (debugLogger.isDebugEnabled()) {
                String string = "NON-DYNAMIC change for Deployable with target servers: ";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + (i < stringArray.length ? ", " : "");
                }
                debugLogger.debug(string);
            }
            return stringArray;
        }
        if (debugLogger.isDebugEnabled()) {
            String string = "Warning: NON-DYNAMIC CHANGE IN " + configurationMBean.getType() + "{" + configurationMBean.getName() + "}";
            debugLogger.debug(string);
        }
        return ChangeUtils.getAllServers(ChangeUtils.getDomain(configurationMBean));
    }

    private static String[] getTargetServersIfDeployableNeedsRestart(ConfigurationMBean configurationMBean) {
        WebLogicMBean webLogicMBean;
        boolean bl = false;
        DeploymentMBean deploymentMBean = null;
        while (configurationMBean != null) {
            if (configurationMBean instanceof TargetInfoMBean) {
                return new String[0];
            }
            if (configurationMBean instanceof DeploymentMBean) {
                if (configurationMBean instanceof ShutdownClassMBean || configurationMBean instanceof ContextCaseMBean || configurationMBean instanceof FileT3MBean || configurationMBean instanceof JoltConnectionPoolMBean || configurationMBean instanceof MaxThreadsConstraintMBean || configurationMBean instanceof MessagingBridgeMBean || configurationMBean instanceof PathServiceMBean || configurationMBean instanceof PersistentStoreMBean || configurationMBean instanceof WorkManagerMBean) {
                    bl = true;
                }
                deploymentMBean = (DeploymentMBean)configurationMBean;
                break;
            }
            webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        if (deploymentMBean == null) {
            return null;
        }
        if (!bl) {
            return new String[0];
        }
        webLogicMBean = deploymentMBean.getTargets();
        if (webLogicMBean == null) {
            return new String[0];
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < ((WebLogicMBean)webLogicMBean).length; ++i) {
            hashSet.addAll(webLogicMBean[i].getServerNames());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static ServerMBean containedByServer(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof ServerMBean) {
                return (ServerMBean)configurationMBean;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return null;
    }

    private static boolean containedByExternal(DescriptorBean descriptorBean) {
        if (descriptorBean instanceof ConfigurationMBean) {
            ConfigurationMBean configurationMBean = (ConfigurationMBean)descriptorBean;
            while (configurationMBean != null) {
                if (configurationMBean instanceof ManagedExternalServerMBean) {
                    return true;
                }
                WebLogicMBean webLogicMBean = configurationMBean.getParent();
                configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
            }
        }
        return false;
    }

    private static ClusterMBean containedByCluster(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof ClusterMBean) {
                return (ClusterMBean)configurationMBean;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return null;
    }

    private static MachineMBean containedByMachine(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof MachineMBean) {
                return (MachineMBean)configurationMBean;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return null;
    }

    private static boolean isSecurityConfiguration(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof SecurityConfigurationMBean) {
                return true;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return false;
    }

    private static boolean isSecurity(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof SecurityMBean) {
                return true;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return false;
    }

    private static boolean isEmbeddedLDAP(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof EmbeddedLDAPMBean) {
                return true;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return false;
    }

    private static boolean is6xRealm(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof CachingRealmMBean || configurationMBean instanceof CustomRealmMBean || configurationMBean instanceof FileRealmMBean || configurationMBean instanceof LDAPRealmMBean || configurationMBean instanceof NTRealmMBean || configurationMBean instanceof RDBMSRealmMBean || configurationMBean instanceof UnixRealmMBean) {
                return true;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            configurationMBean = webLogicMBean instanceof ConfigurationMBean ? (ConfigurationMBean)webLogicMBean : null;
        }
        return false;
    }

    private static String[] getServers(ClusterMBean clusterMBean) {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        if (serverMBeanArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[serverMBeanArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = serverMBeanArray[i].getName();
        }
        return stringArray;
    }

    private static String[] getServers(MachineMBean machineMBean) {
        ServerMBean[] serverMBeanArray = ChangeUtils.getDomain(machineMBean).getServers();
        if (serverMBeanArray == null) {
            return new String[0];
        }
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (serverMBeanArray[i].getMachine() == null || !machineMBean.getName().equals(serverMBeanArray[i].getMachine().getName())) continue;
            arrayList.add(serverMBeanArray[i].getName());
            ++n;
        }
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private static String[] getAllServers(DomainMBean domainMBean) {
        if (domainMBean == null) {
            return new String[0];
        }
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        String[] stringArray = new String[serverMBeanArray.length];
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            stringArray[i] = serverMBeanArray[i].getName();
        }
        return stringArray;
    }

    private static DomainMBean getDomain(ConfigurationMBean configurationMBean) {
        while (configurationMBean != null) {
            if (configurationMBean instanceof DomainMBean) {
                return (DomainMBean)configurationMBean;
            }
            WebLogicMBean webLogicMBean = configurationMBean.getParent();
            if (webLogicMBean instanceof ConfigurationMBean) {
                configurationMBean = (ConfigurationMBean)webLogicMBean;
                continue;
            }
            configurationMBean = null;
        }
        return null;
    }

    public static boolean getRestartValue(PropertyDescriptor propertyDescriptor) {
        block9: {
            if (propertyDescriptor == null) {
                ChangeUtils.say("getRestartValue: property descriptor is null, return true");
                return true;
            }
            ChangeUtils.say("getRestartValue: checking restart value of " + propertyDescriptor.getName());
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            if (!(!TargetInfoMBean.class.isAssignableFrom(clazz) && (!DeploymentMBean.class.isAssignableFrom(clazz) || StartupClassMBean.class.isAssignableFrom(clazz) || ShutdownClassMBean.class.isAssignableFrom(clazz) || ContextCaseMBean.class.isAssignableFrom(clazz) || FileT3MBean.class.isAssignableFrom(clazz) || JoltConnectionPoolMBean.class.isAssignableFrom(clazz) || MaxThreadsConstraintMBean.class.isAssignableFrom(clazz) || MessagingBridgeMBean.class.isAssignableFrom(clazz) || PathServiceMBean.class.isAssignableFrom(clazz) || PersistentStoreMBean.class.isAssignableFrom(clazz) || WorkManagerMBean.class.isAssignableFrom(clazz)))) {
                return false;
            }
            try {
                ChangeUtils.say("getRestartValue: value of dynamic is " + propertyDescriptor.getValue("dynamic"));
                Boolean bl = (Boolean)propertyDescriptor.getValue("dynamic");
                if (bl != null) {
                    if (bl.booleanValue()) {
                        ChangeUtils.say("return false");
                        return false;
                    }
                    ChangeUtils.say("return true");
                    return true;
                }
                ChangeUtils.say("getRestartValue: value of non-dynamic is " + propertyDescriptor.getValue("non-dynamic"));
                Boolean bl2 = (Boolean)propertyDescriptor.getValue("non-dynamic");
                if (bl2 != null) {
                    if (!bl2.booleanValue()) {
                        ChangeUtils.say("return false");
                        return false;
                    }
                    ChangeUtils.say("return true");
                    return true;
                }
            }
            catch (Exception exception) {
                if (!debugLogger.isDebugEnabled()) break block9;
                debugLogger.debug("ChangeUtils: " + exception, (Throwable)exception);
            }
        }
        ChangeUtils.say("return true");
        return true;
    }

    private static void say(String string) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("ChangeUtils: " + string);
        }
    }

    private static class DeploymentRestartInfo {
        boolean restartRequired = false;
        TargetInfoMBean targetInfo = null;

        DeploymentRestartInfo(ConfigurationMBean configurationMBean) {
        }
    }
}

