/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.jars.JarFileUtils;

public class ConfigBackup {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private static final File configDir = new File(DomainDir.getConfigDir());
    private static final File archiveDir = new File(DomainDir.getRootDir(), "configArchive");
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String CONFIG_BASE = "config-";

    static void saveBooted() throws IOException {
        File file = new File(DomainDir.getRootDir(), "config-booted.jar");
        ConfigBackup.createJarFileFromConfig(file);
    }

    static void saveOriginal() throws IOException {
        File file = new File(DomainDir.getRootDir(), "config-original.jar");
        ConfigBackup.createJarFileFromConfig(file);
    }

    static void saveVersioned() throws IOException {
        File[] fileArray;
        int n = 3;
        if (Kernel.isServer()) {
            fileArray = ManagementService.getRuntimeAccess(kernelId).getDomain();
            if (fileArray == null) {
                return;
            }
            n = fileArray.getArchiveConfigurationCount();
        }
        if (n <= 0) {
            return;
        }
        if (!archiveDir.exists()) {
            archiveDir.mkdir();
        }
        if (!archiveDir.isDirectory()) {
            throw new IOException(archiveDir.getCanonicalPath() + " is not a directory");
        }
        fileArray = archiveDir.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            File file = ConfigBackup.getVersionedArchiveName(1);
            ConfigBackup.createJarFileFromConfig(file);
        } else {
            int n2;
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            for (n2 = 0; n2 < fileArray.length; ++n2) {
                int n6;
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("saveVersioned: existing archive file = " + fileArray[n2]);
                }
                if ((n6 = ConfigBackup.getVersion(fileArray[n2])) < 0) continue;
                ++n5;
                if (n3 == -1 || n3 > n6) {
                    n3 = n6;
                }
                if (n4 != -1 && n4 >= n6) continue;
                n4 = n6;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                if (n5 >= n) {
                    boolean bl;
                    File file = ConfigBackup.getVersionedArchiveName(n3);
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("saveVersioned: delete existing archive file = " + file);
                    }
                    boolean bl2 = bl = !file.delete();
                    if (bl) {
                        String string = "Unable to delete old archive " + file.getCanonicalPath();
                        throw new IOException(string);
                    }
                }
                File file = ConfigBackup.getVersionedArchiveName(n2);
                ConfigBackup.createJarFileFromConfig(file);
            }
        }
    }

    private static int getVersion(File file) {
        if (file == null) {
            return -1;
        }
        String string = file.getName();
        if (string.startsWith(CONFIG_BASE) && string.endsWith(".jar")) {
            int n = string.indexOf(CONFIG_BASE) + CONFIG_BASE.length();
            String string2 = string.substring(n);
            int n2 = string2.indexOf(".jar");
            string2 = string2.substring(0, n2);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    private static File getVersionedArchiveName(int n) {
        return new File(archiveDir, CONFIG_BASE + n + ".jar");
    }

    private static void createJarFileFromConfig(File file) throws IOException {
        ConfigBackup.createJarFileFromConfig(file.getPath());
    }

    private static void createJarFileFromConfig(String string) throws IOException {
        String string2 = new File(string).getAbsolutePath();
        if (!configDir.isDirectory()) {
            IOException iOException = new IOException(configDir + " is not a directory");
            ManagementLogger.logCouldNotBackupConfiguration((String)string2, (Throwable)iOException);
            throw iOException;
        }
        ManagementLogger.logBackingUpConfiguration((String)string2);
        try {
            JarFileUtils.createJarFileFromDirectory((String)string, (File)configDir);
        }
        catch (IOException iOException) {
            ManagementLogger.logCouldNotBackupConfiguration((String)string2, (Throwable)iOException);
            throw iOException;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ConfigBackup.saveBooted();
        ConfigBackup.saveOriginal();
        ConfigBackup.saveVersioned();
    }
}

