/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.management.JMException;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.management.DomainDir;
import weblogic.management.configuration.ConfigurationExtensionMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.provider.internal.ConfigImageSourceService;
import weblogic.management.provider.internal.DescriptorInfo;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.management.provider.internal.DescriptorManagerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConfigImageSource
implements ImageSource {
    RuntimeAccess runtimeAccess;
    private boolean imageCreationTimeout = false;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public ConfigImageSource(RuntimeAccess runtimeAccess) {
        this.runtimeAccess = runtimeAccess;
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
            PrintWriter printWriter = new PrintWriter(jarOutputStream);
            try {
                this.imageCreationTimeout = false;
                DomainMBean domainMBean = this.runtimeAccess.getDomain();
                Descriptor descriptor = domainMBean.getDescriptor();
                ConfigImageSource.writeSystemProperties(descriptor, jarOutputStream);
                ConfigImageSource.writeDomainDirectory(descriptor, jarOutputStream);
                ConfigImageSource.writeEditLockState(jarOutputStream);
                ConfigImageSource.writeDescriptorTree(descriptor, jarOutputStream);
                this.writeSystemPropertiesSchema(jarOutputStream);
                this.writeDomainDirectorySchema(jarOutputStream);
                this.writeEditLockStateSchema(jarOutputStream);
                jarOutputStream.flush();
                jarOutputStream.close();
            }
            catch (Exception exception) {
                printWriter.println("Error dumping bean tree " + exception);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                Throwable throwable = exception.getCause();
                while (throwable != null) {
                    printWriter.println("\nCaused by: \n");
                    throwable.printStackTrace(printWriter);
                    throwable = exception.getCause();
                }
                throw new ImageSourceCreationException((Throwable)exception);
            }
            finally {
                printWriter.flush();
            }
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException((Throwable)iOException);
        }
    }

    public void timeoutImageCreation() {
        this.imageCreationTimeout = true;
    }

    private static void writeDescriptorTree(Descriptor descriptor, JarOutputStream jarOutputStream) throws IOException, JMException {
        jarOutputStream.putNextEntry(new JarEntry("config/config.xml"));
        DescriptorManagerHelper.saveDescriptor(descriptor, jarOutputStream);
        jarOutputStream.flush();
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(descriptor);
        while (iterator != null && iterator.hasNext()) {
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            Descriptor descriptor2 = descriptorInfo.getDescriptor();
            ConfigurationExtensionMBean configurationExtensionMBean = descriptorInfo.getConfigurationExtension();
            jarOutputStream.putNextEntry(new JarEntry("config/" + configurationExtensionMBean.getDescriptorFileName()));
            DescriptorManager descriptorManager = descriptorInfo.getDescriptorManager();
            DescriptorBean descriptorBean = descriptorInfo.getDescriptorBean();
            descriptorManager.writeDescriptorBeanAsXML(descriptorBean, (OutputStream)jarOutputStream);
            jarOutputStream.flush();
        }
    }

    private static void writeSystemProperties(Descriptor descriptor, JarOutputStream jarOutputStream) throws IOException, JMException {
        jarOutputStream.putNextEntry(new JarEntry("system-properties.xml"));
        PrintWriter printWriter = new PrintWriter(jarOutputStream);
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        printWriter.println("<!-- System Properties -->");
        printWriter.println("<system-properties xsi:schemaLocation=\"schema/system-properties.xsd\">");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            for (int i = 0; i < ConfigImageSourceService.PROTECTED.length; ++i) {
                if (string.toLowerCase(Locale.US).indexOf(ConfigImageSourceService.PROTECTED[i]) < 0) continue;
                string2 = "********";
            }
            printWriter.println("  <property>");
            printWriter.println("    <key>" + string + "</key>");
            printWriter.println("    <val>" + string2 + "</val>");
            printWriter.println("  </property>");
        }
        printWriter.println("</system-properties>");
        printWriter.println("");
        printWriter.flush();
        jarOutputStream.flush();
    }

    private static void writeDomainDirectory(Descriptor descriptor, JarOutputStream jarOutputStream) throws IOException, JMException {
        jarOutputStream.putNextEntry(new JarEntry("domain-directory.xml"));
        PrintWriter printWriter = new PrintWriter(jarOutputStream);
        printWriter.println("<!-- Domain Directory Information -->");
        printWriter.println("<domain-directory xsi:schemaLocation=\"schema/domain-directory.xsd\">");
        printWriter.println("  <root-dir>" + DomainDir.getRootDir() + "</root-dir>");
        printWriter.println("  <bin-dir>" + DomainDir.getBinDir() + "</bin-dir>");
        printWriter.println("  <config-dir>" + DomainDir.getConfigDir() + "</config-dir>");
        printWriter.println("  <deployments-dir>" + DomainDir.getDeploymentsDir() + "</deployments-dir>");
        printWriter.println("  <diagnostic-dir>" + DomainDir.getDiagnosticsDir() + "</diagnostic-dir>");
        printWriter.println("  <jdbc-dir>" + DomainDir.getJDBCDir() + "</jdbc-dir>");
        printWriter.println("  <jms-dir>" + DomainDir.getJMSDir() + "</jms-dir>");
        printWriter.println("  <config-security-dir>" + DomainDir.getConfigSecurityDir() + "</config-security-dir>");
        printWriter.println("  <config-startup-dir>" + DomainDir.getConfigStartupDir() + "</config-startup-dir>");
        printWriter.println("  <lib-modules-dir>" + DomainDir.getLibModulesDir() + "</lib-modules-dir>");
        printWriter.println("  <pending-dir>" + DomainDir.getPendingDir() + "</pending-dir>");
        printWriter.println("  <security-dir>" + DomainDir.getSecurityDir() + "</security-dir>");
        printWriter.println("  <servers-dir>" + DomainDir.getServersDir() + "</servers-dir>");
        printWriter.println("  <local-server-dir>" + DomainDir.getDirForServer((String)ManagementService.getRuntimeAccess(kernelId).getServerName()) + "</local-server-dir>");
        printWriter.println("</domain-directory>");
        printWriter.flush();
        jarOutputStream.flush();
    }

    private void writeDomainDirectorySchema(JarOutputStream jarOutputStream) throws IOException {
        jarOutputStream.putNextEntry(new JarEntry("schema/domain-directory.xsd"));
        PrintWriter printWriter = new PrintWriter(jarOutputStream);
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        printWriter.println(" targetNamespace=\"http://xmlns.oracle.com/weblogic//domain-directory\"");
        printWriter.println(" xmlns=\"http://http://xmlns.oracle.com/weblogic//domain-directory\"");
        printWriter.println(" elementFormDefault=\"qualified\">");
        printWriter.println("   <xs:complexType>");
        printWriter.println("     <xs:sequence>");
        printWriter.println("       <xs:element name=\"root-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"bin-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"config-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"deployments-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"diagnostic-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"jdbc-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"jms-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"config-security-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"config-startup-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"config-lib-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"lib-modules-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"pending-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"security-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"servers-dir\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"local-server-dir\" type=\"xs:string\"/>");
        printWriter.println("     </xs:sequence>");
        printWriter.println("   </xs:complexType>");
        printWriter.println("</xs:schema>");
        printWriter.flush();
        jarOutputStream.flush();
    }

    private void writeSystemPropertiesSchema(JarOutputStream jarOutputStream) throws IOException {
        jarOutputStream.putNextEntry(new JarEntry("schema/system-properties.xsd"));
        PrintWriter printWriter = new PrintWriter(jarOutputStream);
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        printWriter.println(" targetNamespace=\"http://xmlns.oracle.com/weblogic//system-properties\"");
        printWriter.println(" xmlns=\"http://http://xmlns.oracle.com/weblogic//system-properties\"");
        printWriter.println(" elementFormDefault=\"qualified\">");
        printWriter.println(" <xs:element name=\"property\">");
        printWriter.println("     <xs:complexType>");
        printWriter.println("       <xs:sequence>");
        printWriter.println("         <xs:element name=\"key\" type=\"xs:string\"/>");
        printWriter.println("         <xs:element name=\"val\" type=\"xs:string\"/>");
        printWriter.println("        </xs:sequence>");
        printWriter.println("     </xs:complexType>");
        printWriter.println(" </xs:element>");
        printWriter.println("</xs:schema>");
        printWriter.flush();
        jarOutputStream.flush();
    }

    private static void writeEditLockState(JarOutputStream jarOutputStream) throws IOException, JMException {
        EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
        if (editAccess == null) {
            return;
        }
        jarOutputStream.putNextEntry(new JarEntry("edit-lock-state.xml"));
        PrintWriter printWriter = new PrintWriter(jarOutputStream);
        printWriter.println("<!-- Edit Lock Information -->");
        printWriter.println("<edit-lock xsi:schemaLocation=\"schema/edit-lock-state.xsd\">");
        printWriter.println("  <editor>" + editAccess.getEditor() + "</editor>");
        printWriter.println("  <start-time>" + editAccess.getEditorStartTime() + "</start-time>");
        printWriter.println("  <expiration-time>" + editAccess.getEditorExpirationTime() + "</expiration-time>");
        printWriter.println("  <exclusive>" + editAccess.isEditorExclusive() + "</exclusive>");
        printWriter.println("</edit-lock>");
        printWriter.flush();
        jarOutputStream.flush();
    }

    private void writeEditLockStateSchema(JarOutputStream jarOutputStream) throws IOException {
        jarOutputStream.putNextEntry(new JarEntry("schema/edit-lock-state.xsd"));
        PrintWriter printWriter = new PrintWriter(jarOutputStream);
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        printWriter.println(" targetNamespace=\"http://xmlns.oracle.com/weblogic//edit-lock-state\"");
        printWriter.println(" xmlns=\"http://http://xmlns.oracle.com/weblogic//edit-lock-state\"");
        printWriter.println(" elementFormDefault=\"qualified\">");
        printWriter.println("   <xs:complexType>");
        printWriter.println("     <xs:sequence>");
        printWriter.println("       <xs:element name=\"editor\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"start-time\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"expiration-time\" type=\"xs:string\"/>");
        printWriter.println("       <xs:element name=\"exclusive\" type=\"xs:boolean\"/>");
        printWriter.println("     </xs:sequence>");
        printWriter.println("   </xs:complexType>");
        printWriter.println("</xs:schema>");
        printWriter.flush();
        jarOutputStream.flush();
    }
}

