/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import com.bea.security.utils.random.SecureRandomData;
import java.security.AccessController;
import java.util.Locale;
import java.util.TreeSet;
import weblogic.diagnostics.image.ImageManager;
import weblogic.management.ManagementLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.provider.internal.ConfigImageSource;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class ConfigImageSourceService
extends AbstractServerService {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static String[] PROTECTED = new String[]{"password", "passphrase", "credential", "pass", "pwd"};
    static final String LINE_SEP = "line.separator";

    public void start() throws ServiceFailureException {
        try {
            this.logSystemProperties();
            ImageManager imageManager = ImageManager.getInstance();
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            ConfigImageSource configImageSource = new ConfigImageSource(runtimeAccess);
            imageManager.registerImageSource("configuration", configImageSource);
        }
        catch (Throwable throwable) {
            throw new ServiceFailureException(throwable);
        }
    }

    private void logSystemProperties() {
        this.logEntropyConfiguration();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            stringBuffer.append(System.getProperty(LINE_SEP));
            for (String string2 : new TreeSet<Object>(System.getProperties().keySet())) {
                if (string2.equals(LINE_SEP) || (string = System.getProperty(string2)) == null || string.length() == 0) continue;
                stringBuffer.append(string2);
                stringBuffer.append(" = ");
                stringBuffer.append(this.hideIfProtected(string2, string));
                stringBuffer.append(System.getProperty(LINE_SEP));
            }
            ManagementLogger.logJavaSystemProperties((String)stringBuffer.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ManagementLogger.logInvalidSystemProperty((Throwable)illegalArgumentException);
        }
    }

    private void logEntropyConfiguration() {
        ManagementLogger.logJavaEntropyConfig((String)SecureRandomData.getJavaEntropyConfiguration());
        if (SecureRandomData.isJavaEntropyBlocking()) {
            ManagementLogger.logJavaEntropyConfigIsBlocking();
        } else {
            ManagementLogger.logJavaEntropyConfigIsNonBlocking();
        }
    }

    private String hideIfProtected(String string, String string2) {
        for (int i = 0; i < PROTECTED.length; ++i) {
            if (string.toLowerCase(Locale.US).indexOf(PROTECTED[i]) < 0) continue;
            return "********";
        }
        return string2;
    }
}

