/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import weblogic.descriptor.DescriptorReader;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.ManagementLogger;
import weblogic.management.VersionConstants;
import weblogic.management.provider.internal.ConfigReaderContext;
import weblogic.management.provider.internal.ConfigurationTranslator;

public class ConfigReader
extends DescriptorReader {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    public static final String EXECUTE_CONFIG_TRANSLATORS_PROP = "weblogic.configuration.executeConfigurationTranslators";
    private static final boolean executeConfigurationTranslators = ConfigReader.getBooleanProperty("weblogic.configuration.executeConfigurationTranslators", false);
    private static final boolean convertSecurityExtensionSchema = ConfigReader.getBooleanProperty("weblogic.management.convertSecurityExtensionSchema", false);

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public ConfigReader(InputStream inputStream) throws XMLStreamException {
        this(inputStream, null);
    }

    public ConfigReader(InputStream inputStream, ConfigReaderContext configReaderContext) throws XMLStreamException {
        super(ConfigReader.convert(inputStream, configReaderContext));
        int n;
        if (configReaderContext != null && configReaderContext.isStreamModifed()) {
            this.setModified(true);
        }
        for (n = 0; n < VersionConstants.NAMESPACE_MAPPING.length; ++n) {
            this.addNamespaceMapping(VersionConstants.NAMESPACE_MAPPING[n][0], VersionConstants.NAMESPACE_MAPPING[n][1]);
        }
        if (convertSecurityExtensionSchema) {
            for (n = 0; n < VersionConstants.EXTENSION_NAMESPACE_MAPPING.length; ++n) {
                this.addNamespaceMapping(VersionConstants.EXTENSION_NAMESPACE_MAPPING[n][0], VersionConstants.EXTENSION_NAMESPACE_MAPPING[n][1]);
            }
        }
    }

    public static InputStream convert(InputStream inputStream, ConfigReaderContext configReaderContext) throws XMLStreamException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            String string = element.getNamespaceURI();
            if ("http://www.bea.com/ns/weblogic/90/domain".equals(string) || "http://www.bea.com/ns/weblogic/920/domain".equals(string)) {
                if (configReaderContext != null) {
                    configReaderContext.setStreamModified(true);
                }
                ConfigReader.convert90(document);
            }
            if (executeConfigurationTranslators) {
                if (configReaderContext != null) {
                    configReaderContext.setStreamModified(true);
                }
                ConfigReader.convertPluggable(document);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return new ByteArrayInputStream(byArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLStreamException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException.getMessage(), sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XMLStreamException(transformerConfigurationException.getMessage(), transformerConfigurationException);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException.getMessage(), iOException);
        }
        catch (TransformerException transformerException) {
            throw new XMLStreamException(transformerException.getMessage(), transformerException);
        }
    }

    private static void convert90(Document document) {
        NodeList nodeList;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Convert config from 90 to current version");
        }
        if ((nodeList = document.getElementsByTagName("domain")) != null && nodeList.getLength() > 0) {
            Node node;
            Node node2;
            Node node3 = nodeList.item(0);
            Node node4 = null;
            Node node5 = null;
            nodeList = node3.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node6 = nodeList.item(i);
                if (("name".equals(node6.getLocalName()) || "notes".equals(node6.getLocalName())) && nodeList.getLength() > i + 1) {
                    node5 = nodeList.item(i + 1);
                }
                if (!"domain-version".equals(node6.getLocalName())) continue;
                node4 = node6;
            }
            NodeList nodeList2 = document.getElementsByTagName("log");
            if (nodeList2 != null && nodeList2.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    NodeList nodeList3;
                    node2 = nodeList2.item(i);
                    node = null;
                    Node node7 = null;
                    Node node8 = null;
                    Node node9 = null;
                    if (node2 == null || (nodeList3 = node2.getChildNodes()) == null || nodeList3.getLength() <= 0) continue;
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        Node node10 = nodeList3.item(j);
                        if (node10.getLocalName() == null) continue;
                        if (node10.getLocalName().equals("stdout-severity") && node7 == null) {
                            node7 = node10;
                        }
                        if (node10.getLocalName().equals("log-file-filter") && node == null) {
                            node = node10;
                        }
                        if (node10.getLocalName().equals("stdout-format") && node8 == null) {
                            node8 = node10;
                        }
                        if (!node10.getLocalName().equals("stdout-log-stack") || node9 != null) continue;
                        node9 = node10;
                    }
                    if (node7 != null & node != null) {
                        node2.insertBefore(node7, node);
                    }
                    if (node8 != null & node != null) {
                        node2.insertBefore(node8, node);
                    }
                    if (!(node9 != null & node != null)) continue;
                    node2.insertBefore(node9, node);
                }
            }
            if (node4 == null) {
                Element element = document.createElement("domain-version");
                node2 = document.createTextNode("10.3.0.0");
                node = document.createTextNode("\n  ");
                element.appendChild(node2);
                if (node5 != null) {
                    node3.insertBefore(element, node5);
                    node3.insertBefore(node, element);
                } else {
                    node3.appendChild(element);
                    node3.appendChild(node);
                }
            }
        }
    }

    private static void convertPluggable(Document document) {
        ConfigurationTranslator configurationTranslator = null;
        Element element = document.getDocumentElement();
        String string = element.getNamespaceURI();
        if (string == null) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ConfigReader.class.getClassLoader();
        }
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources("META-INF/wls-configuration-translators");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Run configuration translator " + uRL);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    block13: {
                        Loggable loggable;
                        try {
                            configurationTranslator = (ConfigurationTranslator)Class.forName(string2).newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            loggable = ManagementLogger.logErrorLoadingConfigTranslatorLoggable((String)string2, (String)classNotFoundException.toString());
                            loggable.log();
                            break block13;
                        }
                        catch (InstantiationException instantiationException) {
                            loggable = ManagementLogger.logErrorLoadingConfigTranslatorLoggable((String)string2, (String)instantiationException.toString());
                            loggable.log();
                            break block13;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            loggable = ManagementLogger.logErrorLoadingConfigTranslatorLoggable((String)string2, (String)illegalAccessException.toString());
                            loggable.log();
                            break block13;
                        }
                        catch (ClassCastException classCastException) {
                            loggable = ManagementLogger.logErrorLoadingConfigTranslatorLoggable((String)string2, (String)classCastException.toString());
                            loggable.log();
                            break block13;
                        }
                        if (string.equals(configurationTranslator.sourceNamespace()) && "http://www.bea.com/ns/weblogic/920/domain".equals(configurationTranslator.targetNamespace())) {
                            configurationTranslator.translate(document);
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
            }
        }
        catch (IOException iOException) {
            ManagementLogger.logExceptionDuringConfigTranslation((Throwable)iOException);
        }
    }
}

