/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import weblogic.deploy.service.internal.BaseDeploymentImpl;
import weblogic.management.ManagementLogger;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConfigurationDeployment
extends BaseDeploymentImpl {
    private static final long serialVersionUID = 4191427923503258738L;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public ConfigurationDeployment() {
    }

    ConfigurationDeployment(String string) {
        super(string, string, null, null, null, null, null);
    }

    public void addServersToBeRestarted(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (ConfigurationDeployment.isServerRunning(stringArray[i])) {
                ManagementLogger.logServerNeedsReboot((String)stringArray[i]);
            }
            this.addServerToBeRestarted(stringArray[i]);
        }
    }

    private static boolean isServerRunning(String string) {
        String string2 = ManagementService.getRuntimeAccess(KERNEL_ID).getServerName();
        if (string2.equals(string)) {
            return true;
        }
        try {
            return URLManager.findAdministrationURL(string) != null;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }
}

