/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import weblogic.deploy.service.Version;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.bootstrap.BootStrap;
import weblogic.security.internal.SerializedSystemIni;

public class ConfigurationVersion
implements Version {
    private static final long serialVersionUID = 239777818908345329L;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private Map versionMap = new HashMap();

    public ConfigurationVersion() {
        this(false);
    }

    public ConfigurationVersion(boolean bl) {
        if (!bl) {
            return;
        }
        String string = SerializedSystemIni.getPath();
        this.addFileToVersionMap(string, string);
        File[] fileArray = BootStrap.getConfigFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            String string2;
            if (fileArray[i].getPath().equals(BootStrap.getConfigLockFileName()) || (string2 = fileArray[i].getAbsolutePath()).indexOf("configCache/crc.ser") != -1 || string2.indexOf("configCache\\crc.ser") != -1) continue;
            this.addFileToVersionMap(fileArray[i].getPath(), fileArray[i].getPath());
        }
        String string3 = DomainDir.getPathRelativeRootDir((String)"fileRealm.properties");
        if (new File(string3).exists()) {
            this.addFileToVersionMap(string3, string3);
        }
    }

    public String getIdentity() {
        return "Configuration";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getVersionComponents() {
        Map map = this.versionMap;
        synchronized (map) {
            return new HashMap(this.versionMap);
        }
    }

    public void addOrUpdateFile(String string, String string2) {
        this.addFileToVersionMap(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(String string) {
        String string2 = this.removeRootDirectoryFromPath(string);
        String string3 = string2.replace('\\', '/');
        Map map = this.versionMap;
        synchronized (map) {
            this.versionMap.remove(string3);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ConfigurationVersion) {
            Map map = this.getVersionComponents();
            Map map2 = ((ConfigurationVersion)object).getVersionComponents();
            boolean bl = ((Object)map).equals(map2);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("ConfigurationVersion equals '" + map + "'.equals('" + map2 + "') : " + bl);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToVersionMap(String string, String string2) {
        Object object;
        long l = 0L;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new CheckedInputStream(new FileInputStream(string), new Adler32());
            object = new byte[128];
            while (filterInputStream.read((byte[])object) >= 0) {
            }
            l = ((CheckedInputStream)filterInputStream).getChecksum().getValue();
        }
        catch (IOException iOException) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Create version for path " + string + " with version " + l);
        }
        object = new Long(l).toString();
        string2 = this.removeRootDirectoryFromPath(string2);
        String string3 = string2.replace('\\', '/');
        Map map = this.versionMap;
        synchronized (map) {
            this.versionMap.put(string3, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("(id: ");
        stringBuffer.append(this.getIdentity());
        stringBuffer.append(", version vector: ");
        Map map = this.versionMap;
        synchronized (map) {
            for (Map.Entry entry : this.versionMap.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                stringBuffer.append("[component: ");
                stringBuffer.append(string);
                stringBuffer.append(":v:");
                stringBuffer.append(string2);
                stringBuffer.append("]");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Map map = this.versionMap;
        synchronized (map) {
            objectOutput.writeObject(this.versionMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Map map = this.versionMap;
        synchronized (map) {
            this.versionMap.putAll((Map)objectInput.readObject());
        }
    }

    public String removeRootDirectoryFromPath(String string) {
        String string2 = new File(DomainDir.getRootDir()).getPath() + File.separator;
        if (string.startsWith(string2) || new File(string).getPath().startsWith(new File(string2).getPath())) {
            return string.substring(string2.length(), string.length());
        }
        return string;
    }
}

