/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.internal.PendingDirectoryManager;
import weblogic.management.internal.ProductionModeHelper;
import weblogic.management.provider.internal.DescriptorInfo;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.management.provider.internal.DescriptorManagerHelper;

public final class DescriptorHelper {
    public static final String BINDING_CONFIG = "schema/weblogic-domain-binding.jar.jar";
    private static boolean skipSetProductionMode = false;
    public static final String RECOVERY_EXTENSION = ".recovery";
    public static final String RECOVERY_NEW_EXTENSION = ".recovery_new";

    public static boolean saveDescriptorTree(Descriptor descriptor, boolean bl, String string) throws IOException {
        return DescriptorHelper.saveDescriptorTree(descriptor, bl, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDescriptorTree(Descriptor descriptor, boolean bl, String string, String string2) throws IOException {
        boolean bl2 = false;
        File file = null;
        File file2 = null;
        boolean bl3 = false;
        OutputStream outputStream = null;
        PendingDirectoryManager pendingDirectoryManager = PendingDirectoryManager.getInstance();
        try {
            Object object;
            if (descriptor.isModified() || !bl) {
                object = (EditableDescriptorManager)DescriptorManagerHelper.getDescriptorManager(true);
                if (bl) {
                    file = new File(DomainDir.getPathRelativePendingDir((String)"config.xml"));
                    if (pendingDirectoryManager.configExists()) {
                        file2 = DescriptorHelper.getRecoveryFile(file);
                        file2.delete();
                        file.renameTo(file2);
                    } else {
                        file2 = DescriptorHelper.getRecoveryFileForNewFile(file);
                        bl3 = true;
                    }
                    outputStream = PendingDirectoryManager.getInstance().getConfigOutputStream();
                } else {
                    outputStream = DescriptorHelper.getFileOutputStream(string, "config.xml");
                }
                object.writeDescriptorAsXML(descriptor, outputStream, string2);
                bl2 = true;
                outputStream.flush();
                outputStream.close();
                outputStream = null;
                file = null;
                if (file2 != null) {
                    file2.delete();
                    file2 = null;
                }
            }
            object = DescriptorInfoUtils.getDescriptorInfos(descriptor);
            while (object != null && object.hasNext()) {
                DescriptorInfo descriptorInfo = (DescriptorInfo)object.next();
                Descriptor descriptor2 = descriptorInfo.getDescriptor();
                if (!descriptor2.isModified() && descriptor2 != descriptor && bl) continue;
                EditableDescriptorManager editableDescriptorManager = (EditableDescriptorManager)descriptorInfo.getDescriptorManager();
                DescriptorBean descriptorBean = descriptorInfo.getDescriptorBean();
                if (bl) {
                    String string3 = descriptorInfo.getConfigurationExtension().getDescriptorFileName();
                    file = new File(DomainDir.getPathRelativePendingDir((String)string3));
                    if (pendingDirectoryManager.fileExists(string3)) {
                        file2 = DescriptorHelper.getRecoveryFile(file);
                        file2.delete();
                        file.renameTo(file2);
                        bl3 = false;
                    } else {
                        file2 = DescriptorHelper.getRecoveryFileForNewFile(file);
                        bl3 = true;
                    }
                    outputStream = pendingDirectoryManager.getFileOutputStream(string3);
                } else {
                    outputStream = DescriptorHelper.getFileOutputStream(string, descriptorInfo.getConfigurationExtension().getDescriptorFileName());
                }
                editableDescriptorManager.writeDescriptorAsXML(descriptorBean.getDescriptor(), outputStream, string2);
                bl2 = true;
                outputStream.close();
                outputStream = null;
                file = null;
                if (file2 == null) continue;
                file2.delete();
                file2 = null;
            }
            boolean bl4 = bl2;
            return bl4;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                if (file != null) {
                    file.delete();
                }
            }
            if (file2 != null) {
                if (bl3) {
                    file2.delete();
                } else {
                    file2.renameTo(file);
                }
            }
        }
    }

    private static OutputStream getFileOutputStream(String string, String string2) throws IOException {
        String string3 = null;
        string3 = string != null ? string + File.separator + "config" + File.separator + string2 : DomainDir.getPathRelativeConfigDir((String)string2);
        File file = new File(string3);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return new FileOutputStream(file);
    }

    private static File getRecoveryFile(File file) throws IOException {
        String string = file.getPath() + RECOVERY_EXTENSION;
        return new File(string);
    }

    private static File getRecoveryFileForNewFile(File file) throws IOException {
        String string = file.getPath() + RECOVERY_NEW_EXTENSION;
        File file2 = new File(string);
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        file2.createNewFile();
        return file2;
    }

    public static void setDescriptorTreeProductionMode(Descriptor descriptor, boolean bl) {
        if (skipSetProductionMode) {
            return;
        }
        descriptor.setProductionMode(bl);
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(descriptor);
        while (iterator != null && iterator.hasNext()) {
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            Descriptor descriptor2 = descriptorInfo.getDescriptor();
            descriptor2.setProductionMode(bl);
        }
    }

    public static void setDescriptorManagerProductionModeIfNeeded(Descriptor descriptor, boolean bl) {
        DescriptorBean descriptorBean;
        if (bl && !ProductionModeHelper.isProductionModePropertySet() && (descriptorBean = descriptor.getRootBean()) instanceof DomainMBean && !descriptor.isEditable()) {
            DescriptorManagerHelper.getDescriptorManager(true).setProductionMode(true);
            DescriptorManagerHelper.getDescriptorManager(false).setProductionMode(true);
        }
    }

    public static boolean recoverPendingDirectory(File[] fileArray) {
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            String string = fileArray[i].getPath();
            if (string.endsWith(RECOVERY_EXTENSION)) {
                file = new File(string.substring(0, string.lastIndexOf(RECOVERY_EXTENSION)));
                file.delete();
                fileArray[i].renameTo(file);
                continue;
            }
            if (!string.endsWith(RECOVERY_NEW_EXTENSION)) continue;
            file = new File(string.substring(0, string.lastIndexOf(RECOVERY_NEW_EXTENSION)));
            file.delete();
            fileArray[i].delete();
            ++n;
        }
        if (n == 0) {
            return true;
        }
        File[] fileArray2 = PendingDirectoryManager.getInstance().getAllFiles();
        return fileArray2 != null && fileArray2.length != 0;
    }

    public static void setSkipSetProductionMode(boolean bl) {
        skipSetProductionMode = bl;
    }
}

