/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.provider.internal.DescriptorInfo;

public final class DescriptorInfoUtils {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");

    public static void addDescriptorInfo(DescriptorInfo descriptorInfo, DescriptorImpl descriptorImpl) {
        Map map = descriptorImpl.getContext();
        ArrayList<DescriptorInfo> arrayList = (ArrayList<DescriptorInfo>)map.get("DescriptorInfo");
        if (arrayList == null) {
            arrayList = new ArrayList<DescriptorInfo>();
            map.put("DescriptorInfo", arrayList);
        }
        arrayList.add(descriptorInfo);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added descriptor info " + descriptorInfo.getDescriptorBean());
        }
    }

    public static DescriptorInfo removeDescriptorInfo(DescriptorBean descriptorBean, Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        List list = (List)map.get("DescriptorInfo");
        if (list == null) {
            throw new AssertionError((Object)"No DescriptorInfo list");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            Descriptor descriptor2 = descriptorInfo.getDescriptor();
            if (descriptor2 == null || descriptorBean == null || !descriptor2.equals(descriptorBean.getDescriptor())) continue;
            iterator.remove();
            DescriptorInfoUtils.addDeletedDescriptorInfo(descriptorInfo, (DescriptorImpl)descriptor);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Removed descriptor info " + descriptorInfo.getDescriptorBean());
            }
            return descriptorInfo;
        }
        return null;
    }

    public static Iterator getDescriptorInfos(Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        List list = (List)map.get("DescriptorInfo");
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static void addDeletedDescriptorInfo(DescriptorInfo descriptorInfo, DescriptorImpl descriptorImpl) {
        Map map = descriptorImpl.getContext();
        ArrayList<DescriptorInfo> arrayList = (ArrayList<DescriptorInfo>)map.get("DeletedDescriptorInfo");
        if (arrayList == null) {
            arrayList = new ArrayList<DescriptorInfo>();
            map.put("DeletedDescriptorInfo", arrayList);
        }
        arrayList.add(descriptorInfo);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added deleted descriptor info " + descriptorInfo.getDescriptorBean());
        }
    }

    public static void removeAllDeletedDescriptorInfos(Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        map.put("DeletedDescriptorInfo", null);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Clear deleted deleted descriptors");
        }
    }

    public static Iterator getDeletedDescriptorInfos(Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        List list = (List)map.get("DeletedDescriptorInfo");
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static void addNotFoundDescriptorInfo(DescriptorInfo descriptorInfo, DescriptorImpl descriptorImpl) {
        Map map = descriptorImpl.getContext();
        ArrayList<DescriptorInfo> arrayList = (ArrayList<DescriptorInfo>)map.get("NotFoundDescriptorInfo");
        if (arrayList == null) {
            arrayList = new ArrayList<DescriptorInfo>();
            map.put("NotFoundDescriptorInfo", arrayList);
        }
        arrayList.add(descriptorInfo);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added not found descriptor info " + descriptorInfo.getDescriptorBean());
        }
    }

    public static Iterator getNotFoundDescriptorInfos(Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        List list = (List)map.get("NotFoundDescriptorInfo");
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static boolean getDescriptorLoadExtensions(Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        Boolean bl = (Boolean)map.get("DescriptorExtensionLoad");
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public static void setDescriptorLoadExtensions(Descriptor descriptor, boolean bl) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        Boolean bl2 = new Boolean(bl);
        map.put("DescriptorExtensionLoad", bl2);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Set descriptor load extension " + bl);
        }
    }

    public static Object getDescriptorConfigExtension(Descriptor descriptor) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        Object v = map.get("DescriptorConfigExtension");
        return v;
    }

    public static void setDescriptorConfigExtension(Descriptor descriptor, Object object, String string) {
        Map map = ((DescriptorImpl)descriptor).getContext();
        map.put("DescriptorConfigExtension", object);
        map.put("DescriptorConfigExtensionAttribute", string);
    }
}

